/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

public class SolverStatistics {
    private double solveTime;
    private int iterations;
    private boolean foundSolution;
    private double minDictionaryRHSColumnEntry;
    private LinearProgramFailureReason failureReason = null;
    private boolean failedForPhaseI = false;

    public void clear() {
        this.solveTime = Double.NaN;
        this.iterations = 0;
        this.foundSolution = false;
        this.minDictionaryRHSColumnEntry = Double.NaN;
        this.failureReason = null;
        this.failedForPhaseI = false;
    }

    public void setSolveTime(double solveTime) {
        this.solveTime = solveTime;
    }

    public int getAndIncrementIterations() {
        return this.iterations++;
    }

    public void setFoundSolution(boolean foundSolution) {
        this.foundSolution = foundSolution;
    }

    public void setMinDictionaryRHSColumnEntry(double minDictionaryRHSColumnEntry) {
        this.minDictionaryRHSColumnEntry = minDictionaryRHSColumnEntry;
    }

    public double getSolveTime() {
        return this.solveTime;
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean foundSolution() {
        return this.foundSolution;
    }

    public double getMinDictionaryRHSColumnEntry() {
        return this.minDictionaryRHSColumnEntry;
    }

    public void onSolutionFound() {
        this.foundSolution = true;
    }

    public void onSolverFailure(LinearProgramFailureReason failureReason, boolean failedForPhaseI) {
        this.foundSolution = false;
        this.failureReason = failureReason;
        this.failedForPhaseI = failedForPhaseI;
    }

    public LinearProgramFailureReason getFailureReason() {
        return this.failureReason;
    }

    public boolean isFailedForPhaseI() {
        return this.failedForPhaseI;
    }

    public String toString() {
        return "Solve time: " + this.solveTime + "\nIterations: " + this.iterations + "\nFound solution: " + this.foundSolution + "\n";
    }

    public static enum LinearProgramFailureReason {
        MAX_ITERATIONS_REACHED,
        NO_CANDIDATE_PIVOT,
        INVALID_PHASE_I_SOLUTION;

    }
}

