/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.convexOptimization.linearProgram.DictionaryFormLinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.convexOptimization.linearProgram.SolverStatistics;
import us.ihmc.matrixlib.MatrixTools;

public class LinearProgramSolver {
    private final DictionaryFormLinearProgramSolver dictionaryFormSolver = new DictionaryFormLinearProgramSolver();
    private final DMatrixRMaj startingDictionary = new DMatrixRMaj(200, 200);
    private final DMatrixRMaj augmentedInequalityMatrix = new DMatrixRMaj(200, 200);
    private final DMatrixRMaj augmentedInequalityVector = new DMatrixRMaj(200, 200);
    private final DMatrixRMaj basisMatrix = new DMatrixRMaj(0);
    private final DMatrixRMaj basisMatrixInv = new DMatrixRMaj(0);
    private final DMatrixRMaj dictionaryLeftColumn = new DMatrixRMaj(0);
    private final DMatrixRMaj tempSensitivityMatrix = new DMatrixRMaj(0);

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, DMatrixRMaj solutionToPack) {
        return this.solve(costVectorC, inequalityConstraintMatrixA, inequalityConstraintVectorB, solutionToPack, SolverMethod.SIMPLEX);
    }

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, DMatrixRMaj equalityConstraintMatrixC, DMatrixRMaj equalityConstraintVectorD, DMatrixRMaj solutionToPack, SolverMethod solverMethod) {
        if (costVectorC.getNumCols() != 1 || inequalityConstraintVectorB.getNumCols() != 1 || equalityConstraintVectorD.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumCols() != costVectorC.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumRows() != inequalityConstraintVectorB.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (equalityConstraintMatrixC.getNumRows() != equalityConstraintVectorD.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumCols() != equalityConstraintMatrixC.getNumCols()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        int constraints = inequalityConstraintMatrixA.getNumRows() + 2 * equalityConstraintMatrixC.getNumRows();
        int dimensionality = inequalityConstraintMatrixA.getNumCols();
        this.augmentedInequalityMatrix.reshape(constraints, dimensionality);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityMatrix, (int)0, (int)0, (DMatrix)inequalityConstraintMatrixA, (int)0, (int)0, (int)inequalityConstraintMatrixA.getNumRows(), (int)inequalityConstraintMatrixA.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityMatrix, (int)inequalityConstraintMatrixA.getNumRows(), (int)0, (DMatrix)equalityConstraintMatrixC, (int)0, (int)0, (int)equalityConstraintMatrixC.getNumRows(), (int)equalityConstraintMatrixC.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityMatrix, (int)(inequalityConstraintMatrixA.getNumRows() + equalityConstraintMatrixC.getNumRows()), (int)0, (DMatrix)equalityConstraintMatrixC, (int)0, (int)0, (int)equalityConstraintMatrixC.getNumRows(), (int)equalityConstraintMatrixC.getNumCols(), (double)-1.0);
        this.augmentedInequalityVector.reshape(constraints, 1);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityVector, (int)0, (int)0, (DMatrix)inequalityConstraintVectorB, (int)0, (int)0, (int)inequalityConstraintVectorB.getNumRows(), (int)inequalityConstraintVectorB.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityVector, (int)inequalityConstraintVectorB.getNumRows(), (int)0, (DMatrix)equalityConstraintVectorD, (int)0, (int)0, (int)equalityConstraintVectorD.getNumRows(), (int)equalityConstraintVectorD.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityVector, (int)(inequalityConstraintVectorB.getNumRows() + equalityConstraintVectorD.getNumRows()), (int)0, (DMatrix)equalityConstraintVectorD, (int)0, (int)0, (int)equalityConstraintVectorD.getNumRows(), (int)equalityConstraintVectorD.getNumCols(), (double)-1.0);
        return this.solve(costVectorC, this.augmentedInequalityMatrix, this.augmentedInequalityVector, solutionToPack, solverMethod);
    }

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, DMatrixRMaj solutionToPack, SolverMethod solverMethod) {
        if (costVectorC.getNumCols() != 1 || inequalityConstraintVectorB.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumCols() != costVectorC.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumRows() != inequalityConstraintVectorB.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        this.startingDictionary.reshape(1 + inequalityConstraintMatrixA.getNumRows(), 1 + inequalityConstraintMatrixA.getNumCols());
        this.startingDictionary.set(0, 0, 0.0);
        MatrixTools.setMatrixBlock((DMatrix)this.startingDictionary, (int)1, (int)0, (DMatrix)inequalityConstraintVectorB, (int)0, (int)0, (int)inequalityConstraintVectorB.getNumRows(), (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.startingDictionary, (int)1, (int)1, (DMatrix)inequalityConstraintMatrixA, (int)0, (int)0, (int)inequalityConstraintMatrixA.getNumRows(), (int)inequalityConstraintMatrixA.getNumCols(), (double)-1.0);
        for (int i = 0; i < costVectorC.getNumRows(); ++i) {
            this.startingDictionary.set(0, 1 + i, costVectorC.get(i));
        }
        if (solverMethod == SolverMethod.CRISS_CROSS) {
            this.dictionaryFormSolver.solveCrissCross(this.startingDictionary);
            if (!this.dictionaryFormSolver.getCrissCrossStatistics().foundSolution()) {
                return false;
            }
        } else {
            this.dictionaryFormSolver.solveSimplex(this.startingDictionary);
            if (!this.dictionaryFormSolver.getSimplexStatistics().foundSolution()) {
                return false;
            }
        }
        solutionToPack.set((DMatrixD1)this.dictionaryFormSolver.getPrimalSolution());
        return true;
    }

    public void solveForFixedBasis(DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, TIntArrayList basisIndices, DMatrixRMaj solutionToPack) {
        int variableIndex;
        int lexicalBasisIndex;
        int basisMatrixColumn;
        int i;
        int numberOfNominalDecisionVariables = inequalityConstraintMatrixA.getNumCols();
        int numberOfConstraints = inequalityConstraintMatrixA.getNumRows();
        this.basisMatrix.reshape(numberOfConstraints, numberOfConstraints);
        this.basisMatrix.zero();
        for (i = 1; i < basisIndices.size(); ++i) {
            basisMatrixColumn = i - 1;
            lexicalBasisIndex = basisIndices.get(i);
            if (LinearProgramSolver.isNonNegativeConstraint(lexicalBasisIndex, numberOfNominalDecisionVariables)) {
                variableIndex = LinearProgramSolver.toVariableIndex(lexicalBasisIndex);
                for (int j = 0; j < numberOfConstraints; ++j) {
                    this.basisMatrix.set(j, basisMatrixColumn, inequalityConstraintMatrixA.get(j, variableIndex));
                }
                continue;
            }
            int constraintIndex = LinearProgramSolver.toConstraintIndex(lexicalBasisIndex, numberOfNominalDecisionVariables);
            this.basisMatrix.set(constraintIndex, basisMatrixColumn, 1.0);
        }
        CommonOps_DDRM.invert((DMatrixRMaj)this.basisMatrix, (DMatrixRMaj)this.basisMatrixInv);
        CommonOps_DDRM.mult((DMatrix1Row)this.basisMatrixInv, (DMatrix1Row)inequalityConstraintVectorB, (DMatrix1Row)this.dictionaryLeftColumn);
        solutionToPack.reshape(numberOfNominalDecisionVariables, 1);
        solutionToPack.zero();
        for (i = 1; i < basisIndices.size(); ++i) {
            basisMatrixColumn = i - 1;
            lexicalBasisIndex = basisIndices.get(i);
            if (!LinearProgramSolver.isNonNegativeConstraint(lexicalBasisIndex, numberOfNominalDecisionVariables)) continue;
            variableIndex = LinearProgramSolver.toVariableIndex(lexicalBasisIndex);
            solutionToPack.set(variableIndex, 0, this.dictionaryLeftColumn.get(basisMatrixColumn, 0));
        }
    }

    public double computeSensitivity(DMatrixRMaj constraintMatrixVariation) {
        return LinearProgramSolver.computeSensitivity(constraintMatrixVariation, this.dictionaryFormSolver.getPrimalSolution(), this.dictionaryFormSolver.getDualSolution(), this.tempSensitivityMatrix);
    }

    public static double computeSensitivity(DMatrixRMaj constraintMatrixVariation, DMatrixRMaj primalSolution, DMatrixRMaj dualSolution, DMatrixRMaj tempSensitivityMatrix) {
        CommonOps_DDRM.mult((DMatrix1Row)constraintMatrixVariation, (DMatrix1Row)primalSolution, (DMatrix1Row)tempSensitivityMatrix);
        return -CommonOps_DDRM.dot((DMatrixD1)dualSolution, (DMatrixD1)tempSensitivityMatrix);
    }

    public DMatrixRMaj getDualSolution() {
        return this.dictionaryFormSolver.getDualSolution();
    }

    public SolverStatistics getSimplexStatistics() {
        return this.dictionaryFormSolver.getSimplexStatistics();
    }

    public SolverStatistics getCrissCrossStatistics() {
        return this.dictionaryFormSolver.getCrissCrossStatistics();
    }

    public DMatrixRMaj getAugmentedInequalityMatrix() {
        return this.augmentedInequalityMatrix;
    }

    public DMatrixRMaj getAugmentedInequalityVector() {
        return this.augmentedInequalityVector;
    }

    public TIntArrayList getBasisIndices() {
        return this.dictionaryFormSolver.getBasisIndices();
    }

    public TIntArrayList getNonBasisIndices() {
        return this.dictionaryFormSolver.getNonBasisIndices();
    }

    public boolean isNonNegativeConstraint(int lexicalIndex) {
        return LinearProgramSolver.isNonNegativeConstraint(lexicalIndex, this.startingDictionary.getNumCols() - 1);
    }

    public int toConstraintIndex(int lexicalIndex) {
        return LinearProgramSolver.toConstraintIndex(lexicalIndex, this.startingDictionary.getNumCols() - 1);
    }

    public static boolean isNonNegativeConstraint(int lexicalIndex, int numCanonicalFormVariables) {
        if (lexicalIndex <= 0) {
            throw new RuntimeException("Invalid lexical index " + lexicalIndex + ", should be a constraint index");
        }
        return lexicalIndex <= numCanonicalFormVariables;
    }

    public static int toVariableIndex(int lexicalIndex) {
        if (lexicalIndex <= 0) {
            throw new RuntimeException("Invalid lexical index " + lexicalIndex + ", should be a constraint index");
        }
        return lexicalIndex - 1;
    }

    public static int toConstraintIndex(int lexicalIndex, int numCanonicalFormVariables) {
        if (lexicalIndex <= 0) {
            throw new RuntimeException("Invalid lexical index " + lexicalIndex + ", should be a constraint index");
        }
        return lexicalIndex - numCanonicalFormVariables - 1;
    }
}

