/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.apache.commons.math3.util.Precision;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.convexOptimization.linearProgram.LinearProgramDictionary;
import us.ihmc.convexOptimization.linearProgram.LinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.convexOptimization.linearProgram.SolverStatistics;

public class DictionaryFormLinearProgramSolver {
    static final boolean debug = false;
    static final int maxVariables = 200;
    static final int maxCrissCrossIterations = 50000;
    static final int maxSimplexIterations = 1000;
    static final int nullMatrixIndex = -1;
    static final double epsilon = 1.0E-6;
    static final double zeroCutoff = 1.0E-10;
    private final LinearProgramDictionary dictionary = new LinearProgramDictionary();
    private final DMatrixRMaj primalSolution = new DMatrixRMaj(200);
    private final DMatrixRMaj dualSolution = new DMatrixRMaj(200);
    private final Stopwatch timer = new Stopwatch();
    private final SolverStatistics simplexStatistics = new SolverStatistics();
    private final SolverStatistics crissCrossStatistics = new SolverStatistics();
    private final TIntArrayList minRatioIndices = new TIntArrayList(201);

    public void solveSimplex(DMatrixRMaj startingDictionary) {
        if (startingDictionary.getNumCols() > 200) {
            throw new IllegalArgumentException("Simplex method has a maximum of 200 decision variables, " + startingDictionary.getNumCols() + " provided.");
        }
        this.timer.reset();
        this.simplexStatistics.clear();
        if (this.dictionary.initialize(startingDictionary, SolverMethod.SIMPLEX)) {
            this.performSimplexPhase(SimplexPhase.PHASE_I);
            if (!this.simplexStatistics.foundSolution()) {
                return;
            }
            if (this.dictionary.getEntry(0, 0) < -1.0E-6) {
                this.simplexStatistics.onSolverFailure(SolverStatistics.LinearProgramFailureReason.INVALID_PHASE_I_SOLUTION, true);
                return;
            }
            this.dictionary.dropPhaseIVariables();
        }
        this.performSimplexPhase(SimplexPhase.PHASE_II);
        this.packSolution(this.simplexStatistics);
        this.simplexStatistics.setSolveTime(this.timer.lapElapsed());
    }

    void performSimplexPhase(SimplexPhase phase) {
        while (true) {
            if (this.simplexStatistics.getAndIncrementIterations() > 1000) {
                this.simplexStatistics.onSolverFailure(SolverStatistics.LinearProgramFailureReason.MAX_ITERATIONS_REACHED, phase == SimplexPhase.PHASE_I);
                break;
            }
            if (this.isSimplexOptimal()) {
                this.simplexStatistics.onSolutionFound();
                break;
            }
            int s = this.computeSimplexPivotColumn();
            int r = this.computeSimplexPivotRow(s, phase);
            if (r == -1) {
                this.simplexStatistics.onSolverFailure(SolverStatistics.LinearProgramFailureReason.NO_CANDIDATE_PIVOT, phase == SimplexPhase.PHASE_I);
                break;
            }
            this.dictionary.performPivot(r, s);
        }
    }

    private void packSolution(SolverStatistics solverStatistics) {
        double entry;
        int lexicalIndex;
        int i;
        this.primalSolution.reshape(this.dictionary.getNumberOfColumns() - 1, 1);
        this.dualSolution.reshape(this.dictionary.getNumberOfRows() - 1, 1);
        Arrays.fill(this.primalSolution.getData(), 0.0);
        Arrays.fill(this.dualSolution.getData(), 0.0);
        double minDictionaryRHSColumnEntry = Double.POSITIVE_INFINITY;
        for (i = 1; i < this.dictionary.getBasisSize(); ++i) {
            lexicalIndex = this.dictionary.getBasisIndex(i);
            entry = this.dictionary.getEntry(i, 0);
            minDictionaryRHSColumnEntry = Math.min(entry, minDictionaryRHSColumnEntry);
            if (!LinearProgramSolver.isNonNegativeConstraint(lexicalIndex, this.primalSolution.getNumRows())) continue;
            int variableIndex = LinearProgramSolver.toVariableIndex(lexicalIndex);
            this.primalSolution.set(variableIndex, entry);
        }
        for (i = 1; i < this.dictionary.getNonBasisSize(); ++i) {
            lexicalIndex = this.dictionary.getNonBasisIndex(i);
            entry = this.dictionary.getEntry(0, i);
            if (LinearProgramSolver.isNonNegativeConstraint(lexicalIndex, this.primalSolution.getNumRows())) continue;
            int constraintIndex = LinearProgramSolver.toConstraintIndex(lexicalIndex, this.primalSolution.getNumRows());
            this.dualSolution.set(constraintIndex, -entry);
        }
        solverStatistics.setMinDictionaryRHSColumnEntry(minDictionaryRHSColumnEntry);
    }

    private boolean isSimplexOptimal() {
        for (int j = 1; j < this.dictionary.getNumberOfColumns(); ++j) {
            if (!(this.dictionary.getEntry(0, j) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private int computeSimplexPivotColumn() {
        int minimumEntryIndex = Integer.MAX_VALUE;
        int column = -1;
        for (int j = 1; j < this.dictionary.getNumberOfColumns(); ++j) {
            int index;
            double entry = this.dictionary.getEntry(0, j);
            if (entry < 1.0E-6 || (index = this.dictionary.getNonBasisIndex(j)) >= minimumEntryIndex) continue;
            minimumEntryIndex = index;
            column = j;
        }
        return column;
    }

    private int computeSimplexPivotRow(int column, SimplexPhase phase) {
        double minRatio = Double.MAX_VALUE;
        this.minRatioIndices.reset();
        for (int i = phase.objectiveSize(); i < this.dictionary.getNumberOfRows(); ++i) {
            double d_ig = this.dictionary.getEntry(i, 0);
            double d_is = this.dictionary.getEntry(i, column);
            if (d_is > -1.0E-6) continue;
            double ratio = Math.abs(d_ig / d_is);
            int cmp = Precision.compareTo((double)ratio, (double)minRatio, (double)1.0E-6);
            if (cmp == 0) {
                this.minRatioIndices.add(i);
                continue;
            }
            if (cmp >= 0) continue;
            this.minRatioIndices.reset();
            this.minRatioIndices.add(i);
            minRatio = ratio;
        }
        if (this.minRatioIndices.isEmpty()) {
            return -1;
        }
        if (this.minRatioIndices.size() > 1) {
            int minRowIndex = Integer.MAX_VALUE;
            int minRow = -1;
            for (int i = 0; i < this.minRatioIndices.size(); ++i) {
                int variableIndex = this.dictionary.getBasisIndex(this.minRatioIndices.get(i));
                if (variableIndex >= minRowIndex) continue;
                minRowIndex = variableIndex;
                minRow = this.minRatioIndices.get(i);
            }
            return minRow;
        }
        return this.minRatioIndices.get(0);
    }

    public DMatrixRMaj getPrimalSolution() {
        return this.primalSolution;
    }

    public DMatrixRMaj getDualSolution() {
        return this.dualSolution;
    }

    public void printSolution() {
        System.out.println("Solution:");
        for (int i = 0; i < this.primalSolution.getNumRows(); ++i) {
            System.out.println("\t " + this.primalSolution.get(i));
        }
    }

    public void solveCrissCross(DMatrixRMaj startingDictionary) {
        this.crissCrossStatistics.clear();
        this.timer.reset();
        this.dictionary.initialize(startingDictionary, SolverMethod.CRISS_CROSS);
        while (true) {
            int basisPivot;
            int nonBasisPivot;
            if (this.crissCrossStatistics.getAndIncrementIterations() > 50000) {
                this.crissCrossStatistics.setFoundSolution(false);
                break;
            }
            int candidateBasisPivot = this.findNegativeColumnEntryWithBlandRule(0);
            int candidateNonBasisPivot = this.findPositiveRowEntryWithBlandRule(0);
            if (candidateBasisPivot == -1 && candidateNonBasisPivot == -1) {
                this.crissCrossStatistics.onSolutionFound();
                break;
            }
            if (candidateBasisPivot != -1 && (candidateNonBasisPivot == -1 || this.dictionary.getBasisIndex(candidateBasisPivot) < this.dictionary.getNonBasisIndex(candidateNonBasisPivot)) ? (nonBasisPivot = this.findPositiveRowEntryWithBlandRule(basisPivot = candidateBasisPivot)) == -1 : (basisPivot = this.findNegativeColumnEntryWithBlandRule(nonBasisPivot = candidateNonBasisPivot)) == -1) break;
            this.dictionary.performPivot(basisPivot, nonBasisPivot);
        }
        this.packSolution(this.crissCrossStatistics);
        this.crissCrossStatistics.setSolveTime(this.timer.totalElapsed());
    }

    private int findNegativeColumnEntryWithBlandRule(int column) {
        int minLexicalIndex = Integer.MAX_VALUE;
        int row = -1;
        for (int i = 1; i < this.dictionary.getNumberOfRows(); ++i) {
            double d_ig = this.dictionary.getEntry(i, column);
            int lexicalIndex = this.dictionary.getBasisIndex(i);
            if (!(d_ig < -1.0E-6) || lexicalIndex >= minLexicalIndex) continue;
            minLexicalIndex = lexicalIndex;
            row = i;
        }
        return row;
    }

    private int findPositiveRowEntryWithBlandRule(int row) {
        int minLexicalIndex = Integer.MAX_VALUE;
        int column = -1;
        for (int j = 1; j < this.dictionary.getNumberOfColumns(); ++j) {
            double d_fj = this.dictionary.getEntry(row, j);
            int lexicalIndex = this.dictionary.getNonBasisIndex(j);
            if (!(d_fj > 1.0E-6) || lexicalIndex >= minLexicalIndex) continue;
            minLexicalIndex = lexicalIndex;
            column = j;
        }
        return column;
    }

    public SolverStatistics getCrissCrossStatistics() {
        return this.crissCrossStatistics;
    }

    public SolverStatistics getSimplexStatistics() {
        return this.simplexStatistics;
    }

    public TIntArrayList getBasisIndices() {
        return this.dictionary.getBasisIndices();
    }

    public TIntArrayList getNonBasisIndices() {
        return this.dictionary.getNonBasisIndices();
    }

    private static enum SimplexPhase {
        PHASE_I,
        PHASE_II;


        int objectiveSize() {
            return this == PHASE_I ? 2 : 1;
        }
    }
}

