/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.quadraticProgram.JavaQuadProgSolver;
import us.ihmc.convexOptimization.quadraticProgram.NativeActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.matrixlib.NativeMatrix;

public class JavaQuadProgSolverWithInactiveVariables
extends JavaQuadProgSolver
implements NativeActiveSetQPSolverWithInactiveVariablesInterface {
    private final DMatrixRMaj originalQuadraticCostQMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalQuadraticCostQVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalLinearEqualityConstraintsAMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalLinearEqualityConstraintsBVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalLinearInequalityConstraintsCMatrixO = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalLinearInequalityConstraintsDVectorO = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalLowerBoundsCMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalVariableLowerBounds = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalUpperBoundsCMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj originalVariableUpperBounds = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj activeVariables = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj activeVariableSolution = new DMatrixRMaj(0, 0);

    @Override
    public NativeMatrix getCostHessianUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getCostGradientUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getAeqUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getBeqUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getAinUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getBinUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getLowerBoundsUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public NativeMatrix getUpperBoundsUnsafe() {
        throw new RuntimeException("Can't do this.");
    }

    @Override
    public void setActiveVariables(DMatrix activeVariables) {
        if (activeVariables.getNumRows() != this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("activeVariables.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.activeVariables.set((Matrix)activeVariables);
    }

    @Override
    public void setVariableActive(int variableIndex) {
        if (variableIndex < 0 || variableIndex >= this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variable index is outside the number of variables: " + variableIndex);
        }
        if (variableIndex >= this.activeVariables.getNumRows()) {
            return;
        }
        this.activeVariables.set(variableIndex, 0, 1.0);
    }

    @Override
    public void setVariableInactive(int variableIndex) {
        if (variableIndex < 0 || variableIndex >= this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variable index is outside the number of variables: " + variableIndex);
        }
        if (variableIndex >= this.activeVariables.getNumRows()) {
            this.activeVariables.reshape(variableIndex + 1, 1, true);
        }
        this.activeVariables.set(variableIndex, 0, 0.0);
    }

    @Override
    public void setAllVariablesActive() {
        this.activeVariables.reshape(this.originalQuadraticCostQMatrix.getNumRows(), 1);
        CommonOps_DDRM.fill((DMatrixD1)this.activeVariables, (double)1.0);
    }

    @Override
    public void setLowerBounds(DMatrix variableLowerBounds) {
        int numberOfLowerBounds = variableLowerBounds.getNumRows();
        if (numberOfLowerBounds != this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableLowerBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.originalLowerBoundsCMatrix.reshape(numberOfLowerBounds, numberOfLowerBounds);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.originalLowerBoundsCMatrix);
        this.originalVariableLowerBounds.set((Matrix)variableLowerBounds);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.originalVariableLowerBounds);
    }

    @Override
    public void setUpperBounds(DMatrix variableUpperBounds) {
        int numberOfUpperBounds = variableUpperBounds.getNumRows();
        if (numberOfUpperBounds != this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableUpperBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.originalUpperBoundsCMatrix.reshape(numberOfUpperBounds, numberOfUpperBounds);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.originalUpperBoundsCMatrix);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.originalUpperBoundsCMatrix);
        this.originalVariableUpperBounds.set((Matrix)variableUpperBounds);
    }

    @Override
    public void setQuadraticCostFunction(DMatrix costQuadraticMatrix, DMatrix costLinearVector, double quadraticCostScalar) {
        if (costLinearVector.getNumCols() != 1) {
            throw new RuntimeException("costLinearVector.getNumCols() != 1");
        }
        if (costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()");
        }
        if (costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()");
        }
        this.originalQuadraticCostQMatrix.set((Matrix)costQuadraticMatrix);
        this.originalQuadraticCostQVector.set((Matrix)costLinearVector);
        this.quadraticCostScalar = quadraticCostScalar;
        this.setAllVariablesActive();
    }

    @Override
    public double getObjectiveCost(DMatrixRMaj x) {
        NativeCommonOps.multQuad((DMatrix1Row)x, (DMatrix1Row)this.originalQuadraticCostQMatrix, (DMatrix1Row)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.originalQuadraticCostQVector, (DMatrix1Row)x, (DMatrix1Row)this.computedObjectiveFunctionValue);
        return this.computedObjectiveFunctionValue.get(0, 0) + this.quadraticCostScalar;
    }

    @Override
    public void setLinearEqualityConstraints(DMatrix linearEqualityConstraintsAMatrix, DMatrix linearEqualityConstraintsBVector) {
        int numberOfEqualityConstraints = linearEqualityConstraintsBVector.getNumRows();
        if (linearEqualityConstraintsBVector.getNumCols() != 1) {
            throw new RuntimeException("linearEqualityConstraintsBVector.getNumCols() != 1");
        }
        if (linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()");
        }
        if (linearEqualityConstraintsAMatrix.getNumCols() != this.originalQuadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.originalLinearEqualityConstraintsAMatrix.reshape(linearEqualityConstraintsAMatrix.getNumCols(), numberOfEqualityConstraints);
        JavaQuadProgSolverWithInactiveVariables.standardTranspose(linearEqualityConstraintsAMatrix, (DMatrix1Row)this.originalLinearEqualityConstraintsAMatrix);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.originalLinearEqualityConstraintsAMatrix);
        this.originalLinearEqualityConstraintsBVector.set((Matrix)linearEqualityConstraintsBVector);
    }

    @Override
    public void setLinearInequalityConstraints(DMatrix linearInequalityConstraintCMatrix, DMatrix linearInequalityConstraintDVector) {
        int numberOfInequalityConstraints = linearInequalityConstraintDVector.getNumRows();
        if (linearInequalityConstraintDVector.getNumCols() != 1) {
            throw new RuntimeException("linearInequalityConstraintDVector.getNumCols() != 1");
        }
        if (linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()");
        }
        if (linearInequalityConstraintCMatrix.getNumCols() != this.originalQuadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.originalLinearInequalityConstraintsCMatrixO.reshape(linearInequalityConstraintCMatrix.getNumCols(), numberOfInequalityConstraints);
        JavaQuadProgSolverWithInactiveVariables.standardTranspose(linearInequalityConstraintCMatrix, (DMatrix1Row)this.originalLinearInequalityConstraintsCMatrixO);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.originalLinearInequalityConstraintsCMatrixO);
        this.originalLinearInequalityConstraintsDVectorO.set((Matrix)linearInequalityConstraintDVector);
    }

    @Override
    public void clear() {
        super.clear();
        this.originalQuadraticCostQMatrix.reshape(0, 0);
        this.originalQuadraticCostQVector.reshape(0, 0);
        this.originalLinearEqualityConstraintsAMatrix.reshape(0, 0);
        this.originalLinearEqualityConstraintsBVector.reshape(0, 0);
        this.originalLinearInequalityConstraintsCMatrixO.reshape(0, 0);
        this.originalLinearInequalityConstraintsDVectorO.reshape(0, 0);
        this.originalLowerBoundsCMatrix.reshape(0, 0);
        this.originalVariableLowerBounds.reshape(0, 0);
        this.originalUpperBoundsCMatrix.reshape(0, 0);
        this.originalVariableUpperBounds.reshape(0, 0);
        this.activeVariables.reshape(0, 0);
        this.activeVariableSolution.reshape(0, 0);
    }

    @Override
    public int solve(DMatrix solutionToPack) {
        this.removeInactiveVariables();
        if (solutionToPack.getNumRows() != this.originalQuadraticCostQMatrix.numRows || solutionToPack.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        this.activeVariableSolution.reshape(this.quadraticCostQMatrix.numRows, 1);
        int numberOfIterations = super.solve((DMatrix)this.activeVariableSolution);
        this.copyActiveVariableSolutionToAllVariables(solutionToPack, this.activeVariableSolution);
        return numberOfIterations;
    }

    private void setMatricesFromOriginal() {
        this.quadraticCostQMatrix.set((DMatrixD1)this.originalQuadraticCostQMatrix);
        this.quadraticCostQVector.set((DMatrixD1)this.originalQuadraticCostQVector);
        this.linearEqualityConstraintsAMatrix.set((DMatrixD1)this.originalLinearEqualityConstraintsAMatrix);
        this.linearEqualityConstraintsBVector.set((DMatrixD1)this.originalLinearEqualityConstraintsBVector);
        this.linearInequalityConstraintsCMatrixO.set((DMatrixD1)this.originalLinearInequalityConstraintsCMatrixO);
        this.linearInequalityConstraintsDVectorO.set((DMatrixD1)this.originalLinearInequalityConstraintsDVectorO);
        this.lowerBoundsCMatrix.set((DMatrixD1)this.originalLowerBoundsCMatrix);
        this.variableLowerBounds.set((DMatrixD1)this.originalVariableLowerBounds);
        this.upperBoundsCMatrix.set((DMatrixD1)this.originalUpperBoundsCMatrix);
        this.variableUpperBounds.set((DMatrixD1)this.originalVariableUpperBounds);
    }

    private void removeInactiveVariables() {
        this.setMatricesFromOriginal();
        for (int variableIndex = this.activeVariables.getNumRows() - 1; variableIndex >= 0; --variableIndex) {
            if (this.activeVariables.get(variableIndex) == 1.0) continue;
            MatrixTools.removeRow((DMatrix1Row)this.quadraticCostQMatrix, (int)variableIndex);
            MatrixTools.removeColumn((DMatrix1Row)this.quadraticCostQMatrix, (int)variableIndex);
            MatrixTools.removeRow((DMatrix1Row)this.quadraticCostQVector, (int)variableIndex);
            if (this.linearEqualityConstraintsAMatrix.getNumElements() > 0) {
                MatrixTools.removeRow((DMatrix1Row)this.linearEqualityConstraintsAMatrix, (int)variableIndex);
            }
            if (this.linearInequalityConstraintsCMatrixO.getNumElements() > 0) {
                MatrixTools.removeRow((DMatrix1Row)this.linearInequalityConstraintsCMatrixO, (int)variableIndex);
            }
            if (this.variableLowerBounds.getNumElements() > 0) {
                MatrixTools.removeRow((DMatrix1Row)this.variableLowerBounds, (int)variableIndex);
                MatrixTools.removeRow((DMatrix1Row)this.lowerBoundsCMatrix, (int)variableIndex);
                MatrixTools.removeColumn((DMatrix1Row)this.lowerBoundsCMatrix, (int)variableIndex);
            }
            if (this.variableUpperBounds.getNumElements() <= 0) continue;
            MatrixTools.removeRow((DMatrix1Row)this.variableUpperBounds, (int)variableIndex);
            MatrixTools.removeRow((DMatrix1Row)this.upperBoundsCMatrix, (int)variableIndex);
            MatrixTools.removeColumn((DMatrix1Row)this.upperBoundsCMatrix, (int)variableIndex);
        }
        int numVars = this.quadraticCostQMatrix.getNumRows();
        if (this.linearEqualityConstraintsAMatrix.getNumElements() == 0) {
            this.linearEqualityConstraintsAMatrix.reshape(numVars, 0);
        }
        if (this.linearInequalityConstraintsCMatrixO.getNumElements() == 0) {
            this.linearInequalityConstraintsCMatrixO.reshape(numVars, 0);
        }
        JavaQuadProgSolverWithInactiveVariables.removeZeroColumnsFromConstraints(this.linearEqualityConstraintsAMatrix, this.linearEqualityConstraintsBVector);
        JavaQuadProgSolverWithInactiveVariables.removeZeroColumnsFromConstraints(this.linearInequalityConstraintsCMatrixO, this.linearInequalityConstraintsDVectorO);
    }

    private static void removeZeroColumnsFromConstraints(DMatrixRMaj matrix, DMatrixRMaj vector) {
        for (int rowIndex = vector.numRows - 1; rowIndex >= 0; --rowIndex) {
            double sumOfRowElements = 0.0;
            for (int columnIndex = 0; columnIndex < matrix.getNumRows(); ++columnIndex) {
                sumOfRowElements += Math.abs(matrix.get(columnIndex, rowIndex));
            }
            boolean isZeroColumn = MathTools.epsilonEquals((double)sumOfRowElements, (double)0.0, (double)1.0E-12);
            if (!isZeroColumn) continue;
            MatrixTools.removeColumn((DMatrix1Row)matrix, (int)rowIndex);
            MatrixTools.removeRow((DMatrix1Row)vector, (int)rowIndex);
        }
    }

    private void copyActiveVariableSolutionToAllVariables(DMatrix solutionToPack, DMatrixRMaj activeVariableSolution) {
        if (MatrixTools.containsNaN((DMatrix1Row)activeVariableSolution)) {
            for (int i = 0; i < solutionToPack.getNumRows(); ++i) {
                solutionToPack.set(i, 0, Double.NaN);
            }
            return;
        }
        int activeVariableIndex = 0;
        for (int variableIndex = 0; variableIndex < solutionToPack.getNumRows(); ++variableIndex) {
            if (this.activeVariables.get(variableIndex) != 1.0) continue;
            solutionToPack.set(variableIndex, 0, activeVariableSolution.get(activeVariableIndex, 0));
            ++activeVariableIndex;
        }
    }
}

