/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.convexOptimization.linearProgram.DictionaryFormLinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.convexOptimization.linearProgram.SolverStatistics;
import us.ihmc.matrixlib.MatrixTools;

public class LinearProgramSolver {
    private final DMatrixRMaj startingDictionary = new DMatrixRMaj(200, 200);
    private final DictionaryFormLinearProgramSolver dictionaryFormSolver = new DictionaryFormLinearProgramSolver();
    private final DMatrixRMaj augmentedInequalityMatrix = new DMatrixRMaj(200, 200);
    private final DMatrixRMaj augmentedInequalityVector = new DMatrixRMaj(200, 200);

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, DMatrixRMaj solutionToPack) {
        return this.solve(costVectorC, inequalityConstraintMatrixA, inequalityConstraintVectorB, solutionToPack, SolverMethod.SIMPLEX);
    }

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, DMatrixRMaj equalityConstraintMatrixC, DMatrixRMaj equalityConstraintVectorD, DMatrixRMaj solutionToPack, SolverMethod solverMethod) {
        if (costVectorC.getNumCols() != 1 || inequalityConstraintVectorB.getNumCols() != 1 || equalityConstraintVectorD.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumCols() != costVectorC.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumRows() != inequalityConstraintVectorB.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (equalityConstraintMatrixC.getNumRows() != equalityConstraintVectorD.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumCols() != equalityConstraintMatrixC.getNumCols()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        int constraints = inequalityConstraintMatrixA.getNumRows() + 2 * equalityConstraintMatrixC.getNumRows();
        int dimensionality = inequalityConstraintMatrixA.getNumCols();
        this.augmentedInequalityMatrix.reshape(constraints, dimensionality);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityMatrix, (int)0, (int)0, (DMatrix)inequalityConstraintMatrixA, (int)0, (int)0, (int)inequalityConstraintMatrixA.getNumRows(), (int)inequalityConstraintMatrixA.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityMatrix, (int)inequalityConstraintMatrixA.getNumRows(), (int)0, (DMatrix)equalityConstraintMatrixC, (int)0, (int)0, (int)equalityConstraintMatrixC.getNumRows(), (int)equalityConstraintMatrixC.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityMatrix, (int)(inequalityConstraintMatrixA.getNumRows() + equalityConstraintMatrixC.getNumRows()), (int)0, (DMatrix)equalityConstraintMatrixC, (int)0, (int)0, (int)equalityConstraintMatrixC.getNumRows(), (int)equalityConstraintMatrixC.getNumCols(), (double)-1.0);
        this.augmentedInequalityVector.reshape(constraints, 1);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityVector, (int)0, (int)0, (DMatrix)inequalityConstraintVectorB, (int)0, (int)0, (int)inequalityConstraintVectorB.getNumRows(), (int)inequalityConstraintVectorB.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityVector, (int)inequalityConstraintVectorB.getNumRows(), (int)0, (DMatrix)equalityConstraintVectorD, (int)0, (int)0, (int)equalityConstraintVectorD.getNumRows(), (int)equalityConstraintVectorD.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.augmentedInequalityVector, (int)(inequalityConstraintVectorB.getNumRows() + equalityConstraintVectorD.getNumRows()), (int)0, (DMatrix)equalityConstraintVectorD, (int)0, (int)0, (int)equalityConstraintVectorD.getNumRows(), (int)equalityConstraintVectorD.getNumCols(), (double)-1.0);
        return this.solve(costVectorC, this.augmentedInequalityMatrix, this.augmentedInequalityVector, solutionToPack, solverMethod);
    }

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj inequalityConstraintMatrixA, DMatrixRMaj inequalityConstraintVectorB, DMatrixRMaj solutionToPack, SolverMethod solverMethod) {
        if (costVectorC.getNumCols() != 1 || inequalityConstraintVectorB.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumCols() != costVectorC.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (inequalityConstraintMatrixA.getNumRows() != inequalityConstraintVectorB.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        this.startingDictionary.reshape(1 + inequalityConstraintMatrixA.getNumRows(), 1 + inequalityConstraintMatrixA.getNumCols());
        Arrays.fill(this.startingDictionary.getData(), 0.0);
        MatrixTools.setMatrixBlock((DMatrix)this.startingDictionary, (int)1, (int)0, (DMatrix)inequalityConstraintVectorB, (int)0, (int)0, (int)inequalityConstraintVectorB.getNumRows(), (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.startingDictionary, (int)1, (int)1, (DMatrix)inequalityConstraintMatrixA, (int)0, (int)0, (int)inequalityConstraintMatrixA.getNumRows(), (int)inequalityConstraintMatrixA.getNumCols(), (double)-1.0);
        for (int i = 0; i < costVectorC.getNumRows(); ++i) {
            this.startingDictionary.set(0, 1 + i, costVectorC.get(i));
        }
        if (solverMethod == SolverMethod.CRISS_CROSS) {
            this.dictionaryFormSolver.solveCrissCross(this.startingDictionary);
            if (!this.dictionaryFormSolver.getCrissCrossStatistics().foundSolution()) {
                return false;
            }
        } else {
            this.dictionaryFormSolver.solveSimplex(this.startingDictionary);
            if (!this.dictionaryFormSolver.getPhase2Statistics().foundSolution()) {
                return false;
            }
        }
        solutionToPack.set((DMatrixD1)this.dictionaryFormSolver.getSolution());
        return true;
    }

    public SolverStatistics getSimplexStatistics() {
        return this.dictionaryFormSolver.getPhase2Statistics();
    }

    public SolverStatistics getCrissCrossStatistics() {
        return this.dictionaryFormSolver.getCrissCrossStatistics();
    }

    public DMatrixRMaj getAugmentedInequalityMatrix() {
        return this.augmentedInequalityMatrix;
    }

    public DMatrixRMaj getAugmentedInequalityVector() {
        return this.augmentedInequalityVector;
    }
}

