/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.randomSearch;

import java.util.Random;
import us.ihmc.convexOptimization.ConvexOptimizationAdapter;

public class RandomSearchConvexOptimizationAdapter
implements ConvexOptimizationAdapter {
    private static final boolean DEBUG = false;
    private double[] linearCostFunctionFVector;
    private double[][] quadraticCostFunctionPMatrix;
    private double[] quadraticCostFunctionQVector;
    private double quadraticCostFunctionR;
    private double[][] linearEqualityConstraintsAMatrix;
    private double[] linearEqualityConstraintsBVector;
    private double[][] linearInequalityConstraintCVectors;
    private double[] linearInequalityConstraintBs;

    @Override
    public void setLinearCostFunctionVector(double[] linearCostFunctionFVector) {
        this.linearCostFunctionFVector = linearCostFunctionFVector;
    }

    @Override
    public void setQuadraticCostFunction(double[][] quadraticCostFunctionPMatrix, double[] quadraticCostFunctionQVector, double quadraticCostFunctionR) {
        this.quadraticCostFunctionPMatrix = quadraticCostFunctionPMatrix;
        this.quadraticCostFunctionQVector = quadraticCostFunctionQVector;
        this.quadraticCostFunctionR = quadraticCostFunctionR;
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public void setLinearEqualityConstraintsAMatrix(double[][] linearEqualityConstraintsAMatrix) {
        this.linearEqualityConstraintsAMatrix = linearEqualityConstraintsAMatrix;
    }

    @Override
    public void setLinearEqualityConstraintsBVector(double[] linearEqualityConstraintsBVector) {
        this.linearEqualityConstraintsBVector = linearEqualityConstraintsBVector;
    }

    @Override
    public void setLinearInequalityConstraints(double[][] linearInequalityConstraintCVectors, double[] linearInequalityConstraintBs) {
        this.linearInequalityConstraintCVectors = linearInequalityConstraintCVectors;
        this.linearInequalityConstraintBs = linearInequalityConstraintBs;
    }

    @Override
    public double[] solve() {
        Random random = new Random(1776L);
        double epsilonForLinearEqualityConstraints = 0.002;
        int numberOfVariables = this.linearCostFunctionFVector.length;
        double[] bestXGuess = new double[numberOfVariables];
        double bestCost = this.computeCost(this.linearCostFunctionFVector, bestXGuess);
        double[] bestLinearEqualityConstraintErrors = null;
        if (this.linearEqualityConstraintsAMatrix != null) {
            bestLinearEqualityConstraintErrors = new double[this.linearEqualityConstraintsAMatrix.length];
        }
        this.computeLinearEqualityConstraintErrors(bestXGuess, this.linearEqualityConstraintsAMatrix, this.linearEqualityConstraintsBVector, bestLinearEqualityConstraintErrors);
        boolean bestLinearEqualityConstraintsAreMet = this.areAllLinearEqualityConstraintsMet(bestLinearEqualityConstraintErrors, epsilonForLinearEqualityConstraints);
        double[] bestLinearInequalityConstraintSums = null;
        if (this.linearInequalityConstraintCVectors != null) {
            bestLinearInequalityConstraintSums = new double[this.linearInequalityConstraintCVectors.length];
        }
        this.computeLinearInequalityConstraintSums(bestXGuess, this.linearInequalityConstraintCVectors, this.linearInequalityConstraintBs, bestLinearInequalityConstraintSums);
        boolean bestLinearInequalityConstraintsAreMet = this.areAllLinearInequalityConstraintsMet(bestLinearInequalityConstraintSums);
        double minimumDelta = 0.001;
        double maximumDelta = 10.0;
        double deltaReductionFactor = 0.9;
        double deltaIncreaseFactor = 1.2;
        double delta = 0.001;
        int numberOfIterations = 100000;
        int iterationNumber = 0;
        while (iterationNumber++ < numberOfIterations) {
            double[] newXGuess = this.generateRandomGuess(random, bestXGuess, delta);
            double newCost = this.computeCost(this.linearCostFunctionFVector, newXGuess);
            double[] newLinearEqualityConstraintErrors = null;
            double[] newLinearInequalityConstraintSums = null;
            if (this.linearEqualityConstraintsAMatrix != null) {
                newLinearEqualityConstraintErrors = new double[this.linearEqualityConstraintsAMatrix.length];
            }
            this.computeLinearEqualityConstraintErrors(newXGuess, this.linearEqualityConstraintsAMatrix, this.linearEqualityConstraintsBVector, newLinearEqualityConstraintErrors);
            boolean newLinearEqualityConstraintsAreMet = this.areAllLinearEqualityConstraintsMet(newLinearEqualityConstraintErrors, epsilonForLinearEqualityConstraints);
            if (bestLinearEqualityConstraintsAreMet && !newLinearEqualityConstraintsAreMet) {
                delta = this.decreaseDelta(delta, deltaReductionFactor, minimumDelta);
                continue;
            }
            if (newLinearEqualityConstraintsAreMet && !bestLinearEqualityConstraintsAreMet) {
                this.printIfDebug("Found a linear equality constraint satisfaction!");
                bestXGuess = newXGuess;
                bestCost = newCost;
                bestLinearEqualityConstraintErrors = newLinearEqualityConstraintErrors;
                bestLinearEqualityConstraintsAreMet = newLinearEqualityConstraintsAreMet;
                this.printOutBestGuess(bestXGuess);
                delta = this.increaseDelta(delta, deltaIncreaseFactor, maximumDelta);
                continue;
            }
            if (!newLinearEqualityConstraintsAreMet) {
                if (this.areAllEqualityConstraintsSameOrImproved(bestLinearEqualityConstraintErrors, newLinearEqualityConstraintErrors, epsilonForLinearEqualityConstraints)) {
                    this.printIfDebug("Found reduced linear equality constraint violations!");
                    bestXGuess = newXGuess;
                    bestCost = newCost;
                    bestLinearEqualityConstraintErrors = newLinearEqualityConstraintErrors;
                    bestLinearEqualityConstraintsAreMet = newLinearEqualityConstraintsAreMet;
                    this.printOutBestGuess(bestXGuess);
                    delta = this.increaseDelta(delta, deltaIncreaseFactor, maximumDelta);
                    continue;
                }
                delta = this.decreaseDelta(delta, deltaReductionFactor, minimumDelta);
                continue;
            }
            if (this.linearInequalityConstraintCVectors != null) {
                newLinearInequalityConstraintSums = new double[this.linearInequalityConstraintCVectors.length];
            }
            this.computeLinearInequalityConstraintSums(newXGuess, this.linearInequalityConstraintCVectors, this.linearInequalityConstraintBs, newLinearInequalityConstraintSums);
            boolean newLinearInequalityConstraintsAreMet = this.areAllLinearInequalityConstraintsMet(newLinearInequalityConstraintSums);
            if (bestLinearInequalityConstraintsAreMet && !newLinearInequalityConstraintsAreMet) {
                delta = this.decreaseDelta(delta, deltaReductionFactor, minimumDelta);
                continue;
            }
            if (newLinearInequalityConstraintsAreMet && !bestLinearInequalityConstraintsAreMet) {
                this.printIfDebug("Found a linear inequality constraint satisfaction!");
                bestXGuess = newXGuess;
                bestCost = newCost;
                bestLinearInequalityConstraintSums = newLinearInequalityConstraintSums;
                bestLinearInequalityConstraintsAreMet = newLinearInequalityConstraintsAreMet;
                this.printOutBestGuess(bestXGuess);
                delta = this.increaseDelta(delta, deltaIncreaseFactor, maximumDelta);
                continue;
            }
            if (!newLinearInequalityConstraintsAreMet) {
                if (this.areAllInequalityConstraintsSameOrImproved(bestLinearInequalityConstraintSums, newLinearInequalityConstraintSums)) {
                    this.printIfDebug("Found reduced linear inequality constraint violations!");
                    bestXGuess = newXGuess;
                    bestCost = newCost;
                    bestLinearInequalityConstraintSums = newLinearInequalityConstraintSums;
                    bestLinearInequalityConstraintsAreMet = newLinearInequalityConstraintsAreMet;
                    this.printOutBestGuess(bestXGuess);
                    delta = this.increaseDelta(delta, deltaIncreaseFactor, maximumDelta);
                    continue;
                }
                delta = this.decreaseDelta(delta, deltaReductionFactor, minimumDelta);
                continue;
            }
            if (newCost < bestCost) {
                this.printIfDebug("Found better cost! bestCost = " + bestCost);
                bestXGuess = newXGuess;
                bestCost = newCost;
                bestLinearInequalityConstraintSums = newLinearInequalityConstraintSums;
                bestLinearInequalityConstraintsAreMet = newLinearInequalityConstraintsAreMet;
                this.printOutBestGuess(bestXGuess);
                delta = this.increaseDelta(delta, deltaIncreaseFactor, maximumDelta);
                continue;
            }
            delta = this.decreaseDelta(delta, deltaReductionFactor, minimumDelta);
        }
        if (bestLinearEqualityConstraintsAreMet && bestLinearInequalityConstraintsAreMet) {
            return bestXGuess;
        }
        return null;
    }

    private double decreaseDelta(double delta, double deltaReductionFactor, double minimumDelta) {
        double newDelta = delta * deltaReductionFactor;
        if (newDelta > minimumDelta) {
            return newDelta;
        }
        return delta;
    }

    private double increaseDelta(double delta, double deltaIncreaseFactor, double maximumDelta) {
        double newDelta = delta * deltaIncreaseFactor;
        if (newDelta < maximumDelta) {
            return newDelta;
        }
        return delta;
    }

    private void printOutBestGuess(double[] bestXGuess) {
    }

    private double computeCost(double[] linearCostFunctionFVector, double[] xGuess) {
        double cost = 0.0;
        for (int i = 0; i < linearCostFunctionFVector.length; ++i) {
            cost += linearCostFunctionFVector[i] * xGuess[i];
        }
        return cost;
    }

    private boolean areAllEqualityConstraintsSameOrImproved(double[] previousLinearEqualityConstraintErrors, double[] newLinearEqualityConstraintErrors, double epsilonForLinearEqualityConstraints) {
        for (int i = 0; i < previousLinearEqualityConstraintErrors.length; ++i) {
            boolean errorIsWorse;
            boolean constraintNotSatisfied = Math.abs(newLinearEqualityConstraintErrors[i]) > epsilonForLinearEqualityConstraints;
            boolean bl = errorIsWorse = Math.abs(newLinearEqualityConstraintErrors[i]) > Math.abs(previousLinearEqualityConstraintErrors[i]);
            if (!constraintNotSatisfied || !errorIsWorse) continue;
            return false;
        }
        return true;
    }

    private boolean areAllInequalityConstraintsSameOrImproved(double[] previousInequalityConstraintSums, double[] newInequalityConstraintSums) {
        for (int i = 0; i < previousInequalityConstraintSums.length; ++i) {
            if (!(newInequalityConstraintSums[i] > previousInequalityConstraintSums[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areAllLinearInequalityConstraintsMet(double[] linearInequalityConstraintSums) {
        if (linearInequalityConstraintSums == null) {
            return true;
        }
        for (double sum : linearInequalityConstraintSums) {
            if (!(sum > 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean areAllLinearEqualityConstraintsMet(double[] linearEqualityConstraintErrors, double epsilon) {
        if (linearEqualityConstraintErrors == null) {
            return true;
        }
        for (double error : linearEqualityConstraintErrors) {
            if (!(Math.abs(error) > epsilon)) continue;
            return false;
        }
        return true;
    }

    private double[] generateRandomGuess(Random random, double[] bestXGuess, double delta) {
        double[] ret = new double[bestXGuess.length];
        for (int i = 0; i < bestXGuess.length; ++i) {
            ret[i] = bestXGuess[i] + delta * (1.0 - 2.0 * random.nextDouble());
        }
        return ret;
    }

    private void computeLinearEqualityConstraintErrors(double[] xVector, double[][] linearEqualityConstraintsAMatrix, double[] linearEqualityConstraintsBVector, double[] linearEqualityConstraintErrorsToPack) {
        if (linearEqualityConstraintsAMatrix == null) {
            return;
        }
        for (int i = 0; i < linearEqualityConstraintsAMatrix.length; ++i) {
            double linearEqualityConstraintSum = 0.0;
            for (int xIndex = 0; xIndex < linearEqualityConstraintsAMatrix[i].length; ++xIndex) {
                linearEqualityConstraintSum += linearEqualityConstraintsAMatrix[i][xIndex] * xVector[xIndex];
            }
            linearEqualityConstraintErrorsToPack[i] = linearEqualityConstraintSum -= linearEqualityConstraintsBVector[i];
        }
    }

    private void computeLinearInequalityConstraintSums(double[] xVector, double[][] linearInequalityConstraintCVectors, double[] linearInequalityConstraintBs, double[] linearInequalityConstraintSumsToPack) {
        if (linearInequalityConstraintCVectors == null) {
            return;
        }
        for (int i = 0; i < linearInequalityConstraintCVectors.length; ++i) {
            double linearInequalityConstraintSum = 0.0;
            for (int xIndex = 0; xIndex < linearInequalityConstraintCVectors[i].length; ++xIndex) {
                linearInequalityConstraintSum += linearInequalityConstraintCVectors[i][xIndex] * xVector[xIndex];
            }
            linearInequalityConstraintSumsToPack[i] = linearInequalityConstraintSum -= linearInequalityConstraintBs[i];
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addQuadraticInequalities(double[][] pMatrix, double[] qVector, double r) {
        throw new RuntimeException("Not yet implemented!");
    }

    public void addSecondOrderConeConstraints(double[][] secondOrderConeAMatrix, double secondOrderConeBScalar, double[] secondOrderConeCVector, double secondOrderConeDScalar) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addSecondOrderConeConstraints(double[][] secondOrderConeAMatrix, double[] secondOrderConeBVector, double[] secondOrderConeCVector, double secondOrderConeDScalar) {
        throw new RuntimeException("Not yet implemented");
    }

    private void printIfDebug(String string) {
    }
}

