/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.convexOptimization.linearProgram.DictionaryFormLinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.matrixlib.MatrixTools;

public class LinearProgramSolver {
    private final DMatrixRMaj startingDictionary = new DMatrixRMaj(200, 200);
    private final DictionaryFormLinearProgramSolver dictionaryFormSolver = new DictionaryFormLinearProgramSolver();

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj constraintMatrixA, DMatrixRMaj constraintVectorB, DMatrixRMaj solutionToPack) {
        return this.solve(costVectorC, constraintMatrixA, constraintVectorB, solutionToPack, SolverMethod.SIMPLEX);
    }

    public boolean solve(DMatrixRMaj costVectorC, DMatrixRMaj constraintMatrixA, DMatrixRMaj constraintVectorB, DMatrixRMaj solutionToPack, SolverMethod solverMethod) {
        if (costVectorC.getNumCols() != 1 || constraintVectorB.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (constraintMatrixA.getNumCols() != costVectorC.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        if (constraintMatrixA.getNumRows() != constraintVectorB.getNumRows()) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        this.startingDictionary.reshape(1 + constraintMatrixA.getNumRows(), 1 + constraintMatrixA.getNumCols());
        Arrays.fill(this.startingDictionary.getData(), 0.0);
        MatrixTools.setMatrixBlock((DMatrix)this.startingDictionary, (int)1, (int)0, (DMatrix)constraintVectorB, (int)0, (int)0, (int)constraintVectorB.getNumRows(), (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.startingDictionary, (int)1, (int)1, (DMatrix)constraintMatrixA, (int)0, (int)0, (int)constraintMatrixA.getNumRows(), (int)constraintMatrixA.getNumCols(), (double)-1.0);
        for (int i = 0; i < costVectorC.getNumRows(); ++i) {
            this.startingDictionary.set(0, 1 + i, costVectorC.get(i));
        }
        if (solverMethod == SolverMethod.CRISS_CROSS) {
            this.dictionaryFormSolver.solveCrissCross(this.startingDictionary);
            if (!this.dictionaryFormSolver.getCrissCrossStatistics().foundSolution()) {
                return false;
            }
        } else {
            this.dictionaryFormSolver.solveSimplex(this.startingDictionary);
            if (!this.dictionaryFormSolver.getPhase2Statistics().foundSolution()) {
                return false;
            }
        }
        solutionToPack.set((DMatrixD1)this.dictionaryFormSolver.getSolution());
        return true;
    }
}

