/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.convexOptimization.quadraticProgram.SimpleInefficientEqualityConstrainedQPSolver;

public class SimpleInefficientEqualityConstrainedQPSolverTest {
    private static final boolean VERBOSE = false;

    @Test
    public void testSimpleCases() {
        SimpleInefficientEqualityConstrainedQPSolver solver = new SimpleInefficientEqualityConstrainedQPSolver();
        double[][] costQuadraticMatrix = new double[][]{{2.0}};
        double[] costLinearVector = new double[]{0.0};
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((double[][])costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        double[] solution = new double[1];
        double[] lagrangeMultipliers = new double[]{};
        solver.solve(solution, lagrangeMultipliers);
        Assertions.assertEquals((int)1, (int)solution.length);
        Assertions.assertEquals((double)0.0, (double)solution[0], (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new double[][]{{2.0}};
        costLinearVector = new double[]{-10.0};
        quadraticCostScalar = 25.0;
        solver.setQuadraticCostFunction((double[][])costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        solution = new double[1];
        lagrangeMultipliers = new double[]{};
        solver.solve(solution, lagrangeMultipliers);
        Assertions.assertEquals((int)1, (int)solution.length);
        Assertions.assertEquals((double)5.0, (double)solution[0], (double)1.0E-7);
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.length, 1);
        solutionMatrix.setData(solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new double[][]{{2.0, 0.0}, {0.0, 2.0}};
        costLinearVector = new double[]{-10.0, -6.0};
        quadraticCostScalar = 34.0;
        solver.setQuadraticCostFunction((double[][])costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        solution = new double[2];
        lagrangeMultipliers = new double[]{};
        solver.solve(solution, lagrangeMultipliers);
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)5.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)3.0, (double)solution[1], (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.length, 1);
        solutionMatrix.setData(solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new double[][]{{2.0, 0.0}, {0.0, 2.0}};
        costLinearVector = new double[]{0.0, 0.0};
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((double[][])costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        double[][] linearEqualityConstraintsAMatrix = new double[][]{{1.0, 1.0}};
        double[] linearEqualityConstraintsBVector = new double[]{1.0};
        solver.setLinearEqualityConstraints((double[][])linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
        solution = new double[2];
        lagrangeMultipliers = new double[1];
        solver.solve(solution, lagrangeMultipliers);
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)0.5, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)0.5, (double)solution[1], (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)lagrangeMultipliers[0], (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.length, 1);
        solutionMatrix.setData(solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.5, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new double[][]{{2.0, 0.0}, {0.0, 2.0}};
        costLinearVector = new double[]{0.0, 0.0};
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((double[][])costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new double[][]{{1.0, 1.0}, {3.0, -3.0}};
        linearEqualityConstraintsBVector = new double[]{2.0, 0.0};
        solver.setLinearEqualityConstraints((double[][])linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
        solution = new double[2];
        lagrangeMultipliers = new double[2];
        solver.solve(solution, lagrangeMultipliers);
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)1.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution[1], (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)lagrangeMultipliers[0], (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeMultipliers[1], (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.length, 1);
        solutionMatrix.setData(solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)2.0, (double)objectiveCost, (double)1.0E-7);
    }

    @Test
    public void testLargeRandomProblemWithNoEqualityConstraints() {
        Random random = new Random(1776L);
        SimpleInefficientEqualityConstrainedQPSolver solver = new SimpleInefficientEqualityConstrainedQPSolver();
        int numberOfTests = 100;
        for (int testNumber = 0; testNumber < numberOfTests; ++testNumber) {
            solver.clear();
            int numberOfVariables = 100;
            DMatrixRMaj costQuadraticMatrix = SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, numberOfVariables);
            DMatrixRMaj identity = CommonOps_DDRM.identity((int)numberOfVariables, (int)numberOfVariables);
            CommonOps_DDRM.scale((double)numberOfVariables, (DMatrixD1)identity);
            CommonOps_DDRM.addEquals((DMatrixD1)costQuadraticMatrix, (DMatrixD1)identity);
            DMatrixRMaj costLinearVector = SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, 1);
            double quadraticCostScalar = RandomNumbers.nextDouble((Random)random, (double)30.0);
            solver.setQuadraticCostFunction(costQuadraticMatrix, costLinearVector, quadraticCostScalar);
            double[] solution = new double[numberOfVariables];
            double[] lagrangeMultipliers = new double[]{};
            solver.solve(solution, lagrangeMultipliers);
            Assertions.assertEquals((int)numberOfVariables, (int)solution.length);
            DMatrixRMaj solutionMatrix = new DMatrixRMaj(numberOfVariables, 1);
            solutionMatrix.setData(solution);
            double objectiveCost = solver.getObjectiveCost(solutionMatrix);
            double[] solutionWithSmallPerturbation = new double[numberOfVariables];
            for (int i = 0; i < numberOfVariables; ++i) {
                solutionWithSmallPerturbation[i] = solution[i] + RandomNumbers.nextDouble((Random)random, (double)1.0E-7);
            }
            solutionMatrix = new DMatrixRMaj(numberOfVariables, 1);
            solutionMatrix.setData(solutionWithSmallPerturbation);
            double objectiveCostWithSmallPerturbation = solver.getObjectiveCost(solutionMatrix);
            Assertions.assertTrue((objectiveCostWithSmallPerturbation > objectiveCost ? 1 : 0) != 0, (String)("objectiveCostWithSmallPerturbation = " + objectiveCostWithSmallPerturbation + ", objectiveCost = " + objectiveCost));
        }
    }

    @Test
    public void testLargeRandomProblemWithEqualityConstraints() {
        Random random = new Random(1776L);
        SimpleInefficientEqualityConstrainedQPSolver solver = new SimpleInefficientEqualityConstrainedQPSolver();
        int numberOfTests = 100;
        long startTimeMillis = System.currentTimeMillis();
        for (int testNumber = 0; testNumber < numberOfTests; ++testNumber) {
            solver.clear();
            int numberOfVariables = 80;
            int numberOfEqualityConstraints = 16;
            DMatrixRMaj costQuadraticMatrix = SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, numberOfVariables);
            DMatrixRMaj identity = CommonOps_DDRM.identity((int)numberOfVariables, (int)numberOfVariables);
            CommonOps_DDRM.scale((double)numberOfVariables, (DMatrixD1)identity);
            CommonOps_DDRM.addEquals((DMatrixD1)costQuadraticMatrix, (DMatrixD1)identity);
            DMatrixRMaj costLinearVector = SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, 1);
            double quadraticCostScalar = RandomNumbers.nextDouble((Random)random, (double)30.0);
            solver.setQuadraticCostFunction(costQuadraticMatrix, costLinearVector, quadraticCostScalar);
            DMatrixRMaj linearEqualityConstraintsAMatrix = SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfEqualityConstraints, numberOfVariables);
            DMatrixRMaj linearEqualityConstraintsBVector = SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfEqualityConstraints, 1);
            solver.setLinearEqualityConstraints(linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
            double[] solution = new double[numberOfVariables];
            double[] lagrangeMultipliers = new double[numberOfEqualityConstraints];
            solver.solve(solution, lagrangeMultipliers);
            Assertions.assertEquals((int)numberOfVariables, (int)solution.length);
            Assertions.assertEquals((int)numberOfEqualityConstraints, (int)lagrangeMultipliers.length);
            DMatrixRMaj solutionMatrix = new DMatrixRMaj(numberOfVariables, 1);
            solutionMatrix.setData(solution);
            double objectiveCost = solver.getObjectiveCost(solutionMatrix);
            this.verifyEqualityConstraintsHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
            double[] solutionWithSmallPerturbation = new double[numberOfVariables];
            for (int i = 0; i < numberOfVariables; ++i) {
                solutionWithSmallPerturbation[i] = solution[i] + RandomNumbers.nextDouble((Random)random, (double)1.0E-4);
            }
            solutionMatrix = new DMatrixRMaj(numberOfVariables, 1);
            solutionMatrix.setData(solutionWithSmallPerturbation);
            this.verifyEqualityConstraintsDoNotHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
            DMatrixRMaj solutionMatrixProjectedOntoEqualityConstraints = this.projectOntoEqualityConstraints(solutionMatrix, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
            this.verifyEqualityConstraintsHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrixProjectedOntoEqualityConstraints);
            double objectiveCostWithSmallPerturbation = solver.getObjectiveCost(solutionMatrixProjectedOntoEqualityConstraints);
            Assertions.assertTrue((objectiveCostWithSmallPerturbation > objectiveCost ? 1 : 0) != 0, (String)("objectiveCostWithSmallPerturbation = " + objectiveCostWithSmallPerturbation + ", objectiveCost = " + objectiveCost));
        }
        long endTimeMillis = System.currentTimeMillis();
        double timePerTest = (double)(endTimeMillis - startTimeMillis) * 0.001 / (double)numberOfTests;
    }

    private void verifyEqualityConstraintsHold(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        double maxAbsoluteError = this.getMaxEqualityConstraintError(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)maxAbsoluteError, (double)1.0E-5);
    }

    private void verifyEqualityConstraintsDoNotHold(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        double maxAbsoluteError = this.getMaxEqualityConstraintError(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
        Assertions.assertTrue((maxAbsoluteError > 1.0E-5 ? 1 : 0) != 0);
    }

    private double getMaxEqualityConstraintError(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        DMatrixRMaj checkMatrix = new DMatrixRMaj(numberOfEqualityConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)checkMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)checkMatrix, (DMatrixD1)linearEqualityConstraintsBVector);
        return this.getMaxAbsoluteDataEntry(checkMatrix);
    }

    private DMatrixRMaj projectOntoEqualityConstraints(DMatrixRMaj solutionMatrix, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector) {
        int numberOfVariables = solutionMatrix.getNumRows();
        if (linearEqualityConstraintsAMatrix.getNumCols() != numberOfVariables) {
            throw new RuntimeException();
        }
        int numberOfConstraints = linearEqualityConstraintsAMatrix.getNumRows();
        if (linearEqualityConstraintsBVector.getNumRows() != numberOfConstraints) {
            throw new RuntimeException();
        }
        DMatrixRMaj AZMinusB = new DMatrixRMaj(numberOfConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)AZMinusB);
        CommonOps_DDRM.subtractEquals((DMatrixD1)AZMinusB, (DMatrixD1)linearEqualityConstraintsBVector);
        DMatrixRMaj AATransposeInverse = new DMatrixRMaj(numberOfConstraints, numberOfConstraints);
        DMatrixRMaj linearEqualityConstraintsAMatrixTranspose = new DMatrixRMaj(linearEqualityConstraintsAMatrix);
        CommonOps_DDRM.transpose((DMatrixRMaj)linearEqualityConstraintsAMatrixTranspose);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)linearEqualityConstraintsAMatrixTranspose, (DMatrix1Row)AATransposeInverse);
        CommonOps_DDRM.invert((DMatrixRMaj)AATransposeInverse);
        DMatrixRMaj ATransposeAATransposeInverse = new DMatrixRMaj(numberOfVariables, numberOfConstraints);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrixTranspose, (DMatrix1Row)AATransposeInverse, (DMatrix1Row)ATransposeAATransposeInverse);
        DMatrixRMaj vectorToSubtract = new DMatrixRMaj(numberOfVariables, 1);
        CommonOps_DDRM.mult((DMatrix1Row)ATransposeAATransposeInverse, (DMatrix1Row)AZMinusB, (DMatrix1Row)vectorToSubtract);
        DMatrixRMaj projectedSolutionMatrix = new DMatrixRMaj(solutionMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)projectedSolutionMatrix, (DMatrixD1)vectorToSubtract);
        return projectedSolutionMatrix;
    }

    private double getMaxAbsoluteDataEntry(DMatrixRMaj matrix) {
        int numberOfRows = matrix.getNumRows();
        int numberOfColumns = matrix.getNumCols();
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                double absoluteValue = Math.abs(matrix.get(i, j));
                if (!(absoluteValue > max)) continue;
                max = absoluteValue;
            }
        }
        return max;
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns) {
        return SimpleInefficientEqualityConstrainedQPSolverTest.nextDMatrixRMaj(random, numberOfRows, numberOfColumns, 1.0);
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns, double maxAbsoluteValue) {
        return RandomMatrices_DDRM.rectangle((int)numberOfRows, (int)numberOfColumns, (double)(-maxAbsoluteValue), (double)maxAbsoluteValue, (Random)random);
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns, double boundaryOne, double boundaryTwo) {
        return RandomMatrices_DDRM.rectangle((int)numberOfRows, (int)numberOfColumns, (double)boundaryOne, (double)boundaryTwo, (Random)random);
    }
}

