/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ConstrainedQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.JavaQuadProgSolver;
import us.ihmc.convexOptimization.quadraticProgram.OASESConstrainedQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.QuadProgSolver;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.MatrixTestTools;

public class ConstrainedQPSolverTest {
    @Test
    public void testSolveContrainedQP() throws NoConvergenceException {
        DMatrixRMaj x;
        int repeat;
        int numberOfInequalityConstraints = 1;
        int numberOfEqualityConstraints = 1;
        int numberOfVariables = 2;
        DMatrixRMaj Q = new DMatrixRMaj(numberOfVariables, numberOfVariables, true, new double[]{1.0, 0.0, 0.0, 1.0});
        DMatrixRMaj f = new DMatrixRMaj(numberOfVariables, 1, true, new double[]{1.0, 0.0});
        DMatrixRMaj Aeq = new DMatrixRMaj(numberOfEqualityConstraints, numberOfVariables, true, new double[]{1.0, 1.0});
        DMatrixRMaj beq = new DMatrixRMaj(numberOfEqualityConstraints, 1, true, new double[]{0.0});
        DMatrixRMaj Ain = new DMatrixRMaj(numberOfInequalityConstraints, numberOfVariables, true, new double[]{2.0, 1.0});
        DMatrixRMaj bin = new DMatrixRMaj(numberOfInequalityConstraints, 1, true, new double[]{0.0});
        ConstrainedQPSolver[] optimizers = this.createSolvers();
        JavaQuadProgSolver solver = new JavaQuadProgSolver();
        for (repeat = 0; repeat < 10000; ++repeat) {
            for (int i = 0; i < optimizers.length; ++i) {
                x = new DMatrixRMaj(numberOfVariables, 1, true, new double[]{-1.0, 1.0});
                optimizers[i].solve(Q, f, Aeq, beq, Ain, bin, x, false);
                Assertions.assertArrayEquals((double[])x.getData(), (double[])new double[]{-0.5, 0.5}, (double)1.0E-10);
            }
            DMatrixRMaj x2 = new DMatrixRMaj(numberOfVariables, 1, true, new double[]{-1.0, 1.0});
            solver.clear();
            solver.setQuadraticCostFunction(Q, f, 0.0);
            solver.setLinearInequalityConstraints(Ain, bin);
            solver.setLinearEqualityConstraints(Aeq, beq);
            solver.solve(x2);
            Assertions.assertArrayEquals((double[])x2.getData(), (double[])new double[]{-0.5, 0.5}, (double)1.0E-10);
        }
        optimizers = new ConstrainedQPSolver[]{};
        numberOfInequalityConstraints = 1;
        numberOfEqualityConstraints = 2;
        numberOfVariables = 3;
        Q = new DMatrixRMaj(numberOfVariables, numberOfVariables, true, new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 2.0, 1.0, 3.0, 7.0});
        f = new DMatrixRMaj(numberOfVariables, 1, true, new double[]{1.0, 0.0, 9.0});
        Aeq = new DMatrixRMaj(numberOfEqualityConstraints, numberOfVariables, true, new double[]{1.0, 1.0, 1.0, 2.0, 3.0, 4.0});
        beq = new DMatrixRMaj(numberOfEqualityConstraints, 1, true, new double[]{0.0, 7.0});
        Ain = new DMatrixRMaj(numberOfInequalityConstraints, numberOfVariables, true, new double[]{2.0, 1.0, 3.0});
        bin = new DMatrixRMaj(numberOfInequalityConstraints, 1, true, new double[]{0.0});
        for (repeat = 0; repeat < 10000; ++repeat) {
            for (int i = 0; i < optimizers.length; ++i) {
                x = new DMatrixRMaj(numberOfVariables, 1, true, new double[]{-1.0, 1.0, 3.0});
                optimizers[i].solve(Q, f, Aeq, beq, Ain, bin, x, false);
                Assertions.assertArrayEquals((double[])x.getData(), (double[])new double[]{-7.75, 8.5, -0.75}, (double)1.0E-10, (String)("repeat = " + repeat + ", optimizer = " + i));
                DMatrixRMaj bEqualityVerify = new DMatrixRMaj(numberOfEqualityConstraints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)Aeq, (DMatrix1Row)x, (DMatrix1Row)bEqualityVerify);
                MatrixTestTools.assertMatrixEquals((DMatrix)bEqualityVerify, (DMatrix)beq, (double)1.0E-7);
                DMatrixRMaj bInequalityVerify = new DMatrixRMaj(numberOfInequalityConstraints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)Ain, (DMatrix1Row)x, (DMatrix1Row)bInequalityVerify);
                for (int j = 0; j < bInequalityVerify.getNumRows(); ++j) {
                    Assertions.assertTrue((bInequalityVerify.get(j, 0) < beq.get(j, 0) ? 1 : 0) != 0);
                }
            }
            if (optimizers.length <= 0) continue;
            DMatrixRMaj x3 = new DMatrixRMaj(numberOfVariables, 1, true, new double[]{-1.0, 1.0, 3.0});
            solver.clear();
            solver.setQuadraticCostFunction(Q, f, 0.0);
            solver.setLinearInequalityConstraints(Ain, bin);
            solver.setLinearEqualityConstraints(Aeq, beq);
            solver.solve(x3);
            Assertions.assertArrayEquals((double[])x3.getData(), (double[])new double[]{-7.75, 8.5, -0.75}, (double)1.0E-10, (String)("repeat = " + repeat + ", Java solver"));
            DMatrixRMaj bEqualityVerify = new DMatrixRMaj(numberOfEqualityConstraints, 1);
            CommonOps_DDRM.mult((DMatrix1Row)Aeq, (DMatrix1Row)x3, (DMatrix1Row)bEqualityVerify);
            MatrixTestTools.assertMatrixEquals((DMatrix)bEqualityVerify, (DMatrix)beq, (double)1.0E-7);
            DMatrixRMaj bInequalityVerify = new DMatrixRMaj(numberOfInequalityConstraints, 1);
            CommonOps_DDRM.mult((DMatrix1Row)Ain, (DMatrix1Row)x3, (DMatrix1Row)bInequalityVerify);
            for (int j = 0; j < bInequalityVerify.getNumRows(); ++j) {
                Assertions.assertTrue((bInequalityVerify.get(j, 0) < beq.get(j, 0) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testSolveProblemWithParallelConstraints() throws NoConvergenceException {
        ConstrainedQPSolver[] solvers;
        DMatrixRMaj Q = new DMatrixRMaj(1, 1);
        DMatrixRMaj Ain = new DMatrixRMaj(2, 1);
        DMatrixRMaj bin = new DMatrixRMaj(2, 1);
        DMatrixRMaj x = new DMatrixRMaj(1, 1);
        Q.set(0, 0, 1.0);
        Ain.set(0, 0, 1.0);
        Ain.set(1, 0, 1.0);
        bin.set(0, -1.0);
        bin.set(0, -2.0);
        DMatrixRMaj f = new DMatrixRMaj(1, 1);
        DMatrixRMaj Aeq = new DMatrixRMaj(0, 1);
        DMatrixRMaj beq = new DMatrixRMaj(0, 1);
        for (ConstrainedQPSolver solver : solvers = this.createSolvers()) {
            LogTools.info((String)("Attempting to solve problem with: " + solver.getClass().getSimpleName()));
            solver.solve(Q, f, Aeq, beq, Ain, bin, x, true);
            boolean correct = MathTools.epsilonEquals((double)-2.0, (double)x.get(0), (double)1.0E-9);
            if (!correct) {
                LogTools.info((String)("Failed. Result was " + x.get(0) + ", expected -2.0"));
            }
            Assertions.assertTrue((boolean)correct);
        }
        JavaQuadProgSolver solver = new JavaQuadProgSolver();
        LogTools.info((String)("Attempting to solve problem with: " + solver.getClass().getSimpleName()));
        solver.clear();
        solver.setQuadraticCostFunction(Q, f, 0.0);
        solver.setLinearInequalityConstraints(Ain, bin);
        solver.setLinearEqualityConstraints(Aeq, beq);
        solver.solve(x);
        boolean correct = MathTools.epsilonEquals((double)-2.0, (double)x.get(0), (double)1.0E-9);
        if (!correct) {
            LogTools.info((String)("Failed. Result was " + x.get(0) + ", expected -2.0"));
        }
        Assertions.assertTrue((boolean)correct);
    }

    private ConstrainedQPSolver[] createSolvers() {
        ConstrainedQPSolver[] optimizers = new ConstrainedQPSolver[]{new OASESConstrainedQPSolver(), new QuadProgSolver()};
        return optimizers;
    }
}

