/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.linearProgram.LinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.matrixlib.MatrixTools;

public class LinearProgramSolverTest {
    private static final Random random = new Random(349034L);
    private static final double epsilon = 1.0E-5;

    @Test
    public void testSolutionDictionaryIndices() {
        LinearProgramSolver solver = new LinearProgramSolver();
        for (SolverMethod solverMethod : SolverMethod.values()) {
            TIntArrayList nonBasisIndices = solver.getNonBasisIndices();
            TIntArrayList basisIndices = solver.getBasisIndices();
            DMatrixRMaj cost = new DMatrixRMaj(2, 1);
            DMatrixRMaj A = new DMatrixRMaj(3, 2);
            DMatrixRMaj b = new DMatrixRMaj(3, 1);
            A.set(0, 0, 1.0);
            A.set(1, 1, 1.0);
            A.set(2, 0, 1.0);
            A.set(2, 1, 1.0);
            b.set(0, 0, 2.0);
            b.set(1, 0, 2.0);
            b.set(2, 0, 3.0);
            int nonNegConstraint1 = 1;
            int nonNegConstraint2 = 2;
            int AConstraint1 = 3;
            int AConstraint2 = 4;
            int AConstraint3 = 5;
            DMatrixRMaj solution = new DMatrixRMaj(2, 1);
            cost.set(0, 0, -1.0);
            cost.set(1, 0, -1.0);
            solver.solve(cost, A, b, solution, solverMethod);
            Assertions.assertEquals((int)basisIndices.size(), (int)(1 + A.getNumRows()));
            Assertions.assertEquals((int)nonBasisIndices.size(), (int)(1 + A.getNumCols()));
            Assertions.assertTrue((boolean)nonBasisIndices.contains(nonNegConstraint1));
            Assertions.assertTrue((boolean)nonBasisIndices.contains(nonNegConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint1));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint3));
            cost.set(0, 0, 1.0);
            cost.set(1, 0, -1.0);
            solver.solve(cost, A, b, solution, solverMethod);
            Assertions.assertTrue((boolean)nonBasisIndices.contains(nonNegConstraint2));
            Assertions.assertTrue((boolean)nonBasisIndices.contains(AConstraint1));
            Assertions.assertTrue((boolean)basisIndices.contains(nonNegConstraint1));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint3));
            cost.set(0, 0, 1.0);
            cost.set(1, 0, 0.01);
            solver.solve(cost, A, b, solution, solverMethod);
            Assertions.assertTrue((boolean)nonBasisIndices.contains(AConstraint1));
            Assertions.assertTrue((boolean)nonBasisIndices.contains(AConstraint3));
            Assertions.assertTrue((boolean)basisIndices.contains(nonNegConstraint1));
            Assertions.assertTrue((boolean)basisIndices.contains(nonNegConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint2));
            cost.set(0, 0, 0.01);
            cost.set(1, 0, 1.0);
            solver.solve(cost, A, b, solution, solverMethod);
            Assertions.assertTrue((boolean)nonBasisIndices.contains(AConstraint2));
            Assertions.assertTrue((boolean)nonBasisIndices.contains(AConstraint3));
            Assertions.assertTrue((boolean)basisIndices.contains(nonNegConstraint1));
            Assertions.assertTrue((boolean)basisIndices.contains(nonNegConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint1));
            cost.set(0, 0, -1.0);
            cost.set(1, 0, 1.0);
            solver.solve(cost, A, b, solution, solverMethod);
            Assertions.assertTrue((boolean)nonBasisIndices.contains(nonNegConstraint1));
            Assertions.assertTrue((boolean)nonBasisIndices.contains(AConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(nonNegConstraint2));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint1));
            Assertions.assertTrue((boolean)basisIndices.contains(AConstraint3));
        }
    }

    @Test
    public void testNonBasisIndicesSaturateConstraints() {
        int numTests = 100;
        LinearProgramSolver lpSolver = new LinearProgramSolver();
        for (int i = 0; i < numTests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(false, false);
            DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(constraintSet.inequalityMatrix.getNumCols());
            DMatrixRMaj solution = new DMatrixRMaj(0);
            boolean foundSolution = lpSolver.solve(costVector, constraintSet.inequalityMatrix, constraintSet.inequalityVector, solution, SolverMethod.SIMPLEX);
            TIntArrayList nonBasisIndices = lpSolver.getNonBasisIndices();
            if (!foundSolution) continue;
            TIntArrayList saturatedConstraintIndices = new TIntArrayList();
            for (int j = 1; j < nonBasisIndices.size(); ++j) {
                int nonBasisIndex = nonBasisIndices.get(j);
                if (lpSolver.isNonNegativeConstraint(nonBasisIndex)) {
                    int saturatedVariableIndex = LinearProgramSolver.toVariableIndex((int)nonBasisIndex);
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)solution.get(saturatedVariableIndex), (double)0.0, (double)1.0E-5));
                    continue;
                }
                int saturatedConstraintIndex = lpSolver.toConstraintIndex(nonBasisIndex);
                saturatedConstraintIndices.add(saturatedConstraintIndex);
            }
            int numSaturatedMatrixConstraints = saturatedConstraintIndices.size();
            DMatrixRMaj A_saturated = new DMatrixRMaj(numSaturatedMatrixConstraints, constraintSet.inequalityMatrix.getNumCols());
            DMatrixRMaj b_saturated = new DMatrixRMaj(numSaturatedMatrixConstraints, 1);
            for (int j = 0; j < numSaturatedMatrixConstraints; ++j) {
                int saturatedConstraintIndex = saturatedConstraintIndices.get(j);
                MatrixTools.setMatrixBlock((DMatrix)A_saturated, (int)j, (int)0, (DMatrix)constraintSet.inequalityMatrix, (int)saturatedConstraintIndex, (int)0, (int)1, (int)constraintSet.inequalityMatrix.getNumCols(), (double)1.0);
                b_saturated.set(j, 0, constraintSet.inequalityVector.get(saturatedConstraintIndex, 0));
            }
            DMatrixRMaj b_solution = new DMatrixRMaj(constraintSet.inequalityMatrix.getNumCols(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)A_saturated, (DMatrix1Row)solution, (DMatrix1Row)b_solution);
            for (int j = 0; j < numSaturatedMatrixConstraints; ++j) {
                Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)b_saturated.get(j, 0), (double)b_solution.get(j, 0), (double)1.0E-5));
            }
        }
    }

    @Test
    public void testOnlyInequalityConstraints_MaxBounded() {
        int tests = 400;
        int costVectorsPerProblem = 10;
        for (int i = 0; i < tests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(false, false);
            LinearProgramSolverTest.runTest(constraintSet, costVectorsPerProblem);
        }
    }

    @Test
    public void testOnlyInequalityConstraints_MinBounded() {
        int tests = 400;
        int costVectorsPerProblem = 10;
        for (int i = 0; i < tests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(false, false);
            DMatrixRMaj A = constraintSet.inequalityMatrix;
            DMatrixRMaj b = constraintSet.inequalityVector;
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)A);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)b);
            LinearProgramSolverTest.runTest(constraintSet, costVectorsPerProblem);
        }
    }

    @Test
    public void testWithEqualityConstraintsInInequalityMatrix() {
        int tests = 100;
        int costVectorsPerProblem = 10;
        for (int i = 0; i < tests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(true, true);
            LinearProgramSolverTest.runTest(constraintSet, costVectorsPerProblem);
        }
    }

    @Test
    public void testWithEqualityConstraintsGivenExplicitly() {
        int tests = 100;
        int costVectorsPerProblem = 10;
        for (int i = 0; i < tests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(true, false);
            LinearProgramSolverTest.runTest(constraintSet, costVectorsPerProblem);
        }
    }

    @Test
    public void testRandomLPs() {
        int tests = 200;
        int costVectorsPerProblem = 10;
        for (int i = 0; i < tests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomConstraints();
            LinearProgramSolverTest.runTest(constraintSet, costVectorsPerProblem);
        }
    }

    @Test
    public void testSensitivity() {
        int tests = 200;
        for (int i = 0; i < tests; ++i) {
            ConstraintSet constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(false, false);
            DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(constraintSet.inequalityMatrix.getNumCols());
            DMatrixRMaj expectedSolution = new DMatrixRMaj(0);
            LinearProgramSolver solver = new LinearProgramSolver();
            solver.solve(costVector, constraintSet.inequalityMatrix, constraintSet.inequalityVector, expectedSolution);
            TIntArrayList originalBasisIndices = new TIntArrayList((TIntCollection)solver.getBasisIndices());
            DMatrixRMaj mutatedInequalityMatrix = new DMatrixRMaj(constraintSet.inequalityMatrix);
            LinearProgramSolverTest.mutateInequalityMatrix(constraintSet.inequalityMatrix, mutatedInequalityMatrix);
            solver.solve(costVector, mutatedInequalityMatrix, constraintSet.inequalityVector, expectedSolution);
            TIntArrayList mutatedBasisIndices = new TIntArrayList((TIntCollection)solver.getBasisIndices());
            if (!LinearProgramSolverTest.containsSameElements(originalBasisIndices, mutatedBasisIndices)) continue;
            DMatrixRMaj calculatedSolution = new DMatrixRMaj(0);
            solver.solveForFixedBasis(mutatedInequalityMatrix, constraintSet.inequalityVector, originalBasisIndices, calculatedSolution);
            for (int j = 0; j < expectedSolution.getNumRows(); ++j) {
                double epsilon = 1.0E-12;
                Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)calculatedSolution.get(j), (double)expectedSolution.get(j), (double)epsilon));
            }
        }
    }

    private static void mutateInequalityMatrix(DMatrixRMaj inequalityMatrix, DMatrixRMaj mutatedInequalityMatrix) {
        for (int i = 0; i < inequalityMatrix.getNumRows(); ++i) {
            for (int j = 0; j < inequalityMatrix.getNumCols(); ++j) {
                boolean mutate;
                boolean bl = mutate = random.nextInt(2) == 0;
                if (!mutate) continue;
                double val = inequalityMatrix.get(i, j);
                double mutationMultiplier = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.05);
                mutatedInequalityMatrix.set(i, j, val * mutationMultiplier);
            }
        }
    }

    private static boolean containsSameElements(TIntArrayList listA, TIntArrayList listB) {
        for (int i = 0; i < listA.size(); ++i) {
            if (listB.contains(listA.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void runTest(ConstraintSet constraintSet, int numberOfTests) {
        LinearProgramSolver customSolver = new LinearProgramSolver();
        for (int i = 0; i < numberOfTests; ++i) {
            boolean foundCrissCrossSolution;
            boolean foundSimplexSolution;
            DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(constraintSet.inequalityMatrix.getNumCols());
            double[] apacheCommonsSolution = LinearProgramSolverTest.solveWithApacheCommons(constraintSet, costVector, Relationship.LEQ);
            DMatrixRMaj simplexSolution = new DMatrixRMaj(0);
            DMatrixRMaj crissCrossSolution = new DMatrixRMaj(0);
            if (constraintSet.equalityMatrix.getNumRows() > 0) {
                foundSimplexSolution = customSolver.solve(costVector, constraintSet.inequalityMatrix, constraintSet.inequalityVector, constraintSet.equalityMatrix, constraintSet.equalityVector, simplexSolution, SolverMethod.SIMPLEX);
                foundCrissCrossSolution = customSolver.solve(costVector, constraintSet.inequalityMatrix, constraintSet.inequalityVector, constraintSet.equalityMatrix, constraintSet.equalityVector, crissCrossSolution, SolverMethod.CRISS_CROSS);
            } else {
                foundSimplexSolution = customSolver.solve(costVector, constraintSet.inequalityMatrix, constraintSet.inequalityVector, simplexSolution, SolverMethod.SIMPLEX);
                foundCrissCrossSolution = customSolver.solve(costVector, constraintSet.inequalityMatrix, constraintSet.inequalityVector, crissCrossSolution, SolverMethod.CRISS_CROSS);
            }
            if (apacheCommonsSolution == null) {
                Assertions.assertFalse((boolean)foundSimplexSolution);
                Assertions.assertFalse((boolean)foundCrissCrossSolution);
                continue;
            }
            Assertions.assertTrue((boolean)foundSimplexSolution);
            Assertions.assertTrue((boolean)foundCrissCrossSolution);
            for (int k = 0; k < apacheCommonsSolution.length; ++k) {
                Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)simplexSolution.get(k), (double)1.0E-5));
                Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)crissCrossSolution.get(k), (double)1.0E-5));
            }
        }
    }

    private static ConstraintSet generateRandomEllipsoidBasedConstraintSet(boolean includeEqualityConstraints, boolean useEqualityConstraintsAsInequalityConstraints) {
        int dimensionality = 2 + random.nextInt(30);
        int inequalityConstraints = 1 + random.nextInt(30);
        int equalityConstraints = includeEqualityConstraints ? 1 + random.nextInt(dimensionality - 1) : 0;
        double radiusSquared = 1.0 + 100.0 * random.nextDouble();
        double[] alphas = new double[dimensionality];
        for (int j = 0; j < alphas.length; ++j) {
            alphas[j] = 1.0 + 30.0 * random.nextDouble();
        }
        ConstraintSet constraintSet = new ConstraintSet();
        LinearProgramSolverTest.addInequalityConstraints(radiusSquared, alphas, constraintSet, inequalityConstraints, dimensionality);
        if (includeEqualityConstraints) {
            if (useEqualityConstraintsAsInequalityConstraints) {
                DMatrixRMaj Aeq = new DMatrixRMaj(0);
                DMatrixRMaj beq = new DMatrixRMaj(0);
                LinearProgramSolverTest.addEqualityConstraints(radiusSquared, alphas, Aeq, beq, equalityConstraints, dimensionality);
                int constraints = inequalityConstraints + 2 * equalityConstraints;
                DMatrixRMaj A = constraintSet.inequalityMatrix;
                DMatrixRMaj b = constraintSet.inequalityVector;
                A.reshape(constraints, dimensionality, true);
                b.reshape(constraints, 1, true);
                MatrixTools.setMatrixBlock((DMatrix)A, (int)inequalityConstraints, (int)0, (DMatrix)Aeq, (int)0, (int)0, (int)Aeq.getNumRows(), (int)Aeq.getNumCols(), (double)1.0);
                MatrixTools.setMatrixBlock((DMatrix)A, (int)(inequalityConstraints + Aeq.getNumRows()), (int)0, (DMatrix)Aeq, (int)0, (int)0, (int)Aeq.getNumRows(), (int)Aeq.getNumCols(), (double)-1.0);
                MatrixTools.setMatrixBlock((DMatrix)b, (int)inequalityConstraints, (int)0, (DMatrix)beq, (int)0, (int)0, (int)beq.getNumRows(), (int)beq.getNumCols(), (double)1.0);
                MatrixTools.setMatrixBlock((DMatrix)b, (int)(inequalityConstraints + beq.getNumRows()), (int)0, (DMatrix)beq, (int)0, (int)0, (int)beq.getNumRows(), (int)beq.getNumCols(), (double)-1.0);
            } else {
                LinearProgramSolverTest.addEqualityConstraints(radiusSquared, alphas, constraintSet.equalityMatrix, constraintSet.equalityVector, equalityConstraints, dimensionality);
            }
        }
        return constraintSet;
    }

    private static void addInequalityConstraints(double radiusSquared, double[] alphas, ConstraintSet constraintSet, int numberOfInequalityConstraints, int dimensionality) {
        constraintSet.inequalityMatrix.reshape(numberOfInequalityConstraints, dimensionality);
        constraintSet.inequalityVector.reshape(numberOfInequalityConstraints, 1);
        for (int i = 0; i < numberOfInequalityConstraints; ++i) {
            double[] initialPoint = LinearProgramSolverTest.generatePointOnEllipsoid(dimensionality, radiusSquared, alphas);
            double[] gradient = new double[dimensionality];
            for (int j = 0; j < dimensionality; ++j) {
                gradient[j] = alphas[j] * initialPoint[j];
            }
            double bValue = 0.0;
            for (int k = 0; k < dimensionality; ++k) {
                bValue += gradient[k] * initialPoint[k];
            }
            for (int j = 0; j < dimensionality; ++j) {
                constraintSet.inequalityMatrix.set(i, j, gradient[j]);
            }
            constraintSet.inequalityVector.set(i, 0, bValue);
        }
    }

    private static void addEqualityConstraints(double radiusSquared, double[] alphas, DMatrixRMaj Aeq, DMatrixRMaj beq, int numberOfEqualityConstraints, int dimensionality) {
        int i;
        Aeq.reshape(numberOfEqualityConstraints, dimensionality);
        beq.reshape(numberOfEqualityConstraints, 1);
        double[] interiorPoint = LinearProgramSolverTest.generatePointOnEllipsoid(dimensionality, radiusSquared, alphas);
        double scale = 0.9 * random.nextDouble();
        for (i = 0; i < interiorPoint.length; ++i) {
            interiorPoint[i] = scale * interiorPoint[i];
        }
        for (i = 0; i < numberOfEqualityConstraints; ++i) {
            int j;
            double normDotPoint = 0.0;
            double[] normal = LinearProgramSolverTest.generateRandomVectorForPlaneNormal(dimensionality);
            for (j = 0; j < dimensionality; ++j) {
                normDotPoint += normal[j] * interiorPoint[j];
            }
            beq.set(i, 0, normDotPoint);
            for (j = 0; j < dimensionality; ++j) {
                Aeq.set(i, j, normal[j]);
            }
        }
    }

    private static double[] generatePointOnEllipsoid(int dimensionality, double radiusSquared, double[] alphas) {
        double[] initialPoint = new double[dimensionality];
        double remainingPosValue = radiusSquared;
        for (int k = 0; k < dimensionality - 1; ++k) {
            double alphaXSq = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(remainingPosValue * 0.99 / alphas[k]));
            remainingPosValue -= alphaXSq;
            initialPoint[k] = Math.sqrt(alphaXSq / alphas[k]);
        }
        initialPoint[dimensionality - 1] = Math.sqrt(remainingPosValue / alphas[dimensionality - 1]);
        return initialPoint;
    }

    private static double[] generateRandomVectorForPlaneNormal(int dimensionality) {
        double[] v = new double[dimensionality];
        double sumSq = 0.0;
        for (int i = 0; i < dimensionality; ++i) {
            v[i] = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            sumSq += MathTools.square((double)v[i]);
        }
        double norm = Math.sqrt(sumSq);
        if (norm < 0.001) {
            v[0] = 1.0;
        } else {
            int i = 0;
            while (i < dimensionality) {
                int n = i++;
                v[n] = v[n] / Math.sqrt(1.0 / norm);
            }
        }
        return v;
    }

    private static ConstraintSet generateRandomConstraints() {
        int dimensionality = 2 + random.nextInt(40);
        int constraints = 1 + random.nextInt(40);
        double minMaxConstraint = 10.0;
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.inequalityMatrix.reshape(constraints, dimensionality);
        constraintSet.inequalityVector.reshape(constraints, 1);
        for (int i = 0; i < constraints; ++i) {
            constraintSet.inequalityVector.set(i, EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxConstraint));
            for (int j = 0; j < dimensionality; ++j) {
                constraintSet.inequalityMatrix.set(i, j, EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxConstraint));
            }
        }
        return constraintSet;
    }

    private static DMatrixRMaj generateRandomCostVector(int dimensionality) {
        DMatrixRMaj c = new DMatrixRMaj(dimensionality, 1);
        double minMaxEntry = 10.0;
        double l1Norm = 0.0;
        for (int i = 0; i < dimensionality; ++i) {
            double entry = EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxEntry);
            l1Norm += Math.abs(entry);
            c.set(i, 0, entry);
        }
        double minNorm = 0.001;
        if (l1Norm < minNorm) {
            c.set(0, 0, 1.0);
        }
        return c;
    }

    private static double[] solveWithApacheCommons(ConstraintSet constraintSet, DMatrixRMaj c, Relationship constraintRelationship) {
        int j;
        double[] constraint;
        int i;
        SimplexSolver apacheSolver = new SimplexSolver();
        double[] directionToMaximize = Arrays.copyOf(c.getData(), c.getNumRows());
        LinearObjectiveFunction objectiveFunction = new LinearObjectiveFunction(directionToMaximize, 0.0);
        DMatrixRMaj inequalityMatrix = constraintSet.inequalityMatrix;
        DMatrixRMaj inequalityVector = constraintSet.inequalityVector;
        DMatrixRMaj equalityMatrix = constraintSet.equalityMatrix;
        DMatrixRMaj equalityVector = constraintSet.equalityVector;
        ArrayList<LinearConstraint> constraintList = new ArrayList<LinearConstraint>();
        for (i = 0; i < inequalityMatrix.getNumRows(); ++i) {
            constraint = new double[inequalityMatrix.getNumCols()];
            for (j = 0; j < inequalityMatrix.getNumCols(); ++j) {
                constraint[j] = inequalityMatrix.get(i, j);
            }
            constraintList.add(new LinearConstraint(constraint, constraintRelationship, inequalityVector.get(i)));
        }
        for (i = 0; i < inequalityMatrix.getNumCols(); ++i) {
            double[] nonNegativeConstraint = new double[inequalityMatrix.getNumCols()];
            nonNegativeConstraint[i] = 1.0;
            constraintList.add(new LinearConstraint(nonNegativeConstraint, Relationship.GEQ, 0.0));
        }
        for (i = 0; i < equalityMatrix.getNumRows(); ++i) {
            constraint = new double[equalityMatrix.getNumCols()];
            for (j = 0; j < equalityMatrix.getNumCols(); ++j) {
                constraint[j] = equalityMatrix.get(i, j);
            }
            constraintList.add(new LinearConstraint(constraint, Relationship.EQ, equalityVector.get(i)));
        }
        try {
            return apacheSolver.optimize(new OptimizationData[]{new MaxIter(1000), objectiveFunction, new LinearConstraintSet(constraintList), GoalType.MAXIMIZE}).getPoint();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class ConstraintSet {
        private final DMatrixRMaj inequalityMatrix = new DMatrixRMaj(0);
        private final DMatrixRMaj inequalityVector = new DMatrixRMaj(0);
        private final DMatrixRMaj equalityMatrix = new DMatrixRMaj(0);
        private final DMatrixRMaj equalityVector = new DMatrixRMaj(0);

        private ConstraintSet() {
        }
    }
}

