/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.linearProgram.LinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.matrixlib.MatrixTools;

public class LinearProgramSolverTest {
    private static final Random random = new Random(349034L);
    private static final double epsilon = 1.0E-5;

    @Test
    public void testEllipsoidBasedMaxConstraint() {
        int tests = 400;
        int costVectorsPerProblem = 10;
        LinearProgramSolver customSolver = new LinearProgramSolver();
        for (int i = 0; i < tests; ++i) {
            Pair<DMatrixRMaj, DMatrixRMaj> constraintSet = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(false);
            DMatrixRMaj A = (DMatrixRMaj)constraintSet.getLeft();
            DMatrixRMaj b = (DMatrixRMaj)constraintSet.getRight();
            for (int j = 0; j < costVectorsPerProblem; ++j) {
                DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(A.getNumCols());
                double[] apacheCommonsSolution = LinearProgramSolverTest.solveWithApacheCommons(A, b, costVector, Relationship.LEQ);
                DMatrixRMaj simplexSolution = new DMatrixRMaj(0);
                boolean foundSimplexSolution = customSolver.solve(costVector, A, b, simplexSolution, SolverMethod.SIMPLEX);
                DMatrixRMaj crissCrossSolution = new DMatrixRMaj(0);
                boolean foundCrissCrossSolution = customSolver.solve(costVector, A, b, crissCrossSolution, SolverMethod.CRISS_CROSS);
                if (apacheCommonsSolution == null) {
                    Assertions.assertFalse((boolean)foundSimplexSolution);
                    Assertions.assertFalse((boolean)foundCrissCrossSolution);
                    continue;
                }
                Assertions.assertTrue((boolean)foundSimplexSolution);
                Assertions.assertTrue((boolean)foundCrissCrossSolution);
                for (int k = 0; k < apacheCommonsSolution.length; ++k) {
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)simplexSolution.get(k), (double)1.0E-5));
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)crissCrossSolution.get(k), (double)1.0E-5));
                }
            }
        }
    }

    @Test
    public void testEllipsoidBasedMaxAndEqualityConstraints() {
        int tests = 100;
        int costVectorsPerProblem = 10;
        LinearProgramSolver customSolver = new LinearProgramSolver();
        for (int i = 0; i < tests; ++i) {
            Pair<DMatrixRMaj, DMatrixRMaj> constraintPlanes = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(true);
            DMatrixRMaj A = (DMatrixRMaj)constraintPlanes.getLeft();
            DMatrixRMaj b = (DMatrixRMaj)constraintPlanes.getRight();
            for (int j = 0; j < costVectorsPerProblem; ++j) {
                DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(A.getNumCols());
                double[] apacheCommonsSolution = LinearProgramSolverTest.solveWithApacheCommons(A, b, costVector, Relationship.LEQ);
                DMatrixRMaj simplexSolution = new DMatrixRMaj(0);
                boolean foundSimplexSolution = customSolver.solve(costVector, A, b, simplexSolution, SolverMethod.SIMPLEX);
                DMatrixRMaj crissCrossSolution = new DMatrixRMaj(0);
                boolean foundCrissCrossSolution = customSolver.solve(costVector, A, b, crissCrossSolution, SolverMethod.CRISS_CROSS);
                if (apacheCommonsSolution == null) {
                    Assertions.assertFalse((boolean)foundSimplexSolution);
                    Assertions.assertFalse((boolean)foundCrissCrossSolution);
                    continue;
                }
                Assertions.assertTrue((boolean)foundSimplexSolution);
                Assertions.assertTrue((boolean)foundCrissCrossSolution);
                for (int k = 0; k < apacheCommonsSolution.length; ++k) {
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)simplexSolution.get(k), (double)1.0E-5));
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)crissCrossSolution.get(k), (double)1.0E-5));
                }
            }
        }
    }

    @Test
    public void testEllipsoidBasedMinConstraint() {
        int tests = 400;
        int costVectorsPerProblem = 10;
        LinearProgramSolver customSolver = new LinearProgramSolver();
        for (int i = 0; i < tests; ++i) {
            Pair<DMatrixRMaj, DMatrixRMaj> constraintPlanes = LinearProgramSolverTest.generateRandomEllipsoidBasedConstraintSet(false);
            DMatrixRMaj A = (DMatrixRMaj)constraintPlanes.getLeft();
            DMatrixRMaj b = (DMatrixRMaj)constraintPlanes.getRight();
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)A);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)b);
            for (int j = 0; j < costVectorsPerProblem; ++j) {
                DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(A.getNumCols());
                double[] apacheCommonsSolution = LinearProgramSolverTest.solveWithApacheCommons(A, b, costVector, Relationship.LEQ);
                DMatrixRMaj simplexSolution = new DMatrixRMaj(0);
                boolean foundSimplexSolution = customSolver.solve(costVector, A, b, simplexSolution, SolverMethod.SIMPLEX);
                DMatrixRMaj crissCrossSolution = new DMatrixRMaj(0);
                boolean foundCrissCrossSolution = customSolver.solve(costVector, A, b, crissCrossSolution, SolverMethod.CRISS_CROSS);
                if (apacheCommonsSolution == null) {
                    Assertions.assertFalse((boolean)foundSimplexSolution);
                    Assertions.assertFalse((boolean)foundCrissCrossSolution);
                    continue;
                }
                Assertions.assertTrue((boolean)foundSimplexSolution);
                Assertions.assertTrue((boolean)foundCrissCrossSolution);
                for (int k = 0; k < apacheCommonsSolution.length; ++k) {
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)simplexSolution.get(k), (double)1.0E-5));
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)crissCrossSolution.get(k), (double)1.0E-5));
                }
            }
        }
    }

    @Test
    public void testRandomLPs() {
        int tests = 200;
        int costVectorsPerProblem = 10;
        LinearProgramSolver customSolver = new LinearProgramSolver();
        for (int i = 0; i < tests; ++i) {
            Pair<DMatrixRMaj, DMatrixRMaj> constraintPlanes = LinearProgramSolverTest.generateRandomConstraints();
            for (int j = 0; j < costVectorsPerProblem; ++j) {
                DMatrixRMaj costVector = LinearProgramSolverTest.generateRandomCostVector(((DMatrixRMaj)constraintPlanes.getLeft()).getNumCols());
                double[] apacheCommonsSolution = LinearProgramSolverTest.solveWithApacheCommons((DMatrixRMaj)constraintPlanes.getLeft(), (DMatrixRMaj)constraintPlanes.getRight(), costVector, Relationship.LEQ);
                DMatrixRMaj simplexSolution = new DMatrixRMaj(0);
                boolean foundSimplexSolution = customSolver.solve(costVector, (DMatrixRMaj)constraintPlanes.getLeft(), (DMatrixRMaj)constraintPlanes.getRight(), simplexSolution, SolverMethod.SIMPLEX);
                DMatrixRMaj crissCrossSolution = new DMatrixRMaj(0);
                boolean foundCrissCrossSolution = customSolver.solve(costVector, (DMatrixRMaj)constraintPlanes.getLeft(), (DMatrixRMaj)constraintPlanes.getRight(), crissCrossSolution, SolverMethod.CRISS_CROSS);
                if (apacheCommonsSolution == null) {
                    Assertions.assertFalse((boolean)foundSimplexSolution);
                    Assertions.assertFalse((boolean)foundCrissCrossSolution);
                    continue;
                }
                Assertions.assertTrue((boolean)foundSimplexSolution);
                Assertions.assertTrue((boolean)foundCrissCrossSolution);
                for (int k = 0; k < apacheCommonsSolution.length; ++k) {
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)simplexSolution.get(k), (double)1.0E-5));
                    Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)apacheCommonsSolution[k], (double)crissCrossSolution.get(k), (double)1.0E-5));
                }
            }
        }
    }

    private static Pair<DMatrixRMaj, DMatrixRMaj> generateRandomEllipsoidBasedConstraintSet(boolean includeEqualityConstraints) {
        int i;
        int dimensionality = 2 + random.nextInt(30);
        int inequalityConstraints = 1 + random.nextInt(30);
        double radiusSquared = 1.0 + 100.0 * random.nextDouble();
        double[] alphas = new double[dimensionality];
        for (int j = 0; j < alphas.length; ++j) {
            alphas[j] = 1.0 + 30.0 * random.nextDouble();
        }
        DMatrixRMaj Ain = new DMatrixRMaj(inequalityConstraints, dimensionality);
        DMatrixRMaj bin = new DMatrixRMaj(inequalityConstraints, 1);
        for (int i2 = 0; i2 < inequalityConstraints; ++i2) {
            double[] initialPoint = LinearProgramSolverTest.generatePointOnEllipsoid(dimensionality, radiusSquared, alphas);
            double[] gradient = new double[dimensionality];
            for (int j = 0; j < dimensionality; ++j) {
                gradient[j] = alphas[j] * initialPoint[j];
            }
            double bValue = 0.0;
            for (int k = 0; k < dimensionality; ++k) {
                bValue += gradient[k] * initialPoint[k];
            }
            for (int j = 0; j < dimensionality; ++j) {
                Ain.set(i2, j, gradient[j]);
            }
            bin.set(i2, 0, bValue);
        }
        if (!includeEqualityConstraints) {
            return Pair.of((Object)Ain, (Object)bin);
        }
        int equalityConstraints = 1 + random.nextInt(dimensionality - 1);
        DMatrixRMaj Aeq = new DMatrixRMaj(equalityConstraints, dimensionality);
        DMatrixRMaj beq = new DMatrixRMaj(equalityConstraints, 1);
        double[] interiorPoint = LinearProgramSolverTest.generatePointOnEllipsoid(dimensionality, radiusSquared, alphas);
        double scale = 0.9 * random.nextDouble();
        for (i = 0; i < interiorPoint.length; ++i) {
            interiorPoint[i] = scale * interiorPoint[i];
        }
        for (i = 0; i < equalityConstraints; ++i) {
            int j;
            double normDotPoint = 0.0;
            double[] normal = LinearProgramSolverTest.generateRandomVectorForPlaneNormal(dimensionality);
            for (j = 0; j < dimensionality; ++j) {
                normDotPoint += normal[j] * interiorPoint[j];
            }
            beq.set(i, 0, normDotPoint);
            for (j = 0; j < dimensionality; ++j) {
                Aeq.set(i, j, normal[j]);
            }
        }
        int constraints = inequalityConstraints + 2 * equalityConstraints;
        DMatrixRMaj A = new DMatrixRMaj(constraints, dimensionality);
        DMatrixRMaj b = new DMatrixRMaj(constraints, 1);
        MatrixTools.setMatrixBlock((DMatrix)A, (int)0, (int)0, (DMatrix)Ain, (int)0, (int)0, (int)Ain.getNumRows(), (int)Ain.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)A, (int)Ain.getNumRows(), (int)0, (DMatrix)Aeq, (int)0, (int)0, (int)Aeq.getNumRows(), (int)Aeq.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)A, (int)(Ain.getNumRows() + Aeq.getNumRows()), (int)0, (DMatrix)Aeq, (int)0, (int)0, (int)Aeq.getNumRows(), (int)Aeq.getNumCols(), (double)-1.0);
        MatrixTools.setMatrixBlock((DMatrix)b, (int)0, (int)0, (DMatrix)bin, (int)0, (int)0, (int)bin.getNumRows(), (int)bin.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)b, (int)bin.getNumRows(), (int)0, (DMatrix)beq, (int)0, (int)0, (int)beq.getNumRows(), (int)beq.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)b, (int)(bin.getNumRows() + beq.getNumRows()), (int)0, (DMatrix)beq, (int)0, (int)0, (int)beq.getNumRows(), (int)beq.getNumCols(), (double)-1.0);
        return Pair.of((Object)A, (Object)b);
    }

    private static double[] generatePointOnEllipsoid(int dimensionality, double radiusSquared, double[] alphas) {
        double[] initialPoint = new double[dimensionality];
        double remainingPosValue = radiusSquared;
        for (int k = 0; k < dimensionality - 1; ++k) {
            double alphaXSq = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(remainingPosValue * 0.99 / alphas[k]));
            remainingPosValue -= alphaXSq;
            initialPoint[k] = Math.sqrt(alphaXSq / alphas[k]);
        }
        initialPoint[dimensionality - 1] = Math.sqrt(remainingPosValue / alphas[dimensionality - 1]);
        return initialPoint;
    }

    private static double[] generateRandomVectorForPlaneNormal(int dimensionality) {
        double[] v = new double[dimensionality];
        double sumSq = 0.0;
        for (int i = 0; i < dimensionality; ++i) {
            v[i] = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            sumSq += MathTools.square((double)v[i]);
        }
        double norm = Math.sqrt(sumSq);
        if (norm < 0.001) {
            v[0] = 1.0;
        } else {
            int i = 0;
            while (i < dimensionality) {
                int n = i++;
                v[n] = v[n] / Math.sqrt(1.0 / norm);
            }
        }
        return v;
    }

    private static Pair<DMatrixRMaj, DMatrixRMaj> generateRandomConstraints() {
        int dimensionality = 2 + random.nextInt(40);
        int constraints = 1 + random.nextInt(40);
        double minMaxConstraint = 10.0;
        DMatrixRMaj A = new DMatrixRMaj(constraints, dimensionality);
        DMatrixRMaj b = new DMatrixRMaj(constraints, 1);
        for (int i = 0; i < constraints; ++i) {
            b.set(i, EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxConstraint));
            for (int j = 0; j < dimensionality; ++j) {
                A.set(i, j, EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxConstraint));
            }
        }
        return Pair.of((Object)A, (Object)b);
    }

    private static DMatrixRMaj generateRandomCostVector(int dimensionality) {
        DMatrixRMaj c = new DMatrixRMaj(dimensionality, 1);
        double minMaxEntry = 10.0;
        double l1Norm = 0.0;
        for (int i = 0; i < dimensionality; ++i) {
            double entry = EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxEntry);
            l1Norm += Math.abs(entry);
            c.set(i, 0, entry);
        }
        double minNorm = 0.001;
        if (l1Norm < minNorm) {
            c.set(0, 0, 1.0);
        }
        return c;
    }

    private static double[] solveWithApacheCommons(DMatrixRMaj A, DMatrixRMaj b, DMatrixRMaj c, Relationship constraintRelationship) {
        int i;
        SimplexSolver apacheSolver = new SimplexSolver();
        double[] directionToMaximize = Arrays.copyOf(c.getData(), c.getNumRows());
        LinearObjectiveFunction objectiveFunction = new LinearObjectiveFunction(directionToMaximize, 0.0);
        ArrayList<LinearConstraint> constraintList = new ArrayList<LinearConstraint>();
        for (i = 0; i < A.getNumRows(); ++i) {
            double[] constraint = new double[A.getNumCols()];
            for (int j = 0; j < A.getNumCols(); ++j) {
                constraint[j] = A.get(i, j);
            }
            constraintList.add(new LinearConstraint(constraint, constraintRelationship, b.get(i)));
        }
        for (i = 0; i < A.getNumCols(); ++i) {
            double[] nonNegativeConstraint = new double[A.getNumCols()];
            nonNegativeConstraint[i] = 1.0;
            constraintList.add(new LinearConstraint(nonNegativeConstraint, Relationship.GEQ, 0.0));
        }
        try {
            return apacheSolver.optimize(new OptimizationData[]{new MaxIter(1000), objectiveFunction, new LinearConstraintSet(constraintList), GoalType.MAXIMIZE}).getPoint();
        }
        catch (Exception e) {
            return null;
        }
    }
}

