/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;

public class Throttler {
    private double resetTime = Double.NaN;
    private double optionallySetPeriod = Double.NaN;
    private transient double currentTime;
    private transient double overtime;

    public Throttler setPeriod(double period) {
        this.optionallySetPeriod = period;
        return this;
    }

    public Throttler setFrequency(double frequency) {
        this.optionallySetPeriod = Conversions.hertzToSeconds(frequency);
        return this;
    }

    public boolean run() {
        return this.run(this.optionallySetPeriod);
    }

    public boolean run(double period) {
        boolean periodHasElapsed;
        this.currentTime = Conversions.nanosecondsToSeconds(System.nanoTime());
        if (Double.isNaN(this.resetTime)) {
            this.resetTime = this.currentTime;
            return true;
        }
        this.calculateOvertime(period);
        boolean bl = periodHasElapsed = this.overtime >= 0.0;
        if (periodHasElapsed) {
            this.resetTime = this.currentTime - this.overtime;
        }
        return periodHasElapsed;
    }

    public void waitAndRun() {
        this.waitAndRun(this.optionallySetPeriod);
    }

    public void waitAndRun(double period) {
        this.currentTime = Conversions.nanosecondsToSeconds(System.nanoTime());
        if (Double.isNaN(this.resetTime)) {
            this.resetTime = this.currentTime;
        } else {
            this.calculateOvertime(period);
            if (this.overtime < 0.0) {
                this.currentTime += ThreadTools.parkAtLeast(-this.overtime);
                this.calculateOvertime(period);
            }
            this.resetTime = this.currentTime - this.overtime;
        }
    }

    private void calculateOvertime(double period) {
        double elapsedTime = this.currentTime - this.resetTime;
        this.overtime = Math.min(elapsedTime - period, 0.5 * period);
    }
}

