/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commons.MathTools;

public class FormattingTools {
    private static final DecimalFormat decimal3DPrintFormatter = new DecimalFormat("0.000");
    private static final DecimalFormat decimal2DPrintFormatter = new DecimalFormat("0.00");
    private static final DecimalFormat decimal1DPrintFormatter = new DecimalFormat("0.0");
    private static final DateTimeFormatter timeHHMMFormatter;
    private static final DateTimeFormatter timeHHMMSSFormatter;

    public static String getFormattedDecimal3D(double value) {
        return decimal3DPrintFormatter.format(value);
    }

    public static String getFormattedDecimal2D(double value) {
        return decimal2DPrintFormatter.format(value);
    }

    public static String getFormattedDecimal1D(double value) {
        return decimal1DPrintFormatter.format(value);
    }

    public static String getFormattedToSignificantFigures(double number, int significantFigures) {
        double roundToSignificantFigures = MathTools.roundToSignificantFigures(number, significantFigures);
        if (Math.abs(roundToSignificantFigures) >= Math.pow(10.0, significantFigures - 1)) {
            return String.valueOf((int)roundToSignificantFigures);
        }
        return String.valueOf(roundToSignificantFigures);
    }

    public static String getFormattedToPrecision(double value, double precision, int significantFigures) {
        double rounded = MathTools.roundToPrecision(value, precision);
        double significant = MathTools.roundToSignificantFigures(rounded, significantFigures);
        if (significant % 1.0 == 0.0) {
            return String.valueOf((int)significant);
        }
        return String.valueOf(significant);
    }

    public static String underscoredToCamelCase(String underscoredString, boolean capitalizeFirstLetter) {
        char[] charArray = underscoredString.toCharArray();
        boolean capitalizeCurrentLetter = capitalizeFirstLetter;
        int outIndex = 0;
        for (int inIndex = 0; inIndex < charArray.length; ++inIndex) {
            if (charArray[inIndex] == '_') {
                capitalizeCurrentLetter = true;
                continue;
            }
            char characterIn = charArray[inIndex];
            if (capitalizeCurrentLetter) {
                charArray[outIndex++] = Character.toUpperCase(characterIn);
                capitalizeCurrentLetter = false;
                continue;
            }
            charArray[outIndex++] = Character.toLowerCase(characterIn);
        }
        return new String(charArray, 0, outIndex);
    }

    public static String titleToKebabCase(String titleCased) {
        String kebabCased = titleCased.trim().toLowerCase().replaceAll("\\W+", "-");
        if (kebabCased.startsWith("-")) {
            kebabCased = kebabCased.substring(1);
        }
        if (kebabCased.endsWith("-")) {
            kebabCased = kebabCased.substring(0, kebabCased.lastIndexOf("-"));
        }
        return kebabCased;
    }

    public static String titleToPascalCase(String titleCased) {
        String[] split = titleCased.trim().split("\\W+");
        StringBuilder pascalCased = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.capitalize((String)split[i]);
            if (split[i].equals("-")) continue;
            pascalCased.append(split[i]);
        }
        return pascalCased.toString();
    }

    public static String kebabToPascalCase(String kebabCased) {
        String[] split = kebabCased.trim().split("-");
        StringBuilder pascalCased = new StringBuilder();
        for (String section : split) {
            pascalCased.append(StringUtils.capitalize((String)section));
        }
        return pascalCased.toString();
    }

    public static String kebabToCamelCase(String kebabCased) {
        int j;
        String[] split = kebabCased.trim().split("-");
        StringBuilder camelCased = new StringBuilder();
        for (j = 0; j < split.length && split[j].isEmpty(); ++j) {
        }
        if (split.length > 0) {
            camelCased.append(StringUtils.uncapitalize((String)split[j]));
        }
        for (int i = j + 1; i < split.length; ++i) {
            camelCased.append(StringUtils.capitalize((String)split[i]));
        }
        return camelCased.toString();
    }

    public static String toKebabCased(String anyCased) {
        String kebabCased = FormattingTools.toPreKababWithBookendHandles(anyCased.trim());
        if ((kebabCased = kebabCased.substring(1, kebabCased.length() - 1)).startsWith("-")) {
            kebabCased = kebabCased.substring(1);
        }
        if (kebabCased.endsWith("-")) {
            kebabCased = kebabCased.substring(0, kebabCased.lastIndexOf("-"));
        }
        return kebabCased;
    }

    public static String toPreKababWithBookendHandles(String anyCased) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        for (int i = 0; i < anyCased.length(); ++i) {
            String character = String.valueOf(anyCased.charAt(i));
            if (StringUtils.isAllUpperCase((CharSequence)character) || StringUtils.isNumeric((CharSequence)character)) {
                if (part.length() > 0) {
                    parts.add(part.toString().toLowerCase());
                }
                part = new StringBuilder(character);
                continue;
            }
            part.append(character);
        }
        if (part.length() > 0) {
            parts.add(part.toString().toLowerCase());
        }
        StringBuilder kebab = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            String s = (String)parts.get(i);
            if (i == 0 || !((String)parts.get(i - 1)).endsWith("-")) {
                kebab.append('-');
            }
            kebab.append(s);
        }
        kebab.append('-');
        return kebab.toString();
    }

    public static String toHumanReadable(double bits) {
        String siPrefix = "";
        if (bits > 1.073741824E9) {
            siPrefix = "G";
            bits /= 1.073741824E9;
        } else if (bits > 1048576.0) {
            siPrefix = "M";
            bits /= 1048576.0;
        } else if (bits > 1024.0) {
            siPrefix = "k";
            bits /= 1024.0;
        }
        return String.format("%.2f", bits) + siPrefix;
    }

    public static String addPrefixAndKeepCamelCaseForMiddleOfExpression(String namePrefix, String originalName) {
        return StringUtils.capitalize((String)FormattingTools.addPrefixAndKeepCamelCase(namePrefix, originalName));
    }

    public static String addPrefixAndKeepCamelCase(String namePrefix, String originalName) {
        if (namePrefix == null || namePrefix.isEmpty()) {
            return originalName;
        }
        if (namePrefix.endsWith("_")) {
            return namePrefix + originalName;
        }
        return namePrefix + StringUtils.capitalize((String)originalName);
    }

    public static String getCommonSuffix(String ... strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        String[] reversedStrs = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            reversedStrs[i] = StringUtils.reverse((String)strs[i]);
        }
        return StringUtils.reverse((String)StringUtils.getCommonPrefix((String[])reversedStrs));
    }

    public static String getDateString() {
        return LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
    }

    public static String getTimeString() {
        return LocalTime.now().format(timeHHMMFormatter);
    }

    public static String getTimeStringWithSeconds() {
        return LocalTime.now().format(timeHHMMSSFormatter);
    }

    static {
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        dateTimeFormatterBuilder.appendValue(ChronoField.HOUR_OF_DAY, 2);
        dateTimeFormatterBuilder.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
        timeHHMMFormatter = dateTimeFormatterBuilder.toFormatter();
        dateTimeFormatterBuilder.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
        timeHHMMSSFormatter = dateTimeFormatterBuilder.toFormatter();
    }
}

