/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

public class PrintTools {
    public static final String DEBUG = "[DEBUG] ";
    public static final String INFO = "[INFO] ";
    public static final String WARN = "[WARN] ";
    public static final String ERROR = "[ERROR] ";
    private static final int STACK_TRACE_INDEX = 2;

    public static void debug(boolean debug, String message) {
        if (debug) {
            PrintTools.print(DEBUG, null, message, false);
        }
    }

    public static void debug(boolean debug, String message, boolean useSystemError) {
        if (debug) {
            PrintTools.print(DEBUG, null, message, useSystemError);
        }
    }

    public static void debug(String message) {
        PrintTools.print(DEBUG, null, message, false);
    }

    public static void debug(String message, boolean useSystemError) {
        PrintTools.print(DEBUG, null, message, useSystemError);
    }

    public static void debug(boolean debug, Object containingObjectOrClass, String message) {
        if (debug) {
            PrintTools.print(DEBUG, containingObjectOrClass, message, false);
        }
    }

    public static void debug(boolean debug, Object containingObjectOrClass, String message, boolean useSystemError) {
        if (debug) {
            PrintTools.print(DEBUG, containingObjectOrClass, message, useSystemError);
        }
    }

    public static void debug(Object containingObjectOrClass, String message) {
        PrintTools.print(DEBUG, containingObjectOrClass, message, false);
    }

    public static void debug(Object containingObjectOrClass, String message, boolean useSystemError) {
        PrintTools.print(DEBUG, containingObjectOrClass, message, useSystemError);
    }

    public static void info(Object containingObjectOrClass, String message) {
        PrintTools.print(INFO, containingObjectOrClass, message, false);
    }

    public static void info(String message) {
        PrintTools.print(INFO, null, message, false);
    }

    public static void info(Object containingObjectOrClass, String message, boolean useSystemError) {
        PrintTools.print(INFO, containingObjectOrClass, message, useSystemError);
    }

    public static void info(String message, boolean useSystemError) {
        PrintTools.print(INFO, null, message, useSystemError);
    }

    public static void warn(Object containingObjectOrClass, String message) {
        PrintTools.print(WARN, containingObjectOrClass, message, false);
    }

    public static void warn(String message) {
        PrintTools.print(WARN, null, message, false);
    }

    public static void warn(Object containingObjectOrClass, String message, boolean useSystemError) {
        PrintTools.print(WARN, containingObjectOrClass, message, useSystemError);
    }

    public static void warn(String message, boolean useSystemError) {
        PrintTools.print(WARN, null, message, useSystemError);
    }

    public static void error(Object containingObjectOrClass, String message) {
        PrintTools.print(ERROR, containingObjectOrClass, message, true);
    }

    public static void error(String message) {
        PrintTools.print(ERROR, null, message, true);
    }

    private static void print(String level, Object containingObjectOrClass, String message, boolean useSystemError) {
        String className;
        Throwable throwable = new Throwable();
        int lineNumber = -1;
        if (containingObjectOrClass == null) {
            Object[] classNameSplit = throwable.getStackTrace()[2].getClassName().split("\\.");
            className = ((String)classNameSplit[classNameSplit.length - 1]).split("\\$")[0];
            lineNumber = throwable.getStackTrace()[2].getLineNumber();
        } else {
            className = containingObjectOrClass.getClass().getSimpleName();
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                if (!stackTraceElement.getClassName().endsWith(className)) continue;
                lineNumber = stackTraceElement.getLineNumber();
                break;
            }
            if (lineNumber == -1) {
                lineNumber = throwable.getStackTrace()[2].getLineNumber();
            }
            if (containingObjectOrClass instanceof Class) {
                className = ((Class)containingObjectOrClass).getSimpleName();
            }
        }
        String clickableLocation = "(" + className + ".java:" + lineNumber + ")";
        String finalOutput = level + clickableLocation + ": " + message;
        if (useSystemError) {
            System.err.println(finalOutput);
        } else {
            System.out.println(finalOutput);
        }
    }
}

