/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.nio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.WriteOption;

public class FileTools {
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte NEWLINE = 10;

    public static void deleteQuietly(Path path) {
        FileUtils.deleteQuietly((File)path.toFile());
    }

    public static List<String> readAllLines(Path path, ExceptionHandler exceptionHandler) {
        try {
            return Files.readAllLines(path);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
            return null;
        }
    }

    public static List<String> readAllLines(Path path, Charset charset, ExceptionHandler exceptionHandler) {
        try {
            return Files.readAllLines(path, charset);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
            return null;
        }
    }

    public static byte[] readAllBytes(Path path, ExceptionHandler exceptionHandler) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
            return null;
        }
    }

    public static void write(Path path, byte[] bytes, WriteOption writeOption, ExceptionHandler exceptionHandler) {
        try {
            Files.write(path, bytes, writeOption.getOptions());
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
    }

    public static void write(Path path, Iterable<? extends CharSequence> lines, WriteOption writeOption, ExceptionHandler exceptionHandler) {
        try {
            Files.write(path, lines, writeOption.getOptions());
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
    }

    public static void write(Path path, Iterable<? extends CharSequence> lines, Charset charset, WriteOption writeOption, ExceptionHandler exceptionHandler) {
        try {
            Files.write(path, lines, charset, writeOption.getOptions());
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
    }

    public static void writeAllLines(List<String> lines, Path path, WriteOption writeOption, ExceptionHandler exceptionHandler) {
        PrintWriter printer = FileTools.newPrintWriter(path, writeOption, exceptionHandler);
        lines.forEach(line -> printer.println((String)line));
        printer.close();
    }

    public static PrintWriter newPrintWriter(Path path, WriteOption writeOption, ExceptionHandler exceptionHandler) {
        try {
            return FileTools.newPrintWriter(path, writeOption);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
            return null;
        }
    }

    public static PrintWriter newPrintWriter(Path path, WriteOption writeOption) throws IOException {
        return new PrintWriter(Files.newBufferedWriter(path, writeOption.getOptions()));
    }

    public static List<String> readLinesFromBytes(byte[] bytes, ExceptionHandler exceptionHandler) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8.newDecoder()));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
        return lines;
    }

    public static byte[] replaceLineInFile(int lineIndex, String newLine, byte[] fileBytes, List<String> fileLines) {
        byte[] newBytes = new byte[fileBytes.length - fileLines.get(lineIndex).length() + newLine.length()];
        int newBytesIndex = 0;
        int fileBytesIndex = 0;
        for (int fileLineIndex = 0; fileLineIndex < fileLines.size(); ++fileLineIndex) {
            if (fileLineIndex == lineIndex) {
                for (byte b : newLine.getBytes()) {
                    newBytes[newBytesIndex++] = b;
                }
                fileBytesIndex += fileLines.get(fileLineIndex).length();
                fileLines.set(fileLineIndex, newLine);
            } else {
                for (byte b : fileLines.get(fileLineIndex).getBytes()) {
                    newBytes[newBytesIndex++] = b;
                    ++fileBytesIndex;
                }
            }
            if (fileBytes.length > fileBytesIndex + 1 && fileBytes[fileBytesIndex] == 13 && fileBytes[fileBytesIndex + 1] == 10) {
                newBytes[newBytesIndex++] = fileBytes[fileBytesIndex++];
                newBytes[newBytesIndex++] = fileBytes[fileBytesIndex++];
                continue;
            }
            if (fileBytesIndex >= fileBytes.length || fileBytes[fileBytesIndex] != 13 && fileBytes[fileBytesIndex] != 10) continue;
            newBytes[newBytesIndex++] = fileBytes[fileBytesIndex++];
        }
        return newBytes;
    }

    public static void ensureDirectoryExists(Path path) throws IOException {
        if (path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
            FileTools.ensureDirectoryExists(path.getParent());
        }
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            FileTools.deleteQuietly(path);
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public static void ensureDirectoryExists(Path path, ExceptionHandler exceptionHandler) {
        try {
            FileTools.ensureDirectoryExists(path);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
    }

    public static void ensureFileExists(Path path) throws IOException {
        if (path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
            FileTools.ensureDirectoryExists(path.getParent());
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            Files.delete(path);
            Files.createFile(path, new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    public static void ensureFileExists(Path path, ExceptionHandler exceptionHandler) {
        try {
            FileTools.ensureFileExists(path);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
    }

    public static void concatenateFiles(List<Path> filesToConcatenate, Path concatenatedFile) throws IOException {
        DataOutputStream concatenatedFileOutputStream = FileTools.newFileDataOutputStream(concatenatedFile);
        for (Path fileToConcatenate : filesToConcatenate) {
            DataInputStream fileToConcatenateInputStream = FileTools.newFileDataInputStream(fileToConcatenate);
            while (fileToConcatenateInputStream.available() > 0) {
                concatenatedFileOutputStream.write(fileToConcatenateInputStream.read());
            }
        }
        concatenatedFileOutputStream.flush();
    }

    public static void concatenateFiles(List<Path> filesToConcatenate, Path concatenatedFile, ExceptionHandler exceptionHandler) {
        try {
            FileTools.concatenateFiles(filesToConcatenate, concatenatedFile);
        }
        catch (IOException ioException) {
            exceptionHandler.handleException(ioException);
        }
    }

    public static DataOutputStream newFileDataOutputStream(Path file) throws FileNotFoundException {
        return FileTools.newFileDataOutputStream(file, Conversions.kibibytesToBytes(8));
    }

    public static DataOutputStream newFileDataOutputStream(Path file, int bufferSizeInBytes) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file.toFile()), bufferSizeInBytes));
    }

    public static DataOutputStream newFileDataOutputStream(Path file, ExceptionHandler exceptionHandler) {
        return FileTools.newFileDataOutputStream(file, Conversions.kibibytesToBytes(8), exceptionHandler);
    }

    public static DataOutputStream newFileDataOutputStream(Path file, int bufferSizeInBytes, ExceptionHandler exceptionHandler) {
        try {
            return FileTools.newFileDataOutputStream(file, bufferSizeInBytes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            exceptionHandler.handleException(fileNotFoundException);
            return null;
        }
    }

    public static DataInputStream newFileDataInputStream(Path file) throws FileNotFoundException {
        return FileTools.newFileDataInputStream(file, Conversions.kibibytesToBytes(8));
    }

    public static DataInputStream newFileDataInputStream(Path file, int bufferSizeInBytes) throws FileNotFoundException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(file.toFile()), bufferSizeInBytes));
    }

    public static DataInputStream newFileDataInputStream(Path file, ExceptionHandler exceptionHandler) {
        return FileTools.newFileDataInputStream(file, Conversions.kibibytesToBytes(8), exceptionHandler);
    }

    public static DataInputStream newFileDataInputStream(Path file, int bufferSizeInBytes, ExceptionHandler exceptionHandler) {
        try {
            return FileTools.newFileDataInputStream(file, bufferSizeInBytes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            exceptionHandler.handleException(fileNotFoundException);
            return null;
        }
    }
}

