/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import us.ihmc.commons.lists.SupplierBuilder;

public class RecyclingArrayDeque<T>
extends ArrayDeque<T> {
    private static final long serialVersionUID = 8118722036566615731L;
    private static final int defaultNumberOfElements = 16;
    private final Supplier<T> typeBuilder;
    private final ArrayDeque<T> unusedObjects;
    private final BiConsumer<T, T> copier;

    public RecyclingArrayDeque(Supplier<T> typeBuilder, BiConsumer<T, T> copier) {
        this(16, typeBuilder, copier);
    }

    public RecyclingArrayDeque(Class<T> objectClass, BiConsumer<T, T> copier) {
        this(16, SupplierBuilder.createFromEmptyConstructor(objectClass), copier);
    }

    public RecyclingArrayDeque(int numElements, Class<T> objectClass, BiConsumer<T, T> copier) {
        this(numElements, SupplierBuilder.createFromEmptyConstructor(objectClass), copier);
    }

    public RecyclingArrayDeque(int numElements, Supplier<T> typeBuilder, BiConsumer<T, T> copier) {
        super(numElements);
        this.typeBuilder = typeBuilder;
        this.copier = copier;
        this.unusedObjects = new ArrayDeque(numElements);
        for (int i = 0; i < numElements; ++i) {
            this.unusedObjects.add(typeBuilder.get());
        }
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public T addFirst() {
        T newObject = this.getOrCreateUnusedObject();
        super.addFirst(newObject);
        return newObject;
    }

    public T addLast() {
        T newObject = this.getOrCreateUnusedObject();
        super.addLast(newObject);
        return newObject;
    }

    @Override
    public boolean add(T newObject) {
        return super.add(this.copyAndReturnLocalObject(newObject));
    }

    @Override
    public void clear() {
        while (!super.isEmpty()) {
            this.unusedObjects.add(super.pollFirst());
        }
    }

    @Override
    public void addFirst(T newObject) {
        super.addFirst(this.copyAndReturnLocalObject(newObject));
    }

    @Override
    public void addLast(T newObject) {
        super.addLast(this.copyAndReturnLocalObject(newObject));
    }

    @Override
    public void push(T newObject) {
        super.push(this.copyAndReturnLocalObject(newObject));
    }

    @Override
    public boolean offerFirst(T newObject) {
        return super.offerFirst(this.copyAndReturnLocalObject(newObject));
    }

    @Override
    public boolean offerLast(T newObject) {
        return super.offerLast(this.copyAndReturnLocalObject(newObject));
    }

    @Override
    public T pollFirst() {
        Object objectToReturn = super.pollFirst();
        if (objectToReturn != null) {
            this.unusedObjects.add(objectToReturn);
        }
        return (T)objectToReturn;
    }

    @Override
    public T pollLast() {
        Object objectToReturn = super.pollLast();
        if (objectToReturn != null) {
            this.unusedObjects.add(objectToReturn);
        }
        return (T)objectToReturn;
    }

    @Override
    public T remove() {
        Object objectToReturn = super.remove();
        this.unusedObjects.add(objectToReturn);
        return (T)objectToReturn;
    }

    @Override
    public T poll() {
        Object objectToReturn = super.poll();
        if (objectToReturn != null) {
            this.unusedObjects.add(objectToReturn);
        }
        return (T)objectToReturn;
    }

    @Override
    public T pop() {
        Object objectToReturn = super.pop();
        this.unusedObjects.add(objectToReturn);
        return (T)objectToReturn;
    }

    private T copyAndReturnLocalObject(T objectToCopy) {
        T localObject = this.getOrCreateUnusedObject();
        this.copier.accept(localObject, objectToCopy);
        return localObject;
    }

    private T getOrCreateUnusedObject() {
        if (this.unusedObjects.isEmpty()) {
            return this.typeBuilder.get();
        }
        return this.unusedObjects.poll();
    }

    @Override
    public String toString() {
        Iterator iterator = super.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object nextObject = iterator.next();
            sb.append(nextObject);
            if (!iterator.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public RecyclingArrayDeque<T> clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> descendingIterator() {
        throw new UnsupportedOperationException();
    }
}

