/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.nio;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.PathVisitor;
import us.ihmc.log.LogTools;

public class PathTools {
    private static final String GLOB_SYNTAX_PREFIX = "glob:";
    private static final String REGEX_SYNTAX_PREFIX = "regex:";

    public static String getBaseName(Path path) {
        return FilenameUtils.getBaseName((String)path.toString());
    }

    public static String getExtension(Path path) {
        return FilenameUtils.getExtension((String)path.toString());
    }

    public static Path systemTemporaryDirectory() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static List<Path> findAllPathsRecursivelyThatMatchRegex(Path directory, String regex) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(REGEX_SYNTAX_PREFIX + regex);
        ArrayList<Path> matchingPaths = new ArrayList<Path>();
        PathTools.walkRecursively(directory, (path, pathType) -> {
            if (matcher.matches(path)) {
                matchingPaths.add(path);
            }
            return FileVisitResult.CONTINUE;
        });
        return matchingPaths;
    }

    public static Path findFirstPathMatchingGlob(Path directory, String glob) {
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(GLOB_SYNTAX_PREFIX + glob);
        final Path[] pathHolder = new Path[]{null};
        PathTools.walkRecursively(directory, new BasicPathVisitor(){

            @Override
            public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                if (matcher.matches(path)) {
                    pathHolder[0] = path;
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return pathHolder[0];
    }

    public static boolean directoryHasGlob(Path directory, String glob) {
        return PathTools.findFirstPathMatchingGlob(directory, glob) != null;
    }

    public static void walkRecursively(Path directory, final PathVisitor basicFileVisitor) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path preVisitDirectory, BasicFileAttributes attributes) throws IOException {
                    return basicFileVisitor.visitPath(preVisitDirectory, BasicPathVisitor.PathType.DIRECTORY);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    return basicFileVisitor.visitPath(file, BasicPathVisitor.PathType.FILE);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void walkDepth(final Path directory, int maxDepth, final PathVisitor basicFileVisitor) {
        try {
            Files.walkFileTree(directory, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path preVisitDirectory, BasicFileAttributes attributes) throws IOException {
                    if (preVisitDirectory.equals(directory)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return basicFileVisitor.visitPath(preVisitDirectory, BasicPathVisitor.PathType.DIRECTORY);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        return basicFileVisitor.visitPath(file, BasicPathVisitor.PathType.DIRECTORY);
                    }
                    return basicFileVisitor.visitPath(file, BasicPathVisitor.PathType.FILE);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void walkFlat(Path directory, PathVisitor basicFileVisitor) {
        PathTools.walkDepth(directory, 1, basicFileVisitor);
    }

    public static Path findDirectoryInline(String startingDirectory, String directoryNameToFind, Path fallback) {
        Path startingDirectoryPath;
        Path currentDirectoryPath = startingDirectoryPath = Paths.get(startingDirectory, new String[0]).toAbsolutePath().normalize();
        if (startingDirectory.equals(directoryNameToFind)) {
            return currentDirectoryPath;
        }
        if (Files.exists(currentDirectoryPath.resolve(directoryNameToFind), new LinkOption[0])) {
            return currentDirectoryPath.resolve(directoryNameToFind);
        }
        Path root = Paths.get("/", new String[0]).toAbsolutePath().normalize();
        currentDirectoryPath = currentDirectoryPath.resolve("..").normalize();
        do {
            if (!currentDirectoryPath.getFileName().toString().equals(directoryNameToFind)) continue;
            return currentDirectoryPath;
        } while (!(currentDirectoryPath = currentDirectoryPath.resolve("..").normalize()).equals(root));
        if (fallback == null) {
            LogTools.warn((String)"{} directory could not be found. Starting directory: {}", (Object)directoryNameToFind, (Object)startingDirectoryPath);
            return null;
        }
        return fallback.toAbsolutePath().normalize();
    }

    public static Path findDirectoryInline(String directoryNameToFind) {
        return PathTools.findDirectoryInline(".", directoryNameToFind, null);
    }

    public static Path findPathInline(String startingDirectory, String directoryNameToFind, String subsequentPathToResolve, Path fallback) {
        Path directoryInline = PathTools.findDirectoryInline(startingDirectory, directoryNameToFind, fallback);
        if (directoryInline.equals(fallback.toAbsolutePath().normalize())) {
            return directoryInline;
        }
        Path subsequentPath = directoryInline.resolve(subsequentPathToResolve).normalize();
        if (!Files.exists(subsequentPath, new LinkOption[0])) {
            throw new RuntimeException("Subsequent path does not exist");
        }
        return subsequentPath;
    }

    public static Path findPathInline(String startingDirectory, String directoryNameToFind, String subsequentPathToResolve) {
        Path directoryInline = PathTools.findDirectoryInline(startingDirectory, directoryNameToFind, null);
        if (directoryInline == null) {
            throw new RuntimeException("Could not find directory " + directoryNameToFind + " in " + Paths.get(startingDirectory, new String[0]).toAbsolutePath().normalize());
        }
        Path subsequentPath = directoryInline.resolve(subsequentPathToResolve).normalize();
        if (!Files.exists(subsequentPath, new LinkOption[0])) {
            throw new RuntimeException("Subsequent path does not exist");
        }
        return subsequentPath;
    }
}

