/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.List;

public class ListWrappingIndexTools {
    public static int wrap(int index, List<?> list) {
        if ((index %= list.size()) < 0) {
            index += list.size();
        }
        return index;
    }

    public static int next(int index, List<?> list) {
        return ListWrappingIndexTools.wrap(index + 1, list);
    }

    public static int previous(int index, List<?> list) {
        return ListWrappingIndexTools.wrap(index - 1, list);
    }

    public static <T> T getWrap(int index, List<T> list) {
        index = ListWrappingIndexTools.wrap(index, list);
        return list.get(index);
    }

    public static <T> T setWrap(int index, T newValue, List<T> list) {
        index = ListWrappingIndexTools.wrap(index, list);
        return list.set(index, newValue);
    }

    public static <T> T getNext(int index, List<T> list) {
        return list.get(ListWrappingIndexTools.next(index, list));
    }

    public static <T> T getPrevious(int index, List<T> list) {
        return list.get(ListWrappingIndexTools.previous(index, list));
    }

    public static int subLengthInclusive(int startIndex, int endIndex, List<?> list) {
        if (endIndex == startIndex) {
            return 1;
        }
        if (endIndex > startIndex) {
            return endIndex - startIndex + 1;
        }
        return endIndex + list.size() - startIndex + 1;
    }

    public static int subLengthExclusive(int startIndex, int endIndex, List<?> list) {
        if (endIndex == startIndex) {
            return 0;
        }
        if (endIndex > startIndex) {
            return endIndex - startIndex - 1;
        }
        return endIndex + list.size() - startIndex - 1;
    }

    public static int minDistanceExclusive(int startIndex, int endIndex, List<?> list) {
        if (endIndex == startIndex) {
            return 0;
        }
        return Math.min(ListWrappingIndexTools.subLengthExclusive(startIndex, endIndex, list), ListWrappingIndexTools.subLengthExclusive(endIndex, startIndex, list));
    }

    public static <T> List<T> subListInclusive(int startIndex, int endIndex, List<T> input) {
        ArrayList<T> output = new ArrayList<T>();
        int outputLenth = ListWrappingIndexTools.subLengthInclusive(startIndex, endIndex, input);
        int i = startIndex;
        while (output.size() != outputLenth) {
            output.add(ListWrappingIndexTools.getWrap(i++, input));
        }
        return output;
    }

    public static <T> List<T> subListExclusive(int startIndex, int endIndex, List<T> input) {
        ArrayList<T> output = new ArrayList<T>();
        if (startIndex == endIndex) {
            return output;
        }
        int outputLenth = ListWrappingIndexTools.subLengthExclusive(startIndex, endIndex, input);
        int i = startIndex + 1;
        while (output.size() != outputLenth) {
            output.add(ListWrappingIndexTools.getWrap(i++, input));
        }
        return output;
    }

    public static int removeAllInclusive(int startIndex, int endIndex, List<?> list) {
        int numberOfElementsToRemove = ListWrappingIndexTools.subLengthInclusive(startIndex, endIndex, list);
        for (int count = 0; count < numberOfElementsToRemove; ++count) {
            startIndex = ListWrappingIndexTools.wrap(startIndex, list);
            list.remove(startIndex);
        }
        return numberOfElementsToRemove;
    }

    public static int removeAllExclusive(int startIndex, int endIndex, List<?> list) {
        int numberOfElementsToRemove = ListWrappingIndexTools.subLengthExclusive(startIndex, endIndex, list);
        startIndex = ListWrappingIndexTools.next(startIndex, list);
        for (int count = 0; count < numberOfElementsToRemove; ++count) {
            startIndex = ListWrappingIndexTools.wrap(startIndex, list);
            list.remove(startIndex);
        }
        return numberOfElementsToRemove;
    }
}

