/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.pitest.mutationtest.commandline.MutationCoverageReport;
import org.pitest.util.Glob;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.commons.nio.PathVisitor;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.log.LogTools;

public class MutationTestFacilitator {
    private static final int NUMBER_OF_HOURS_BEFORE_EXPIRATION = 3;
    private static final String REPORT_DIRECTORY_NAME = "pit-reports";
    private Path pitReportsPath;
    private Set<Class<?>> testClassesToRun = new HashSet();
    private Set<String> classPathsToMutate = new TreeSet<String>();
    private List<Class<?>> classesToMutate = new ArrayList();
    private Set<Mutator> mutators = new TreeSet<Mutator>();
    private Set<String> testNamesToRun = new TreeSet<String>();
    private Set<String> methodsToMutate = new TreeSet<String>();
    private List<Path> sourceDirectories = new ArrayList<Path>();

    public void addMutators(Mutator ... mutators) {
        this.mutators.addAll(Arrays.asList(mutators));
    }

    public void addTestClassesToRun(Class<?> ... testClassesToRun) {
        this.testClassesToRun.addAll(Arrays.asList(testClassesToRun));
    }

    public void addPackagePathsToMutate(String ... packagePathsToMutate) {
        this.classPathsToMutate.addAll(Arrays.asList(packagePathsToMutate));
    }

    public void addNeighborClassesToMutate(Class<?> neighborToMutate) {
        this.classPathsToMutate.add(neighborToMutate.getName().substring(0, neighborToMutate.getName().lastIndexOf(46)) + "*");
    }

    public void addClassesToMutate(Class<?> ... classesToMutate) {
        for (int i = 0; i < classesToMutate.length; ++i) {
            this.classesToMutate.add(classesToMutate[i]);
        }
    }

    public void addTestsToRun(String ... testNamesToRun) {
        for (String testName : testNamesToRun) {
            this.testNamesToRun.add(testName);
        }
    }

    public void addMethodsToMutate(String ... methodNamesToMutate) {
        for (String methodName : methodNamesToMutate) {
            this.methodsToMutate.add(methodName);
        }
    }

    public void addSourceDirectories(Path ... sourceDirectories) {
        for (Path sourceDir : sourceDirectories) {
            this.sourceDirectories.add(sourceDir);
        }
    }

    public void setReportDirectory(Path reportDirectory) {
        this.pitReportsPath = reportDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public void doMutationTest() {
        void var5_25;
        void var6_37;
        void var4_17;
        void var6_35;
        void var6_32;
        void var4_14;
        if (this.pitReportsPath == null) {
            this.pitReportsPath = PathTools.findPathInline((String)".", (String)"src", (String)"..", (Path)Paths.get(".", new String[0]));
        }
        this.pitReportsPath = this.pitReportsPath.toAbsolutePath().normalize().resolve(REPORT_DIRECTORY_NAME);
        LogTools.info((String)("Using reports directory: " + this.pitReportsPath));
        PathTools.walkFlat((Path)this.pitReportsPath, (PathVisitor)new BasicPathVisitor(){

            public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                if (pathType == BasicPathVisitor.PathType.DIRECTORY) {
                    String baseName = PathTools.getBaseName((Path)path);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                    Date directoryDate = null;
                    try {
                        directoryDate = simpleDateFormat.parse(baseName);
                        Date currentDate = new Date();
                        long difference = currentDate.getTime() - directoryDate.getTime();
                        if (TimeUnit.HOURS.convert(difference, TimeUnit.MILLISECONDS) > 3L) {
                            FileTools.deleteQuietly((Path)path);
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (this.testClassesToRun.isEmpty()) {
            throw new RuntimeException("No test classes to run!");
        }
        if (this.classPathsToMutate.isEmpty() && this.classesToMutate.isEmpty()) {
            throw new RuntimeException("No class paths to mutate!");
        }
        String targetClasses = "";
        for (String string : this.classPathsToMutate) {
            targetClasses = targetClasses + string + ",";
        }
        for (Class clazz : this.classesToMutate) {
            targetClasses = targetClasses + clazz.getName() + ",";
        }
        if (!targetClasses.isEmpty()) {
            targetClasses = targetClasses.substring(0, targetClasses.lastIndexOf(44));
        }
        String targetTests = "";
        for (Class<?> clazz : this.testClassesToRun) {
            targetTests = targetTests + clazz.getName() + ",";
        }
        for (String string : this.testNamesToRun) {
            targetTests = targetTests + string + ",";
        }
        if (!targetTests.isEmpty()) {
            targetTests = targetTests.substring(0, targetTests.lastIndexOf(44));
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.methodsToMutate) {
            Glob glob = new Glob(string);
            for (Class<?> classToMutate : this.classesToMutate) {
                for (Method method : classToMutate.getDeclaredMethods()) {
                    if (glob.matches((CharSequence)method.getName())) continue;
                    treeSet.add("*" + method.getName() + "*");
                }
            }
        }
        String string = "";
        for (String string2 : treeSet) {
            String string3 = (String)var4_14 + string2 + ",";
        }
        if (!var4_14.isEmpty()) {
            String string4 = var4_14.substring(0, var4_14.lastIndexOf(44));
        }
        String string5 = "";
        if (this.mutators.isEmpty()) {
            String string6 = "ALL";
        } else {
            void var5_22;
            for (Mutator mutator : this.mutators) {
                String string7 = (String)var5_22 + mutator.name() + ",";
            }
            String string8 = var5_22.substring(0, var5_22.lastIndexOf(44));
        }
        String string9 = "";
        for (Path sourceDirectory : this.sourceDirectories) {
            String string10 = (String)var6_32 + sourceDirectory.toAbsolutePath().toString() + ",";
        }
        if (var6_32.isEmpty()) {
            Path path = PathTools.findDirectoryInline((String)"src");
            if (path == null) {
                throw new RuntimeException("Could not find src directory near " + Paths.get(".", new String[0]).toAbsolutePath().normalize());
            }
            String string11 = (String)var6_32 + path.toString() + ",";
        }
        if (!var6_35.isEmpty()) {
            String string12 = var6_35.substring(0, var6_35.lastIndexOf(44));
        }
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        arrayList.add(Pair.of((Object)"--testPlugin", (Object)"junit5"));
        arrayList.add(Pair.of((Object)"--reportDir", (Object)this.pitReportsPath.toString()));
        arrayList.add(Pair.of((Object)"--excludedClasses", (Object)"*Test*"));
        if (!targetClasses.isEmpty()) {
            arrayList.add(Pair.of((Object)"--targetClasses", (Object)targetClasses));
        }
        if (!targetTests.isEmpty()) {
            arrayList.add(Pair.of((Object)"--targetTests", (Object)targetTests));
        }
        if (!var4_17.isEmpty()) {
            arrayList.add(Pair.of((Object)"--excludedMethods", (Object)var4_17));
        }
        if (!var6_37.isEmpty()) {
            arrayList.add(Pair.of((Object)"--sourceDirs", (Object)var6_37));
        }
        if (!var5_25.isEmpty()) {
            arrayList.add(Pair.of((Object)"--mutators", (Object)var5_25));
        }
        LogTools.info((String)"Launching MutationCoverageReport with arguments: ");
        ArrayList<Object> argList = new ArrayList<Object>();
        for (Pair argPair : arrayList) {
            System.out.println((String)argPair.getLeft() + " " + (String)argPair.getRight());
            argList.add(argPair.getLeft());
            argList.add(argPair.getRight());
        }
        MutationCoverageReport.main((String[])argList.toArray(new String[0]));
    }

    public void openResultInBrowser() {
        if (Files.exists(this.pitReportsPath, new LinkOption[0]) && Files.isDirectory(this.pitReportsPath, new LinkOption[0])) {
            File[] list = this.pitReportsPath.toFile().listFiles();
            TreeSet<String> sortedNumberOnlyNames = new TreeSet<String>();
            for (File file : list) {
                if (file.getName().matches("^[0-9]+$")) {
                    // empty if block
                }
                sortedNumberOnlyNames.add(file.getName());
            }
            final String lastDirectoryName = (String)sortedNumberOnlyNames.last();
            System.out.println("Found last directory " + lastDirectoryName);
            PathTools.walkFlat((Path)this.pitReportsPath.resolve(lastDirectoryName), (PathVisitor)new BasicPathVisitor(){

                public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                    String longPathName = path.getFileName().toString();
                    if (longPathName.length() > 50) {
                        String displayShortenedNameInIndex = longPathName.substring(0, 20) + "..." + longPathName.substring(longPathName.length() - 20, longPathName.length());
                        Path indexPath = MutationTestFacilitator.this.pitReportsPath.resolve(lastDirectoryName).resolve("index.html");
                        List lines = FileTools.readAllLines((Path)indexPath, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
                        ArrayList<String> newLines = new ArrayList<String>();
                        for (String originalLine : lines) {
                            newLines.add(MutationTestFacilitator.replaceLast(originalLine, longPathName, displayShortenedNameInIndex));
                        }
                        FileTools.writeAllLines(newLines, (Path)indexPath, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            File reportFile = this.pitReportsPath.resolve(lastDirectoryName).resolve("index.html").toFile();
            try {
                String absolutePath = reportFile.getCanonicalPath();
                absolutePath = absolutePath.replace("\\", "/");
                System.out.println("Opening file://" + absolutePath);
                URI uri = new URI("file://" + absolutePath);
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replacement);
    }

    public static void facilitateMutationTestForClass(Class<?> applicationClass, Class<?> testClass) {
        MutationTestFacilitator mutationTestFacilitator = new MutationTestFacilitator();
        mutationTestFacilitator.addClassesToMutate(applicationClass);
        mutationTestFacilitator.addTestClassesToRun(testClass);
        mutationTestFacilitator.doMutationTest();
        mutationTestFacilitator.openResultInBrowser();
    }

    public static void facilitateMutationTestForPackage(Class<?> testClass) {
        MutationTestFacilitator mutationTestFacilitator = new MutationTestFacilitator();
        mutationTestFacilitator.addNeighborClassesToMutate(testClass);
        mutationTestFacilitator.addTestClassesToRun(testClass);
        mutationTestFacilitator.doMutationTest();
        mutationTestFacilitator.openResultInBrowser();
    }

    public static void facilitateMutationTestForClasses(Class<?>[] applicationClasses, Class<?>[] testClasses) {
        MutationTestFacilitator mutationTestFacilitator = new MutationTestFacilitator();
        mutationTestFacilitator.addClassesToMutate(applicationClasses);
        mutationTestFacilitator.addTestClassesToRun(testClasses);
        mutationTestFacilitator.doMutationTest();
        mutationTestFacilitator.openResultInBrowser();
    }

    public static enum Mutator {
        RETURN_VALS,
        INLINE_CONSTS,
        MATH,
        VOID_METHOD_CALLS,
        NEGATE_CONDITIONALS,
        CONDITIONALS_BOUNDARY,
        INCREMENTS,
        REMOVE_INCREMENTS,
        NON_VOID_METHOD_CALLS,
        CONSTRUCTOR_CALLS,
        REMOVE_CONDITIONALS_EQ_IF,
        REMOVE_CONDITIONALS_EQ_ELSE,
        REMOVE_CONDITIONALS_ORD_IF,
        REMOVE_CONDITIONALS_ORD_ELSE,
        REMOVE_CONDITIONALS,
        EXPERIMENTAL_MEMBER_VARIABLE,
        EXPERIMENTAL_SWITCH,
        EXPERIMENTAL_ARGUMENT_PROPAGATION,
        REMOVE_SWITCH;

    }
}

