/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.thread.TypedNotification;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;

public class TypedNotificationTest {
    @Test
    public void testNotified() {
        TypedNotification notification = new TypedNotification();
        Assertions.assertTrue((notification.peek() == null ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)notification.peekHasValue());
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.hasValue());
        Assertions.assertNull((Object)notification.read());
        notification.set((Object)6);
        Assertions.assertTrue((boolean)notification.peekHasValue());
        Assertions.assertEquals((int)6, (Integer)((Integer)notification.peek()));
        Assertions.assertTrue((boolean)notification.poll());
        Assertions.assertTrue((boolean)notification.hasValue());
        Assertions.assertEquals((int)6, (Integer)((Integer)notification.read()));
    }

    @Test
    public void testNotifiedBeforeBlockingPollCalled() {
        TypedNotification notification = new TypedNotification();
        notification.set(new Object());
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> notification.blockingPoll());
        Assertions.assertNotNull((Object)notification.read());
    }

    @Test
    public void testNotificationFromThread() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> {
            TypedNotification notification = new TypedNotification();
            Assertions.assertFalse((boolean)notification.poll());
            Assertions.assertNull((Object)notification.read());
            double secondsToSleep = 0.2;
            Stopwatch stopwatch = new Stopwatch().start();
            ThreadTools.startAThread(() -> {
                ThreadTools.sleepSeconds((double)secondsToSleep);
                notification.set((Object)8);
            }, (String)"SetterThread");
            Assertions.assertEquals((int)8, (Integer)((Integer)notification.blockingPoll()));
            double elapsed = stopwatch.totalElapsed();
            LogTools.info((String)"Elapsed: {}", (Object)elapsed);
            Assertions.assertEquals((double)secondsToSleep, (double)elapsed, (double)0.1);
            Assertions.assertEquals((int)8, (Integer)((Integer)notification.read()));
        });
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> {
            TypedNotification notification = new TypedNotification();
            Assertions.assertFalse((boolean)notification.poll());
            Assertions.assertNull((Object)notification.read());
            double secondsToSleep = 0.2;
            Stopwatch stopwatch = new Stopwatch().start();
            ThreadTools.startAThread(() -> {
                ThreadTools.sleepSeconds((double)secondsToSleep);
                notification.set((Object)8);
            }, (String)"SetterThread");
            Assertions.assertEquals((int)8, (Integer)((Integer)notification.blockingPeek()));
            double elapsed = stopwatch.totalElapsed();
            LogTools.info((String)"Elapsed: {}", (Object)elapsed);
            Assertions.assertEquals((double)secondsToSleep, (double)elapsed, (double)0.1);
            Assertions.assertEquals((int)8, (Integer)((Integer)notification.peek()));
            Assertions.assertNull((Object)notification.read());
        });
    }

    @Test
    public void testInterruptedWhileBlocking() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> {
            TypedNotification notification = new TypedNotification();
            Assertions.assertFalse((boolean)notification.poll());
            Assertions.assertEquals(null, (Integer)((Integer)notification.read()));
            Stopwatch stopwatch = new Stopwatch().start();
            Thread blockingThread = ThreadTools.startAThread(() -> {
                RuntimeException runtimeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> notification.blockingPoll(DefaultExceptionHandler.RUNTIME_EXCEPTION));
                Assertions.assertEquals(InterruptedException.class, runtimeException.getCause().getClass());
                stopwatch.suspend();
            }, (String)"BlockingThread");
            ThreadTools.sleep((long)200L);
            blockingThread.interrupt();
            LogTools.info((String)"Time taken: {}", (Object)stopwatch.lapElapsed());
            Assertions.assertTrue((stopwatch.lapElapsed() > 0.2 ? 1 : 0) != 0);
        });
    }
}

