/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.lists.BoundedRecyclingArrayList;

@Execution(value=ExecutionMode.SAME_THREAD)
public class BoundedRecyclingArrayListTest {
    @Test
    public void testOutOfMemoryError() {
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(5, MutableInt::new);
        for (int i = 0; i < 5; ++i) {
            list.add();
        }
        Assertions.assertExceptionThrown(OutOfMemoryError.class, () -> list.add());
        BoundedRecyclingArrayList list2 = new BoundedRecyclingArrayList(500, MutableInt::new);
        for (int i = 0; i < 500; ++i) {
            list2.add();
        }
        Assertions.assertExceptionThrown(OutOfMemoryError.class, () -> list2.add());
    }

    @Test
    public void testConstructors() {
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(50, Object.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        list = new BoundedRecyclingArrayList(50, Object::new);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        int capacity = 10;
        list = new BoundedRecyclingArrayList(capacity, Object.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        list = new BoundedRecyclingArrayList(capacity, Object::new);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndGet() {
        int i;
        Object lastObject;
        int i2;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(0, 50, Object::new);
        ArrayList<Object> expectedList = new ArrayList<Object>();
        int finalSize = 10;
        for (i2 = 0; i2 < finalSize; ++i2) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i2 = 0; i2 < finalSize; ++i2) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i2) == expectedList.get(i2) ? 1 : 0) != 0);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        try {
            list.get(finalSize);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException i3) {
            // empty catch block
        }
        list.clear();
        expectedList.clear();
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 8;
        for (i = 0; i < finalSize; ++i) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        list.clear();
        expectedList.clear();
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 20;
        for (i = 0; i < finalSize; ++i) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
    }

    @Test
    public void testGetAndGrowIfNeeded() {
        int i;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(0, 50, Object::new);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        int newSize = 10;
        Object lastObject = list.getAndGrowIfNeeded(newSize - 1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == newSize ? 1 : 0) != 0);
        for (int i2 = 0; i2 < newSize; ++i2) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i2) != null ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(list.get(i2) instanceof Object));
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.get(newSize - 1) == lastObject ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == lastObject ? 1 : 0) != 0);
        int previousSize = newSize;
        newSize = 3;
        lastObject = list.getAndGrowIfNeeded(newSize - 1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == previousSize ? 1 : 0) != 0);
        for (i = 0; i < newSize; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) != null ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(list.get(i) instanceof Object));
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.get(newSize - 1) == lastObject ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == list.get(previousSize - 1) ? 1 : 0) != 0);
        newSize = 13;
        lastObject = list.getAndGrowIfNeeded(newSize - 1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == newSize ? 1 : 0) != 0);
        for (i = 0; i < newSize; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) != null ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(list.get(i) instanceof Object));
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.get(newSize - 1) == lastObject ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((list.getLast() == lastObject ? 1 : 0) != 0);
    }

    @Test
    public void testFastRemove() {
        int currentSize = 10;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(currentSize, 50, Object::new);
        for (int i = 0; i < currentSize; ++i) {
            list.add();
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<Object> savedList = new ArrayList<Object>();
        for (int i = 0; i < currentSize; ++i) {
            savedList.add(list.get(i));
        }
        int indexOfRemovedOject = 3;
        list.fastRemove(indexOfRemovedOject);
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (int i = 0; i < currentSize; ++i) {
            if (i == indexOfRemovedOject) {
                org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == savedList.get(savedList.size() - 1) ? 1 : 0) != 0);
                continue;
            }
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == savedList.get(i) ? 1 : 0) != 0);
        }
        try {
            list.fastRemove(currentSize);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() {
        int i;
        int currentSize = 10;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(currentSize, 50, MutableInt::new);
        for (int i2 = 0; i2 < currentSize; ++i2) {
            ((MutableInt)list.add()).setValue(10 + i2);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<MutableInt> expectedList = new ArrayList<MutableInt>();
        for (int i3 = 0; i3 < currentSize; ++i3) {
            expectedList.add((MutableInt)list.get(i3));
        }
        int indexOfRemovedOject = 3;
        list.remove(indexOfRemovedOject);
        expectedList.remove(indexOfRemovedOject);
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        indexOfRemovedOject = currentSize - 1;
        list.remove(indexOfRemovedOject);
        expectedList.remove(indexOfRemovedOject);
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        try {
            list.remove(currentSize);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSwap() {
        Random rand = new Random(541964L);
        int currentSize = 10;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(currentSize, 50, MutableInt::new);
        for (int i = 0; i < currentSize; ++i) {
            ((MutableInt)list.add()).setValue(10 + i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<MutableInt> expectedList = new ArrayList<MutableInt>();
        for (int i = 0; i < currentSize; ++i) {
            expectedList.add((MutableInt)list.get(i));
        }
        for (int k = 0; k < 20; ++k) {
            int indexA = RandomNumbers.nextInt((Random)rand, (int)0, (int)(currentSize - 1));
            int indexB = RandomNumbers.nextInt((Random)rand, (int)0, (int)(currentSize - 1));
            list.swap(indexA, indexB);
            Collections.swap(expectedList, indexA, indexB);
            org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
            for (int i = 0; i < currentSize; ++i) {
                org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
            }
        }
        try {
            list.swap(0, currentSize);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.swap(currentSize, 0);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testInsertAtIndex() {
        Random rand = new Random(541964L);
        int currentSize = 10;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(currentSize, 50, MutableInt::new);
        for (int i = 0; i < currentSize; ++i) {
            ((MutableInt)list.add()).setValue(10 + i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<MutableInt> expectedList = new ArrayList<MutableInt>();
        for (int i = 0; i < currentSize; ++i) {
            expectedList.add((MutableInt)list.get(i));
        }
        for (int k = 0; k < 20; ++k) {
            int randomIndex = RandomNumbers.nextInt((Random)rand, (int)0, (int)currentSize);
            if (k == 5) {
                randomIndex = currentSize;
            }
            int newRandomValue = RandomNumbers.nextInt((Random)rand, (int)0, (int)52161);
            MutableInt newObject = (MutableInt)list.insertAtIndex(randomIndex);
            newObject.setValue(newRandomValue);
            expectedList.add(randomIndex, newObject);
            org.junit.jupiter.api.Assertions.assertTrue((list.size() == ++currentSize ? 1 : 0) != 0);
            for (int i = 0; i < currentSize; ++i) {
                org.junit.jupiter.api.Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
            }
        }
        try {
            list.insertAtIndex(currentSize + 1);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testShuffle() {
        Random random = new Random(541964L);
        int currentSize = 100;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(currentSize, 50, MutableInt::new);
        for (int i = 0; i < currentSize; ++i) {
            ((MutableInt)list.add()).setValue(10 + i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        int sumBefore = 0;
        for (int i = 0; i < list.size(); ++i) {
            MutableInt value = (MutableInt)list.get(i);
            sumBefore += value.intValue();
        }
        org.junit.jupiter.api.Assertions.assertTrue((sumBefore > 0 ? 1 : 0) != 0);
        list.shuffle(random);
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        int sumAfter = 0;
        for (int i = 0; i < list.size(); ++i) {
            MutableInt value = (MutableInt)list.get(i);
            sumAfter += value.intValue();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)sumBefore, (int)sumAfter);
    }

    @Test
    public void testIteratorHasNext() {
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(0, 50, Object::new);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)list.iterator().hasNext());
        int size = 10;
        for (int i = 0; i < size; ++i) {
            list.add();
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < size; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
            iterator.next();
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorNext() {
        int size = 15;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(size, 50, MutableInt::new);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < size; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((((MutableInt)iterator.next()).getValue() == i ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIteratorRemove() {
        int i;
        int initialSize = 8;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(initialSize, 50, MutableInt::new);
        for (int i2 = 0; i2 < initialSize; ++i2) {
            ((MutableInt)list.add()).setValue(i2);
        }
        Iterator iterator = list.iterator();
        try {
            iterator.remove();
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == initialSize ? 1 : 0) != 0);
        iterator.next();
        iterator.remove();
        org.junit.jupiter.api.Assertions.assertTrue((list.size() == initialSize - 1 ? 1 : 0) != 0);
        for (i = 0; i < initialSize - 1; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((((MutableInt)list.get(i)).getValue() == i + 1 ? 1 : 0) != 0);
        }
        for (i = 0; i < initialSize - 1; ++i) {
            iterator.next();
            iterator.remove();
            org.junit.jupiter.api.Assertions.assertTrue((list.size() == initialSize - (i + 2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIteratorForEachRemaining() {
        int i;
        int initialSize = 10;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(initialSize, 50, MutableInt::new);
        for (int i2 = 0; i2 < initialSize; ++i2) {
            list.add();
        }
        int testIndex = 5;
        Iterator iterator = list.iterator();
        for (i = 0; i < testIndex; ++i) {
            iterator.next();
        }
        iterator.forEachRemaining(value -> value.setValue(100));
        for (i = 0; i < initialSize; ++i) {
            int value2 = ((MutableInt)list.get(i)).getValue();
            if (i < testIndex) {
                org.junit.jupiter.api.Assertions.assertTrue((value2 == 0 ? 1 : 0) != 0);
                continue;
            }
            org.junit.jupiter.api.Assertions.assertTrue((value2 == 100 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEmptyConstructor() {
        new BoundedRecyclingArrayList();
    }

    @Test
    public void testSort() {
        int i;
        BoundedRecyclingArrayList list = new BoundedRecyclingArrayList(10, 50, MutableInt::new);
        for (i = 0; i < list.size(); ++i) {
            ((MutableInt)list.get(i)).setValue(i);
        }
        list.shuffle(new Random(239032L));
        list.sort(MutableInt::compareTo);
        for (i = 0; i < list.size(); ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((((MutableInt)list.get(i)).getValue() == i ? 1 : 0) != 0);
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(BoundedRecyclingArrayList.class, BoundedRecyclingArrayListTest.class);
    }
}

