/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.AngleTools;
import us.ihmc.commons.RandomNumbers;

public class AngleToolsTest {
    @Test
    public void testConstructor() throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assertions.assertEquals((int)1, (int)AngleTools.class.getDeclaredConstructors().length);
        Constructor constructor = AngleTools.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertTrue((boolean)Modifier.isPrivate(constructor.getModifiers()));
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
    }

    @Test
    public void testComputeAngleDifferenceMinusTwoPiToZero() {
        Random random = new Random(123456L);
        double angleA = Math.PI;
        double angleB = 1.5707963267948966;
        double expectedReturn = -4.71238898038469;
        double actualReturn = AngleTools.computeAngleDifferenceMinusTwoPiToZero((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)Double.MIN_VALUE);
        for (int i = 0; i < 25; ++i) {
            angleA = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            double ret = AngleTools.computeAngleDifferenceMinusTwoPiToZero((double)angleA, (double)(angleB = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0)));
            Assertions.assertTrue((ret <= 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ret >= Math.PI * -2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComputeAngleDifferenceMinusPiToPi() {
        Random random = new Random(123456L);
        double angleA = Math.PI;
        double angleB = 1.5707963267948966;
        double expectedReturn = 1.5707963267948966;
        double actualReturn = AngleTools.computeAngleDifferenceMinusPiToPi((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)Double.MIN_VALUE);
        for (int i = 0; i < 25; ++i) {
            angleA = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            double ret = AngleTools.computeAngleDifferenceMinusPiToPi((double)angleA, (double)(angleB = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0)));
            Assertions.assertTrue((ret <= Math.PI ? 1 : 0) != 0);
            Assertions.assertTrue((ret >= -Math.PI ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComputeAngleDifferenceMinusPiToPiUsingTrim() {
        Random random = new Random(123456L);
        double angleA = Math.PI;
        double angleB = 1.5707963267948966;
        double expectedReturn = 1.5707963267948966;
        double actualReturn = AngleTools.trimAngleMinusPiToPi((double)(angleA - angleB));
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)Double.MIN_VALUE);
        for (int i = 0; i < 25; ++i) {
            angleA = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            double ret = AngleTools.trimAngleMinusPiToPi((double)(angleA - (angleB = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0))));
            Assertions.assertTrue((ret <= Math.PI ? 1 : 0) != 0);
            Assertions.assertTrue((ret >= -Math.PI ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFindClosestNinetyDegreeYaw() {
        double yawInRadians = -1.2566370614359172;
        int expectedReturn = 3;
        int actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assertions.assertEquals((int)expectedReturn, (int)actualReturn);
        yawInRadians = 1.8849555921538759;
        expectedReturn = 1;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assertions.assertEquals((int)expectedReturn, (int)actualReturn);
        yawInRadians = 2.827433388230814;
        expectedReturn = 2;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assertions.assertEquals((int)expectedReturn, (int)actualReturn);
        yawInRadians = 7.5398223686155035;
        expectedReturn = 1;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assertions.assertEquals((int)expectedReturn, (int)actualReturn);
        yawInRadians = Math.PI * 4;
        expectedReturn = 0;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assertions.assertEquals((int)expectedReturn, (int)actualReturn);
    }

    @Test
    public void testGenerateRandomAngle() {
        Random random = new Random(0L);
        for (int i = 0; i < 25; ++i) {
            double randomAngle = AngleTools.generateRandomAngle((Random)random);
            Assertions.assertTrue((randomAngle <= Math.PI * 2 ? 1 : 0) != 0);
            Assertions.assertTrue((randomAngle >= Math.PI * -2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGenerateArrayOfTestAngles() {
        double[] anglesWithoutZeroOrPlusMinusPi = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)false, (boolean)false);
        int i = 0;
        for (double angle : anglesWithoutZeroOrPlusMinusPi) {
            Assertions.assertTrue((angle != 0.0 ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != -Math.PI ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * 2 ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * -2 ? 1 : 0) != 0, (String)("array index = " + i));
            ++i;
        }
        double[] anglesWithoutZero = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)false, (boolean)true);
        int numberOfAnglesEqualToPlusPI = 0;
        int numberOfAnglesEqualToMinusPI = 0;
        i = 0;
        for (double angle : anglesWithoutZero) {
            if (angle == Math.PI) {
                ++numberOfAnglesEqualToPlusPI;
            }
            if (angle == -Math.PI) {
                ++numberOfAnglesEqualToMinusPI;
            }
            Assertions.assertTrue((angle != 0.0 ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * 2 ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * -2 ? 1 : 0) != 0, (String)("array index = " + i));
            ++i;
        }
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToPlusPI, (String)"Should have found one angle equal to +PI!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToMinusPI, (String)"Should have found one angle equal to -PI!");
        double[] anglesWithoutPlusMinusPi = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)true, (boolean)false);
        int numberOfAnglesEqualToZero = 0;
        i = 0;
        for (double angle : anglesWithoutPlusMinusPi) {
            if (angle == 0.0) {
                ++numberOfAnglesEqualToZero;
            }
            Assertions.assertTrue((angle != Math.PI ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != -Math.PI ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * 2 ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * -2 ? 1 : 0) != 0, (String)("array index = " + i));
            ++i;
        }
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToZero, (String)"Should have found one angle equal to 0.0!");
        double[] allAnglesExceptPlusMinus2PI = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)true, (boolean)true);
        i = 0;
        numberOfAnglesEqualToZero = 0;
        numberOfAnglesEqualToPlusPI = 0;
        numberOfAnglesEqualToMinusPI = 0;
        for (double angle : allAnglesExceptPlusMinus2PI) {
            if (angle == 0.0) {
                ++numberOfAnglesEqualToZero;
            }
            if (angle == Math.PI) {
                ++numberOfAnglesEqualToPlusPI;
            }
            if (angle == -Math.PI) {
                ++numberOfAnglesEqualToMinusPI;
            }
            Assertions.assertTrue((angle != Math.PI * 2 ? 1 : 0) != 0, (String)("array index = " + i));
            Assertions.assertTrue((angle != Math.PI * -2 ? 1 : 0) != 0, (String)("array index = " + i));
            ++i;
        }
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToZero, (String)"Should have found one angle equal to 0.0!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToPlusPI, (String)"Should have found one angle equal to +PI!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToMinusPI, (String)"Should have found one angle equal to -PI!");
        double[] allAnglesIncludingPlusMinus2PI = AngleTools.generateArrayOfTestAngles((int)100, (double)0.0, (boolean)true, (boolean)true);
        i = 0;
        numberOfAnglesEqualToZero = 0;
        numberOfAnglesEqualToPlusPI = 0;
        numberOfAnglesEqualToMinusPI = 0;
        int numberOfAnglesEqualToPlus2PI = 0;
        int numberOfAnglesEqualToMinus2PI = 0;
        for (double angle : allAnglesIncludingPlusMinus2PI) {
            if (angle == 0.0) {
                ++numberOfAnglesEqualToZero;
            }
            if (angle == Math.PI) {
                ++numberOfAnglesEqualToPlusPI;
            }
            if (angle == -Math.PI) {
                ++numberOfAnglesEqualToMinusPI;
            }
            if (angle == Math.PI * 2) {
                ++numberOfAnglesEqualToPlus2PI;
            }
            if (angle == Math.PI * -2) {
                ++numberOfAnglesEqualToMinus2PI;
            }
            ++i;
        }
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToZero, (String)"Should have found one angle equal to 0.0!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToPlusPI, (String)"Should have found one angle equal to +PI!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToMinusPI, (String)"Should have found one angle equal to -PI!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToPlus2PI, (String)"Should have found one angle equal to +2PI!");
        Assertions.assertEquals((int)1, (int)numberOfAnglesEqualToMinus2PI, (String)"Should have found one angle equal to -2PI!");
    }

    @Test
    public void testShiftAngleToStartOfRange() {
        double angleToShift = 0.5;
        double startOfAngleRange = Math.PI;
        double expectedReturn = 6.783185307179586;
        double actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)startOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        angleToShift = 12.0;
        startOfAngleRange = 1.5707963267948966;
        expectedReturn = 5.716814692820414;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)startOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        angleToShift = 0.8;
        startOfAngleRange = -0.7853981633974483;
        expectedReturn = 0.8;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)startOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
    }

    @Test
    public void testShiftAngleToStartOfRangeUnitless() {
        double range;
        double endOfAngleRange = range = Math.pow(2.0, 13.0);
        double angleToShift = 1.6 * range;
        double expectedReturn = 0.6 * range;
        double actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        angleToShift = -0.4 * range;
        expectedReturn = 0.6 * range;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        angleToShift = 0.4 * range;
        expectedReturn = 0.4 * range;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        int iters = 1000;
        Random random = new Random();
        for (int i = 0; i < iters; ++i) {
            double ratio = -6.0 + 12.0 * random.nextDouble();
            expectedReturn = angleToShift = ratio * range;
            if (angleToShift < 0.0) {
                expectedReturn = angleToShift + Math.ceil(-angleToShift / endOfAngleRange) * endOfAngleRange;
            }
            if (angleToShift >= endOfAngleRange) {
                expectedReturn = angleToShift - Math.floor(angleToShift / endOfAngleRange) * endOfAngleRange;
            }
            actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
            Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        }
    }

    @Test
    public void testTrimAngleMinusPiToPi() {
        Random random = new Random(0L);
        for (int i = 0; i < 25; ++i) {
            double randomAngle = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            Assertions.assertTrue(((randomAngle = AngleTools.trimAngleMinusPiToPi((double)randomAngle)) <= Math.PI ? 1 : 0) != 0);
            Assertions.assertTrue((randomAngle >= -Math.PI ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComputeAngleAverage() {
        double angleA = Math.PI;
        double angleB = 6.583185307179586;
        double expected = 1.7207963267948965;
        double actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        angleB = Math.PI;
        angleA = 6.583185307179586;
        expected = 1.7207963267948965;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        angleA = 0.3;
        angleB = Math.PI;
        expected = 1.7207963267948965;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        angleA = 2.8415926535897933;
        angleB = -3.041592653589793;
        expected = 3.041592653589793;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        angleB = 2.8415926535897933;
        angleA = -3.041592653589793;
        expected = 3.041592653589793;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
    }

    @Test
    public void testAngleFromZeroToTwoPi() {
        Assertions.assertEquals((double)0.0, (double)AngleTools.angleFromZeroToTwoPi((double)0.0, (double)0.0), (double)1.0E-7, (String)"not equal");
        Assertions.assertEquals((double)0.7853981633974483, (double)AngleTools.angleFromZeroToTwoPi((double)1.0, (double)1.0), (double)1.0E-7, (String)"not equal");
        Assertions.assertEquals((double)5.497787143782138, (double)AngleTools.angleFromZeroToTwoPi((double)1.0, (double)-1.0), (double)1.0E-7, (String)"not equal");
    }
}

