/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.thread.Throttler;
import us.ihmc.commons.time.FrequencyCalculator;
import us.ihmc.log.LogTools;

public class ThrottlerAndFrequencyCalculatorTest {
    private static void testFrequencyCounter(double targetFrequency, double epsilon) {
        LogTools.info((String)("testFrequencyCounter targetFrequency=" + targetFrequency + " epsilon=" + epsilon));
        long start = System.currentTimeMillis();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator(true);
        while (System.currentTimeMillis() - start < 5000L) {
            frequencyCalculator.ping();
            double sleepTimeSeconds = Conversions.hertzToSeconds((double)targetFrequency);
            ThreadTools.park((double)sleepTimeSeconds);
        }
        frequencyCalculator.destroy();
        Assertions.assertEquals((double)targetFrequency, (double)frequencyCalculator.getFrequency(), (double)epsilon, (String)"Frequency not correct");
    }

    private static void testFrequencyCounterDecaying(double targetFrequency, double decayTimeSeconds, double epsilon) {
        LogTools.info((String)("testFrequencyCounter (decaying) targetFrequency=" + targetFrequency + " decayTimeSeconds=" + decayTimeSeconds + " epsilon=" + epsilon));
        long start = System.currentTimeMillis();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator(true);
        while (System.currentTimeMillis() - start < 5000L) {
            frequencyCalculator.ping();
            double sleepTimeSeconds = Conversions.hertzToSeconds((double)targetFrequency);
            ThreadTools.park((double)sleepTimeSeconds);
        }
        frequencyCalculator.destroy();
        ThreadTools.park((double)decayTimeSeconds);
        double targetDecayFrequency = frequencyCalculator.getFrequency() / Math.exp(decayTimeSeconds);
        Assertions.assertEquals((double)targetDecayFrequency, (double)frequencyCalculator.getFrequencyDecaying(), (double)epsilon);
    }

    private static void testThrottlerAndFrequencyCounter(double targetFrequency, double epsilon) {
        LogTools.info((String)("testThrottlerAndFrequencyCounter (using us.ihmc.tools.thread.Throttler) targetFrequency=" + targetFrequency + " epsilon=" + epsilon));
        Throttler throttler = new Throttler();
        throttler.setFrequency(targetFrequency);
        throttler.waitAndRun();
        long start = System.currentTimeMillis();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator(true);
        while (System.currentTimeMillis() - start < 5000L) {
            frequencyCalculator.ping();
            throttler.waitAndRun();
        }
        frequencyCalculator.destroy();
        Assertions.assertEquals((double)targetFrequency, (double)frequencyCalculator.getFrequency(), (double)epsilon, (String)"Frequency not correct");
    }

    @Test
    public void testFrequencyCounter100Hz() {
        ThrottlerAndFrequencyCalculatorTest.testFrequencyCounter(100.0, 2.0);
    }

    @Test
    public void testThrottlerAndFrequencyCounter100Hz() {
        ThrottlerAndFrequencyCalculatorTest.testThrottlerAndFrequencyCounter(100.0, 2.0);
    }

    @Test
    public void testFrequencyCounter10Hz() {
        ThrottlerAndFrequencyCalculatorTest.testFrequencyCounter(10.0, 0.2);
    }

    @Test
    public void testThrottlerAndFrequencyCounter10Hz() {
        ThrottlerAndFrequencyCalculatorTest.testThrottlerAndFrequencyCounter(10.0, 0.2);
    }

    @Test
    public void testFrequencyCounter1Hz() {
        ThrottlerAndFrequencyCalculatorTest.testFrequencyCounter(1.0, 0.002);
    }

    @Test
    public void testThrottlerAndFrequencyCounter1Hz() {
        ThrottlerAndFrequencyCalculatorTest.testThrottlerAndFrequencyCounter(1.0, 0.002);
    }

    @Test
    public void testFrequencyCounter0_5Hz() {
        ThrottlerAndFrequencyCalculatorTest.testFrequencyCounter(0.5, 0.001);
    }

    @Test
    public void testThrottlerAndFrequencyCounter0_5Hz() {
        ThrottlerAndFrequencyCalculatorTest.testThrottlerAndFrequencyCounter(0.5, 0.001);
    }

    @Test
    public void testThrottlerAndFrequencyCounter100HzDecaying() {
        ThrottlerAndFrequencyCalculatorTest.testFrequencyCounterDecaying(100.0, 5.0, 2.0);
    }

    @Test
    public void testThrottlerAndFrequencyCounter50HzDecaying() {
        ThrottlerAndFrequencyCalculatorTest.testFrequencyCounterDecaying(50.0, 10.0, 1.0);
    }
}

