/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;

public class ThreadToolsTest {
    @Test
    public void testTimeLimitScheduler() {
        int ITERATIONS = 10;
        double EPSILON = 40.0;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 3L;
        long timeLimit = 300L;
        Runnable runnable = () -> Math.sqrt(Math.PI);
        for (int i = 0; i < 10; ++i) {
            long startTime = System.currentTimeMillis();
            ScheduledFuture future = ThreadTools.scheduleWithFixeDelayAndTimeLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (long)timeLimit, (boolean)true);
            while (!future.isDone()) {
            }
            long endTime = System.currentTimeMillis();
            Assertions.assertEquals((double)timeLimit, (double)(endTime - startTime), (double)40.0);
        }
    }

    @Test
    public void testTimeLimitSchedulerInterrupt() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 3L;
        long timeLimit = 300L;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> {
            counter.incrementAndGet();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LogTools.info((String)"Interrupted!");
            }
        };
        Stopwatch stopwatch2 = new Stopwatch().start();
        ScheduledFuture future = ThreadTools.scheduleWithFixeDelayAndTimeLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (long)timeLimit, (boolean)true);
        while (!future.isDone()) {
        }
        double elapsedMilliseconds = Conversions.secondsToMilliseconds((double)stopwatch2.totalElapsed());
        LogTools.info((String)("elapsedMilliseconds = " + elapsedMilliseconds));
        Assertions.assertEquals((double)300.0, (double)elapsedMilliseconds, (double)30.0);
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    public void testTimeLimitSchedulerGraceful() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 3L;
        long timeLimit = 300L;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> {
            counter.incrementAndGet();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LogTools.info((String)"Interrupted!");
            }
        };
        Stopwatch stopwatch2 = new Stopwatch().start();
        ScheduledFuture future = ThreadTools.scheduleWithFixeDelayAndTimeLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (long)timeLimit, (boolean)false);
        while (!future.isDone()) {
        }
        double elapsedMilliseconds = Conversions.secondsToMilliseconds((double)stopwatch2.totalElapsed());
        LogTools.info((String)("elapsedMilliseconds = " + elapsedMilliseconds));
        Assertions.assertEquals((double)400.0, (double)elapsedMilliseconds, (double)30.0);
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    public void testSingleExecution() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long delay = 100L;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> counter.incrementAndGet();
        ScheduledFuture future = ThreadTools.scheduleSingleExecution((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)delay, (TimeUnit)timeUnit);
        Stopwatch stopwatch = new Stopwatch().start();
        while (!future.isDone()) {
        }
        double elapsedMilliseconds = Conversions.secondsToMilliseconds((double)stopwatch.totalElapsed());
        LogTools.info((String)("elapsedMilliseconds = " + elapsedMilliseconds));
        Assertions.assertEquals((double)100.0, (double)elapsedMilliseconds, (double)10.0);
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void testIterationLimitScheduler() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 10L;
        int iterations = 10;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> counter.incrementAndGet();
        ScheduledFuture future = ThreadTools.scheduleWithFixedDelayAndIterationLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (int)10);
        while (!future.isDone()) {
        }
        Assertions.assertEquals((int)10, (int)counter.get());
    }

    @Test
    public void testExecuteWithTimeout() {
        final StateHolder holder = new StateHolder();
        for (int i = 0; i < 10; ++i) {
            holder.state = State.DIDNT_RUN;
            ThreadTools.executeWithTimeout((String)"timeoutTest1", (Runnable)new Runnable(){

                @Override
                public void run() {
                    holder.state = State.TIMED_OUT;
                    ThreadTools.sleep((long)10L);
                    holder.state = State.RAN_WITHOUT_TIMING_OUT;
                }
            }, (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assertions.assertFalse((boolean)holder.state.equals((Object)State.DIDNT_RUN), (String)"Didn't run. Should timeout.");
            Assertions.assertTrue((boolean)holder.state.equals((Object)State.TIMED_OUT), (String)"Did not timeout.");
            holder.state = State.DIDNT_RUN;
            ThreadTools.executeWithTimeout((String)"timeoutTest2", (Runnable)new Runnable(){

                @Override
                public void run() {
                    holder.state = State.TIMED_OUT;
                    ThreadTools.sleep((long)5L);
                    holder.state = State.RAN_WITHOUT_TIMING_OUT;
                }
            }, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assertions.assertFalse((boolean)holder.state.equals((Object)State.DIDNT_RUN), (String)"Didn't run. Shouldn't timeout.");
            Assertions.assertTrue((boolean)holder.state.equals((Object)State.RAN_WITHOUT_TIMING_OUT), (String)"Timed out early.");
        }
    }

    @Test
    public void testThreadSleepEvenWhenInterrupted() {
        long ONE_MILLION = 1000000L;
        long millisecondsToSleep = 1100L;
        int additionalNanosecondsToSleep = 500000;
        long totalNanosecondsToSleep = millisecondsToSleep * 1000000L + (long)additionalNanosecondsToSleep;
        SleepAndVerifyDespiteWakingUpRunnable runnable = new SleepAndVerifyDespiteWakingUpRunnable(millisecondsToSleep, additionalNanosecondsToSleep);
        int numberOfTimesToTest = 5;
        for (int i = 0; i < numberOfTimesToTest; ++i) {
            Thread thread = new Thread(runnable);
            thread.start();
            while (!runnable.isDoneSleeping()) {
                thread.interrupt();
                try {
                    Thread.sleep(millisecondsToSleep / 10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            long timeSleptInNanoseconds = runnable.getTimeSleptNanonseconds();
            long timeOverSleptInNanoseconds = timeSleptInNanoseconds - totalNanosecondsToSleep;
            Assertions.assertTrue((timeOverSleptInNanoseconds > 0L ? 1 : 0) != 0, (String)("timeSlept = " + timeSleptInNanoseconds + ", totalNanosecondsToSleep = " + totalNanosecondsToSleep + " timeOverSleptInNanoseconds = " + timeOverSleptInNanoseconds));
            Assertions.assertTrue((timeOverSleptInNanoseconds < 100000000L ? 1 : 0) != 0, (String)("timeSlept = " + timeSleptInNanoseconds + ", millisecondsToSleep = " + millisecondsToSleep));
            runnable = new SleepAndVerifyDespiteWakingUpRunnable(millisecondsToSleep, additionalNanosecondsToSleep);
            thread = new Thread(runnable);
            thread.start();
            while (!runnable.isDoneSleeping()) {
                try {
                    Thread.sleep(millisecondsToSleep / 10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Test
    public void testParkInterrupt() {
        final MutableBoolean interruptedBefore = new MutableBoolean(false);
        final MutableBoolean interruptedAfter = new MutableBoolean(false);
        final MutableBoolean interruptedAfterClear = new MutableBoolean(false);
        LogTools.info((String)"Test park interrupted early return");
        Thread thread = new Thread("Test"){

            @Override
            public void run() {
                interruptedBefore.setValue(this.isInterrupted());
                ThreadTools.park((double)1.0);
                interruptedAfter.setValue(3.interrupted());
                interruptedAfterClear.setValue(this.isInterrupted());
            }
        };
        Stopwatch stopwatch = new Stopwatch().start();
        thread.start();
        ThreadTools.park((double)0.25);
        thread.interrupt();
        Assertions.assertDoesNotThrow(() -> thread.join());
        double elapsed = stopwatch.totalElapsed();
        Assertions.assertTrue((elapsed > 0.2 && elapsed < 0.3 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)interruptedBefore.booleanValue());
        Assertions.assertTrue((boolean)interruptedAfter.booleanValue());
        Assertions.assertFalse((boolean)interruptedAfterClear.booleanValue());
        LogTools.info((String)"Test park immediate return if already interrupted");
        Thread thread2 = new Thread("Test2"){

            @Override
            public void run() {
                interruptedBefore.setValue(this.isInterrupted());
                ThreadTools.park((double)1.0);
                ThreadTools.park((double)1.0);
                interruptedAfter.setValue(4.interrupted());
                interruptedAfterClear.setValue(this.isInterrupted());
            }
        };
        thread2.interrupt();
        stopwatch = new Stopwatch().start();
        thread2.start();
        Assertions.assertDoesNotThrow(() -> thread2.join());
        elapsed = stopwatch.totalElapsed();
        Assertions.assertTrue((elapsed < 0.1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)interruptedBefore.booleanValue());
        Assertions.assertTrue((boolean)interruptedAfter.booleanValue());
        Assertions.assertFalse((boolean)interruptedAfterClear.booleanValue());
        LogTools.info((String)"Test parkAtLeast interrupted early return");
        Thread thread3 = new Thread("Test"){

            @Override
            public void run() {
                interruptedBefore.setValue(this.isInterrupted());
                ThreadTools.parkAtLeast((double)1.0);
                interruptedAfter.setValue(5.interrupted());
                interruptedAfterClear.setValue(this.isInterrupted());
            }
        };
        stopwatch = new Stopwatch().start();
        thread3.start();
        ThreadTools.park((double)0.25);
        thread3.interrupt();
        Assertions.assertDoesNotThrow(() -> thread3.join());
        elapsed = stopwatch.totalElapsed();
        Assertions.assertTrue((elapsed > 0.2 && elapsed < 0.3 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)interruptedBefore.booleanValue());
        Assertions.assertTrue((boolean)interruptedAfter.booleanValue());
        Assertions.assertFalse((boolean)interruptedAfterClear.booleanValue());
        LogTools.info((String)"Test parkAtLeast when interrupted");
        Thread thread4 = new Thread("Test2"){

            @Override
            public void run() {
                interruptedBefore.setValue(this.isInterrupted());
                ThreadTools.parkAtLeast((double)1.0);
                ThreadTools.parkAtLeast((double)1.0);
                interruptedAfter.setValue(6.interrupted());
                interruptedAfterClear.setValue(this.isInterrupted());
            }
        };
        thread4.interrupt();
        stopwatch = new Stopwatch().start();
        thread4.start();
        Assertions.assertDoesNotThrow(() -> thread4.join());
        elapsed = stopwatch.totalElapsed();
        Assertions.assertTrue((elapsed < 0.1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)interruptedBefore.booleanValue());
        Assertions.assertTrue((boolean)interruptedAfter.booleanValue());
        Assertions.assertFalse((boolean)interruptedAfterClear.booleanValue());
    }

    @Test
    public void testParkAtLeast() {
        Assertions.assertTrue((boolean)this.conductParkTest(1.0E-13, false));
        Assertions.assertTrue((boolean)this.conductParkTest(5.0E-10, false));
        Assertions.assertTrue((boolean)this.conductParkTest(1.0E-9, false));
        Assertions.assertTrue((boolean)this.conductParkTest(0.1, false));
        Assertions.assertTrue((boolean)this.conductParkTest(1.0E-4, false));
        Assertions.assertTrue((boolean)this.conductParkTest(5.0E-10, false));
        Assertions.assertTrue((boolean)this.conductParkTest(1.1, false));
        Assertions.assertTrue((boolean)this.conductParkTest(2.0, false));
        Assertions.assertTrue((boolean)this.conductParkTest(1.0E-13, true));
        Assertions.assertTrue((boolean)this.conductParkTest(5.0E-10, true));
        Assertions.assertTrue((boolean)this.conductParkTest(1.0E-9, true));
        Assertions.assertTrue((boolean)this.conductParkTest(0.1, true));
        Assertions.assertTrue((boolean)this.conductParkTest(1.0E-4, true));
        Assertions.assertTrue((boolean)this.conductParkTest(5.0E-10, true));
        Assertions.assertTrue((boolean)this.conductParkTest(1.1, true));
        Assertions.assertTrue((boolean)this.conductParkTest(2.0, true));
    }

    private boolean conductParkTest(double sleepDuration, boolean atLeast) {
        double before = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        if (atLeast) {
            ThreadTools.parkAtLeast((double)sleepDuration);
        } else {
            ThreadTools.park((double)sleepDuration);
        }
        double after = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        double overslept = after - before - sleepDuration;
        Assertions.assertTrue((overslept < 0.005 ? 1 : 0) != 0);
        return overslept > 0.0;
    }

    @Test
    public void testCancellableScheduledTasks() {
        ScheduledExecutorService scheduler = ThreadTools.newSingleDaemonThreadScheduledExecutor((String)"Test");
        StringBuilder output = new StringBuilder();
        ScheduledFuture<StringBuilder> scheduledFuture1 = scheduler.schedule(() -> output.append("A"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture1.cancel(false);
        scheduler.schedule(() -> output.append("B"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        ScheduledFuture<StringBuilder> scheduledFuture2 = scheduler.schedule(() -> output.append("C"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture2.cancel(false);
        ThreadTools.sleep((long)600L);
        scheduler.schedule(() -> output.append("D"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        scheduler.schedule(() -> ExceptionTools.handle(() -> {
            output.append("E");
            throw new NullPointerException();
        }, (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        ScheduledFuture<StringBuilder> scheduledFuture3 = scheduler.schedule(() -> output.append("F"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture3.cancel(false);
        ThreadTools.sleep((long)600L);
        String recordedOutput = output.toString();
        Assertions.assertEquals((Object)"BDE", (Object)recordedOutput);
        LogTools.info((String)recordedOutput);
        scheduler.shutdown();
    }

    private class StateHolder {
        public State state = State.DIDNT_RUN;

        private StateHolder() {
        }
    }

    private static enum State {
        DIDNT_RUN,
        TIMED_OUT,
        RAN_WITHOUT_TIMING_OUT;

    }

    private class SleepAndVerifyDespiteWakingUpRunnable
    implements Runnable {
        private long millisecondsToSleep;
        private int additonalNanosecondsToSleep;
        private boolean isDoneSleeping;
        private long timeSleptNanosecondsMeasuredExternally;

        public SleepAndVerifyDespiteWakingUpRunnable(long millisecondsToSleep, int additonalNanosecondsToSleep) {
            this.millisecondsToSleep = millisecondsToSleep;
            this.additonalNanosecondsToSleep = additonalNanosecondsToSleep;
        }

        public boolean isDoneSleeping() {
            return this.isDoneSleeping;
        }

        public long getTimeSleptNanonseconds() {
            return this.timeSleptNanosecondsMeasuredExternally;
        }

        @Override
        public void run() {
            long startTime = System.nanoTime();
            long timeSleptMeasuredFromMethod = ThreadTools.sleep((long)this.millisecondsToSleep, (int)this.additonalNanosecondsToSleep);
            long endTime = System.nanoTime();
            this.timeSleptNanosecondsMeasuredExternally = endTime - startTime;
            if (this.timeSleptNanosecondsMeasuredExternally < timeSleptMeasuredFromMethod) {
                throw new AssertionError((Object)("Huh: timeSleptNanosecondsMeasuredExternally = " + this.timeSleptNanosecondsMeasuredExternally + ", timeSleptMeasuredFromMethod = " + timeSleptMeasuredFromMethod));
            }
            this.isDoneSleeping = true;
        }
    }
}

