/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.commons.thread.RepeatingTaskThread;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.FrequencyCalculator;
import us.ihmc.log.LogTools;

public class RepeatingTaskThreadTest {
    private static final String NAME = "TestRepeatingTaskThread";

    @Test
    public void testStartKill() {
        AtomicBoolean taskRan = new AtomicBoolean(false);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, () -> taskRan.set(true));
        thread.start();
        this.assertState(thread, true, true, 0L, false, 0L);
        thread.kill();
        this.assertState(thread, false, true, 0L, false, 0L);
        Assertions.assertDoesNotThrow(() -> thread.join(1000L));
        this.assertState(thread, false, false, 0L, false, 0L);
        Assertions.assertFalse((boolean)taskRan.get());
    }

    @Test
    public void testStartRepeatKill() {
        AtomicInteger repetitions = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, () -> {
            LogTools.info((String)"Repetition {}", (Object)repetitions.getAndIncrement());
            Thread.sleep(10L);
        });
        int repetitionsToRun = 10;
        thread.setScheduled((long)repetitionsToRun);
        this.assertState(thread, false, false, repetitionsToRun, false, 0L);
        thread.start();
        this.assertState(thread, true, true, repetitionsToRun, false, 0L);
        thread.blockUntilNoScheduledTasks();
        this.assertState(thread, true, true, 0L, false, repetitionsToRun);
        thread.kill();
        this.assertState(thread, false, true, 0L, false, repetitionsToRun);
        Assertions.assertDoesNotThrow(() -> thread.join(1000L));
        this.assertState(thread, false, false, 0L, false, repetitionsToRun);
        Assertions.assertEquals((int)repetitionsToRun, (int)repetitions.get());
    }

    @Test
    public void testStartPauseStart() {
        AtomicInteger repetitions = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, () -> {
            LogTools.info((String)"Repetition {}", (Object)repetitions.getAndIncrement());
            ThreadTools.park((double)0.01);
        });
        thread.startRepeating();
        this.assertState(thread, true, true, -1L, false, 0L);
        thread.blockUntilNextTaskExecution();
        this.assertState(thread, true, true, -1L, true, 0L);
        thread.stopRepeating();
        this.assertState(thread, true, true, 0L, true, 0L);
        thread.blockUntilNextTaskCompletion();
        this.assertState(thread, true, true, 0L, false, 1L);
        thread.startRepeating();
        this.assertState(thread, true, true, -1L, false, 1L);
        ThreadTools.park((double)0.005);
        thread.kill();
        this.assertState(thread, false, true, 0L, true, 1L);
        Assertions.assertDoesNotThrow(() -> thread.join(1000L));
        this.assertState(thread, false, false, 0L, false, 2L);
    }

    @Test
    public void testDoubleStart() {
        AtomicInteger repetitions = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, () -> {
            LogTools.info((String)"Repetition {}", (Object)repetitions.getAndIncrement());
            ThreadTools.park((double)0.01);
        });
        thread.startRepeating();
        this.assertState(thread, true, true, -1L, false, 0L);
        thread.startRepeating();
        this.assertState(thread, true, true, -1L, false, 0L);
        ThreadTools.park((double)0.005);
        thread.kill();
        Assertions.assertDoesNotThrow(() -> thread.join(1000L));
        this.assertState(thread, false, false, 0L, false, 1L);
    }

    @Test
    public void testKillWithoutStart() {
        AtomicInteger repetitions = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, () -> {
            LogTools.info((String)"Repetition {}", (Object)repetitions.getAndIncrement());
            Thread.sleep(10L);
        });
        this.assertState(thread, false, false, 0L, false, 0L);
        thread.blockingKill();
        this.assertState(thread, false, false, 0L, false, 0L);
        thread.blockingKill();
        this.assertState(thread, false, false, 0L, false, 0L);
    }

    @Test
    public void testInvalidStarts() {
        AtomicInteger repetitions = new AtomicInteger(0);
        RunnableThatThrows runnable = () -> {
            LogTools.info((String)"Repetition {}", (Object)repetitions.getAndIncrement());
            Thread.sleep(10L);
        };
        RepeatingTaskThread thread1 = new RepeatingTaskThread(NAME, runnable);
        thread1.startRepeating();
        Assertions.assertThrows(IllegalThreadStateException.class, () -> ((RepeatingTaskThread)thread1).start());
        thread1.kill();
        RepeatingTaskThread thread2 = new RepeatingTaskThread(NAME, runnable);
        thread2.startRepeating();
        thread2.blockingKill();
        Assertions.assertThrows(IllegalThreadStateException.class, () -> ((RepeatingTaskThread)thread2).startRepeating());
    }

    @Test
    public void testAddScheduledRepetitions() {
        AtomicInteger repetitions = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, repetitions::getAndIncrement);
        int add = 20;
        int subtract = -10;
        int increment = 1;
        int total = add + subtract + increment;
        thread.addScheduled((long)add);
        thread.addScheduled((long)subtract);
        thread.start();
        thread.addScheduled((long)increment);
        thread.blockUntilNoScheduledTasks();
        thread.kill();
        Assertions.assertEquals((int)total, (int)repetitions.get());
        Assertions.assertEquals((long)total, (long)thread.getCompleted());
    }

    @Test
    public void testLoopFrequencyLimit() {
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator();
        double targetFrequency = 5.0;
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME, () -> ((FrequencyCalculator)frequencyCalculator).ping()).setFrequencyLimit(targetFrequency);
        thread.startRepeating();
        ThreadTools.sleep((long)750L);
        Assertions.assertEquals((double)targetFrequency, (double)frequencyCalculator.getFrequency(), (double)0.2);
        targetFrequency = 30.0;
        thread.setFrequencyLimit(targetFrequency);
        ThreadTools.sleep((long)750L);
        Assertions.assertEquals((double)targetFrequency, (double)frequencyCalculator.getFrequency(), (double)0.2);
        thread.removeFrequencyLimit();
        ThreadTools.sleep((long)750L);
        Assertions.assertTrue((frequencyCalculator.getFrequency() > targetFrequency + 10.0 ? 1 : 0) != 0);
        thread.blockingKill();
    }

    @Test
    public void testInterrupt() {
        int i;
        final AtomicInteger interruptCount = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME){

            protected void runTask() {
                ThreadTools.park((double)0.01);
                if (1.interrupted()) {
                    interruptCount.incrementAndGet();
                }
            }
        };
        LogTools.info((String)"Test during free spin");
        thread.startRepeating();
        for (i = 0; i < 25; ++i) {
            thread.blockUntilNextTaskExecution();
            thread.interrupt();
            thread.blockUntilNextTaskCompletion();
            Assertions.assertEquals((int)(i + 1), (int)interruptCount.get());
        }
        LogTools.info((String)"Test during throttled looping");
        interruptCount.set(0);
        thread.setFrequencyLimit(200.0);
        for (i = 0; i < 25; ++i) {
            thread.blockUntilNextTaskExecution();
            thread.interrupt();
            thread.blockUntilNextTaskCompletion();
            Assertions.assertEquals((int)(i + 1), (int)interruptCount.get());
        }
        thread.stopRepeating();
        LogTools.info((String)"Test one by one");
        interruptCount.set(0);
        for (i = 0; i < 25; ++i) {
            thread.addScheduled(1L);
            thread.blockUntilNextTaskExecution();
            thread.interrupt();
            thread.blockUntilNextTaskCompletion();
            Assertions.assertEquals((int)(i + 1), (int)interruptCount.get());
        }
        LogTools.info((String)"Completed test");
        thread.blockingKill();
    }

    @Test
    public void testImmediateShutdown() {
        double shutdownDuration;
        long shutdownComplete;
        long shutdownStart;
        RepeatingTaskThread thread;
        int millisToSleep;
        RunnableThatThrows wasteTime = () -> {
            try {
                Thread.sleep((long)Conversions.secondsToMilliseconds((double)0.5));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        LogTools.info((String)"Test during free spin");
        for (millisToSleep = 0; millisToSleep < 500; millisToSleep += 100) {
            thread = new RepeatingTaskThread(NAME, wasteTime);
            thread.startRepeating();
            ThreadTools.sleep((long)millisToSleep);
            shutdownStart = System.nanoTime();
            thread.kill();
            thread.interrupt();
            Assertions.assertDoesNotThrow(() -> thread.join(500L));
            shutdownComplete = System.nanoTime();
            shutdownDuration = Conversions.nanosecondsToSeconds((long)(shutdownComplete - shutdownStart));
            LogTools.info((String)"Shutdown Duration: {}", (Object)shutdownDuration);
            Assertions.assertTrue((shutdownDuration < 0.01 ? 1 : 0) != 0);
        }
        LogTools.info((String)"Test during throttled looping");
        for (millisToSleep = 0; millisToSleep < 500; millisToSleep += 100) {
            thread = new RepeatingTaskThread(NAME, wasteTime).setFrequencyLimit(1.0);
            thread.startRepeating();
            ThreadTools.sleep((long)millisToSleep);
            shutdownStart = System.nanoTime();
            thread.kill();
            thread.interrupt();
            Assertions.assertDoesNotThrow(() -> thread.join(500L));
            shutdownComplete = System.nanoTime();
            shutdownDuration = Conversions.nanosecondsToSeconds((long)(shutdownComplete - shutdownStart));
            LogTools.info((String)"Shutdown Duration: {}", (Object)shutdownDuration);
            Assertions.assertTrue((shutdownDuration < 0.01 ? 1 : 0) != 0);
        }
        LogTools.info((String)"Test during pause");
        for (millisToSleep = 0; millisToSleep < 500; millisToSleep += 100) {
            thread = new RepeatingTaskThread(NAME, wasteTime);
            thread.start();
            ThreadTools.sleep((long)millisToSleep);
            shutdownStart = System.nanoTime();
            thread.kill();
            Assertions.assertDoesNotThrow(() -> thread.join(500L));
            shutdownComplete = System.nanoTime();
            shutdownDuration = Conversions.nanosecondsToSeconds((long)(shutdownComplete - shutdownStart));
            LogTools.info((String)"Shutdown Duration: {}", (Object)shutdownDuration);
            Assertions.assertTrue((shutdownDuration < 0.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testImmediateShutdownRace() {
        RunnableThatThrows wasteTime = () -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        for (int i = 0; i < 5000; ++i) {
            RepeatingTaskThread thread = new RepeatingTaskThread(NAME, wasteTime);
            thread.startRepeating();
            LockSupport.parkNanos(5L);
            long shutdownStart = System.nanoTime();
            thread.kill();
            thread.interrupt();
            Assertions.assertDoesNotThrow(() -> thread.join(500L));
            long shutdownComplete = System.nanoTime();
            double shutdownDuration = Conversions.nanosecondsToSeconds((long)(shutdownComplete - shutdownStart));
            LogTools.info((String)"Shutdown Duration: {}", (Object)shutdownDuration);
            Assertions.assertTrue((shutdownDuration < 0.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOverride() {
        final AtomicInteger loopCounter = new AtomicInteger(0);
        RepeatingTaskThread thread = new RepeatingTaskThread(NAME){

            protected void runTask() {
                loopCounter.set(loopCounter.get() + 1);
            }
        };
        int targetLoops = 15;
        thread.setScheduled((long)targetLoops);
        thread.start();
        thread.blockUntilNoScheduledTasks();
        thread.blockingKill();
        Assertions.assertEquals((int)targetLoops, (int)loopCounter.get());
    }

    private void assertState(RepeatingTaskThread thread, boolean running, boolean isAlive, long scheduled, boolean isExecuting, long completed) {
        Assertions.assertEquals((Object)running, (Object)thread.isRunning());
        Assertions.assertEquals((Object)isAlive, (Object)thread.isAlive());
        Assertions.assertEquals((long)scheduled, (long)thread.getScheduled());
        Assertions.assertEquals((Object)isExecuting, (Object)thread.isExecuting());
        Assertions.assertEquals((long)completed, (long)thread.getCompleted());
    }
}

