/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.nio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;

@Execution(value=ExecutionMode.SAME_THREAD)
public class FileToolsTest {
    private static final Path FILE_TOOLS_TEST_PATH = FileToolsTest.getResourcesPathForTestClass(FileToolsTest.class);
    private static final Path TEXT_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleTextFiles");
    private static final Path JAVA_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleJavaFiles");
    private static final Path EMPTY_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleEmptyFiles");
    private static final Path TEMP_DIRECTORY_PATH = FILE_TOOLS_TEST_PATH.resolve("exampleTempFiles");
    private static final String EXAMPLE_FILE_1_TEXT_LINE_1 = "This is example File 1 !!&&#))(";
    private static final String EXAMPLE_FILE_2_TEXT_LINE_1 = "This is example File 2 *@&&%*@";
    private static final String EXAMPLE_FILE_2_TEXT_LINE_2 = "It has two lines";
    private static final String EXAMPLE_JAVA_FILE1_JAVA = "ExampleJavaFile1.java.txt";
    private static final String EXAMPLE_JAVA_FILE2_JAVA = "ExampleJavaFile2.java.txt";
    private static final String FILE_TOOLS_EXAMPLE_FILE_CAT_TXT = "FileToolsExampleFileCat.txt";
    private static final String FILE_TOOLS_EXAMPLE_FILE1_TXT = "FileToolsExampleFile1.txt";
    private static final String FILE_TOOLS_EXAMPLE_FILE2_TXT = "FileToolsExampleFile2.txt";
    private static final String TEST_READ_ALL_LINES_TXT = "testReadAllLines.txt";
    private static final Path EXAMPLE_JAVA_FILE1_PATH = JAVA_DIRECTORY_PATH.resolve("ExampleJavaFile1.java.txt");
    private static final Path EXAMPLE_JAVA_FILE2_PATH = JAVA_DIRECTORY_PATH.resolve("ExampleJavaFile2.java.txt");
    private static final Path FILE_TOOLS_EXAMPLE_FILE1_PATH = TEXT_DIRECTORY_PATH.resolve("FileToolsExampleFile1.txt");
    private static final Path FILE_TOOLS_EXAMPLE_FILE2_PATH = TEXT_DIRECTORY_PATH.resolve("FileToolsExampleFile2.txt");
    private static final Path FILE_TOOLS_EXAMPLE_FILE_CAT_TXT_PATH = TEXT_DIRECTORY_PATH.resolve("FileToolsExampleFileCat.txt");
    private static final Path READ_ALL_LINES_PATH = FILE_TOOLS_TEST_PATH.resolve("testReadAllLines.txt");

    @BeforeEach
    public void setUp() {
        FileTools.ensureDirectoryExists((Path)FILE_TOOLS_TEST_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileTools.ensureDirectoryExists((Path)TEXT_DIRECTORY_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileTools.ensureDirectoryExists((Path)JAVA_DIRECTORY_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileTools.ensureDirectoryExists((Path)EMPTY_DIRECTORY_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        FileToolsTest.createJavaFile1();
        FileToolsTest.createJavaFile2();
        FileToolsTest.createTestFile1();
        FileToolsTest.createTestFile2();
        FileToolsTest.createReadAllLinesFile();
    }

    @AfterEach
    public void tearDown() {
        FileTools.deleteQuietly((Path)EXAMPLE_JAVA_FILE1_PATH);
        FileTools.deleteQuietly((Path)EXAMPLE_JAVA_FILE2_PATH);
        FileTools.deleteQuietly((Path)FILE_TOOLS_EXAMPLE_FILE1_PATH);
        FileTools.deleteQuietly((Path)FILE_TOOLS_EXAMPLE_FILE2_PATH);
        FileTools.deleteQuietly((Path)FILE_TOOLS_EXAMPLE_FILE_CAT_TXT_PATH);
        FileTools.deleteQuietly((Path)READ_ALL_LINES_PATH);
    }

    private static Path getResourcesPathForTestClass(Class<?> clazz) {
        ArrayList<String> pathNames = new ArrayList<String>();
        String[] packageNames = clazz.getPackage().getName().split("\\.");
        pathNames.addAll(Arrays.asList(packageNames));
        pathNames.add(StringUtils.uncapitalize((String)clazz.getSimpleName()));
        return Paths.get("resources", pathNames.toArray(new String[0]));
    }

    @Test
    public void testReadAllLines() {
        List lines = FileTools.readAllLines((Path)READ_ALL_LINES_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        Assertions.assertTrue((boolean)((String)lines.get(0)).equals("line1"));
        Assertions.assertTrue((boolean)((String)lines.get(1)).equals("line2"));
        Assertions.assertTrue((boolean)((String)lines.get(2)).equals("line3"));
    }

    @Test
    public void testReadAllBytesAndReadLinesFromBytesAndReplaceLine() {
        byte[] bytes = FileTools.readAllBytes((Path)READ_ALL_LINES_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        List lines = FileTools.readLinesFromBytes((byte[])bytes, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        Assertions.assertTrue((boolean)((String)lines.get(0)).equals("line1"));
        Assertions.assertTrue((boolean)((String)lines.get(1)).equals("line2"));
        Assertions.assertTrue((boolean)((String)lines.get(2)).equals("line3"));
        bytes = FileTools.replaceLineInFile((int)1, (String)"line2Mod", (byte[])bytes, (List)lines);
        lines = FileTools.readLinesFromBytes((byte[])bytes, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        Assertions.assertTrue((boolean)((String)lines.get(0)).equals("line1"));
        Assertions.assertTrue((boolean)((String)lines.get(1)).equals("line2Mod"));
        Assertions.assertTrue((boolean)((String)lines.get(2)).equals("line3"));
    }

    @Test
    public void testConcatenateFilesTogether() {
        Path concatFile1 = FILE_TOOLS_EXAMPLE_FILE1_PATH;
        Path concatFile2 = FILE_TOOLS_EXAMPLE_FILE2_PATH;
        Path concatedFile = TEXT_DIRECTORY_PATH.resolve(FILE_TOOLS_EXAMPLE_FILE_CAT_TXT);
        ArrayList<Path> filesToConcat = new ArrayList<Path>();
        filesToConcat.add(concatFile1);
        filesToConcat.add(concatFile2);
        FileTools.concatenateFiles(filesToConcat, (Path)concatedFile, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        try {
            BufferedReader reader = Files.newBufferedReader(concatedFile);
            Assertions.assertEquals((Object)EXAMPLE_FILE_1_TEXT_LINE_1, (Object)reader.readLine());
            Assertions.assertEquals((Object)EXAMPLE_FILE_2_TEXT_LINE_1, (Object)reader.readLine());
            Assertions.assertEquals((Object)EXAMPLE_FILE_2_TEXT_LINE_2, (Object)reader.readLine());
            Assertions.assertNull((Object)reader.readLine());
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail();
        }
    }

    @Test
    public void testEnsureFileExists() {
        Assertions.assertThrows(DirectoryNotEmptyException.class, () -> FileTools.ensureFileExists((Path)JAVA_DIRECTORY_PATH));
        Assertions.assertTrue((boolean)Files.isDirectory(JAVA_DIRECTORY_PATH, new LinkOption[0]));
        Assertions.assertDoesNotThrow(() -> FileTools.ensureDirectoryExists((Path)TEMP_DIRECTORY_PATH));
        Assertions.assertTrue((boolean)Files.isDirectory(TEMP_DIRECTORY_PATH, new LinkOption[0]));
        Assertions.assertDoesNotThrow(() -> FileTools.ensureFileExists((Path)TEMP_DIRECTORY_PATH));
        Assertions.assertTrue((boolean)Files.exists(TEMP_DIRECTORY_PATH, new LinkOption[0]));
        Assertions.assertDoesNotThrow(() -> FileTools.ensureDirectoryExists((Path)TEMP_DIRECTORY_PATH));
        Assertions.assertTrue((boolean)Files.isDirectory(TEMP_DIRECTORY_PATH, new LinkOption[0]));
        FileTools.deleteQuietly((Path)TEMP_DIRECTORY_PATH);
        Assertions.assertFalse((boolean)Files.exists(TEMP_DIRECTORY_PATH, new LinkOption[0]));
        Assertions.assertDoesNotThrow(() -> FileTools.ensureFileExists((Path)TEMP_DIRECTORY_PATH));
        Assertions.assertTrue((boolean)Files.exists(TEMP_DIRECTORY_PATH, new LinkOption[0]));
    }

    private static void createTestFile1() {
        PrintWriter writer = FileTools.newPrintWriter((Path)FILE_TOOLS_EXAMPLE_FILE1_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println(EXAMPLE_FILE_1_TEXT_LINE_1);
        writer.flush();
        writer.close();
    }

    private static void createTestFile2() {
        PrintWriter writer = FileTools.newPrintWriter((Path)FILE_TOOLS_EXAMPLE_FILE2_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println(EXAMPLE_FILE_2_TEXT_LINE_1);
        writer.println(EXAMPLE_FILE_2_TEXT_LINE_2);
        writer.flush();
        writer.close();
    }

    private static void createJavaFile1() {
        PrintWriter writer = FileTools.newPrintWriter((Path)EXAMPLE_JAVA_FILE1_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println("// This is a comment");
        writer.println("package us.ihmc.tools.io.files.fileToolsTest.exampleJavaFiles;");
        writer.println("public class ExampleJavaFile1");
        writer.println("{");
        writer.println("public static void main(String[] args)");
        writer.println("{");
        writer.println("System.out.println(\"Hello, World!\");");
        writer.println("}");
        writer.println("}");
        writer.println("// So is this");
        writer.flush();
        writer.close();
    }

    private static void createJavaFile2() {
        PrintWriter writer = FileTools.newPrintWriter((Path)EXAMPLE_JAVA_FILE2_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.println("package us.ihmc.tools.io.files.fileToolsTest.exampleJavaFiles;");
        writer.println("public class ExampleJavaFile2");
        writer.println("{");
        writer.println("public static void main(String[] args)");
        writer.println("{");
        writer.println("System.out.println(\"Hello, World!\");");
        writer.println("}");
        writer.println("}");
        writer.flush();
        writer.close();
    }

    private static void createReadAllLinesFile() {
        PrintWriter writer = FileTools.newPrintWriter((Path)READ_ALL_LINES_PATH, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        writer.print("line1\r\nline2\nline3\r");
        writer.close();
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(FileTools.class, FileToolsTest.class);
    }
}

