/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.RunnableThatThrows;

public class MathToolsTest {
    private Random random;

    @BeforeEach
    public void setUp() throws Exception {
        this.random = new Random(100L);
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testConstructor() throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)MathTools.class.getDeclaredConstructors().length);
        Constructor constructor = MathTools.class.getDeclaredConstructor(new Class[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Modifier.isPrivate(constructor.getModifiers()));
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
    }

    @Test
    public void testClampWrongBounds() {
        Assertions.assertExceptionThrown(RuntimeException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                double min = 1.0;
                double max = 0.9;
                MathTools.clamp((double)5.0, (double)min, (double)max);
            }
        });
        Assertions.assertExceptionThrown(RuntimeException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                float min = 1.0f;
                float max = 0.9f;
                MathTools.clamp((double)5.0, (double)min, (double)max);
            }
        });
        Assertions.assertExceptionThrown(RuntimeException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                boolean min = true;
                int max = -1;
                MathTools.clamp((double)5.0, (double)((double)min), (double)max);
            }
        });
    }

    @Test
    public void testClamp2() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double max = rand.nextDouble() * 1000.0;
            double clippedVal = MathTools.clamp((double)(max * 2.0), (double)max);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedVal, (double)max, (double)1.0E-7);
            max = rand.nextDouble() * 1000.0;
            clippedVal = MathTools.clamp((double)(max * -2.0), (double)max);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedVal, (double)(-max), (double)1.0E-7);
            max = rand.nextDouble() * 1000.0;
            clippedVal = MathTools.clamp((double)((float)(max * 2.0)), (double)((float)max));
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedVal, (double)max, (double)1.0E-4);
            max = rand.nextDouble() * 1000.0;
            clippedVal = MathTools.clamp((double)((float)(max * -2.0)), (double)((float)max));
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedVal, (double)(-max), (double)1.0E-4);
            int maxInt = rand.nextInt(1000);
            int clippedInt = MathTools.clamp((int)(maxInt * -2), (int)maxInt);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedInt, (double)(-maxInt), (double)1.0E-4);
            maxInt = rand.nextInt(1000);
            clippedInt = MathTools.clamp((int)(maxInt * 2), (int)maxInt);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedInt, (double)maxInt, (double)1.0E-4);
            maxInt = rand.nextInt(1000);
            clippedInt = MathTools.clamp((int)maxInt, (int)maxInt);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedInt, (double)maxInt, (double)1.0E-4);
            maxInt = rand.nextInt(1000);
            clippedInt = MathTools.clamp((int)(-maxInt), (int)maxInt);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedInt, (double)(-maxInt), (double)1.0E-4);
            maxInt = rand.nextInt(1000);
            clippedInt = MathTools.clamp((int)(-maxInt / 2), (int)maxInt);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedInt, (double)(-maxInt / 2), (double)1.0E-4);
            maxInt = rand.nextInt(1000);
            clippedInt = MathTools.clamp((int)(maxInt / 2), (int)maxInt);
            org.junit.jupiter.api.Assertions.assertEquals((double)clippedInt, (double)(maxInt / 2), (double)1.0E-4);
        }
    }

    @Test
    public void testClampNaN() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(MathTools.clamp((double)Double.NaN, (double)0.0, (double)1.0)));
    }

    @Test
    public void testCheckIfInRange() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)5.0, (double)0.0, (double)6.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)6.0, (double)0.0, (double)6.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)0.0, (double)0.0, (double)6.0));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)7.0, (double)0.0, (double)6.0));
    }

    @Test
    public void testCheckIfInRange_2() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> MathTools.checkIntervalContains((long)-5L, (long)-1L, (long)1L));
    }

    @Test
    public void testClamp() {
        for (int i = 0; i < 10; ++i) {
            boolean withinBounds;
            boolean tooBig;
            double min = this.random.nextDouble();
            double max = min + this.random.nextDouble();
            double val = 3.0 * (this.random.nextDouble() - 0.25);
            double result = MathTools.clamp((double)val, (double)min, (double)max);
            boolean tooSmall = result < min;
            boolean bl = tooBig = result > max;
            if (tooSmall || tooBig) {
                org.junit.jupiter.api.Assertions.fail();
            }
            boolean bl2 = withinBounds = val > min && val < max;
            if (!withinBounds) continue;
            org.junit.jupiter.api.Assertions.assertEquals((double)val, (double)result, (double)1.0E-10);
        }
    }

    @Test
    public void testClampLong() {
        long limit = 1000000L;
        for (int i = 0; i < 10; ++i) {
            boolean withinBounds;
            boolean tooBig;
            long min = Math.abs(this.random.nextLong() % 1000000L);
            long max = min + Math.abs(this.random.nextLong() % 1000000L);
            long val = this.random.nextLong() % 3000000L;
            long result = MathTools.clamp((long)val, (long)min, (long)max);
            boolean tooSmall = result < min;
            boolean bl = tooBig = result > max;
            if (tooSmall || tooBig) {
                org.junit.jupiter.api.Assertions.fail();
            }
            boolean bl2 = withinBounds = val > min && val < max;
            if (!withinBounds) continue;
            org.junit.jupiter.api.Assertions.assertEquals((double)val, (double)result, (double)1.0E-10);
        }
    }

    @Test
    public void squareTest() {
        double[] randomValues;
        for (double randomValue : randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)25, (double)10.0)) {
            org.junit.jupiter.api.Assertions.assertEquals((double)MathTools.square((double)randomValue), (double)Math.pow(randomValue, 2.0), (double)1.0E-12);
        }
    }

    @Test
    public void cubeTest() {
        double[] randomValues;
        for (double randomValue : randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)25, (double)10.0)) {
            org.junit.jupiter.api.Assertions.assertEquals((double)MathTools.cube((double)randomValue), (double)Math.pow(randomValue, 3.0), (double)1.0E-12);
        }
    }

    @Test
    public void powWithIntegerTest() {
        int numberOfTrials = 10000;
        double[] randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)numberOfTrials, (double)0.1, (double)10.0);
        int[] randomExponents = RandomNumbers.nextIntArray((Random)this.random, (int)numberOfTrials, (int)10);
        for (int i = 0; i < numberOfTrials; ++i) {
            double x = randomValues[i];
            int exp = randomExponents[i];
            double xPowedToTest = MathTools.pow((double)x, (int)exp);
            double xPowedExpected = Math.pow(x, exp);
            double errorRatio = (xPowedToTest - xPowedExpected) / xPowedExpected;
            boolean isRelativeErrorLowEnough = MathTools.epsilonEquals((double)errorRatio, (double)0.0, (double)1.0E-15);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)isRelativeErrorLowEnough);
        }
    }

    @Test
    public void signTest() {
        double[] randomValues;
        for (double randomValue : randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)25, (double)10.0)) {
            if (randomValue == 0.0) continue;
            org.junit.jupiter.api.Assertions.assertEquals((double)Math.signum(randomValue), (double)MathTools.sign((double)randomValue), (double)1.0E-12);
        }
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)MathTools.sign((double)0.0), (double)1.0E-12);
    }

    @Test
    public void sumDoublesTest() {
        double[] posVals = new double[25];
        double[] negVals = new double[25];
        ArrayList<Double> posValsList = new ArrayList<Double>();
        ArrayList<Double> negValsList = new ArrayList<Double>();
        for (int i = 0; i < 25; ++i) {
            posVals[i] = 1.5;
            negVals[i] = -1.5;
            posValsList.add(1.5);
            negValsList.add(-1.5);
        }
        org.junit.jupiter.api.Assertions.assertEquals((double)MathTools.sum((double[])posVals), (double)37.5, (double)1.0E-12);
        org.junit.jupiter.api.Assertions.assertEquals((double)MathTools.sum((double[])negVals), (double)-37.5, (double)1.0E-12);
    }

    @Test
    public void sumIntegerTest() {
        int[] posVals = new int[25];
        int[] negVals = new int[25];
        ArrayList<Integer> posValsList = new ArrayList<Integer>();
        ArrayList<Integer> negValsList = new ArrayList<Integer>();
        for (int i = 0; i < 25; ++i) {
            posVals[i] = 1;
            negVals[i] = -1;
            posValsList.add(1);
            negValsList.add(-1);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)MathTools.sum((int[])posVals), (int)25);
        org.junit.jupiter.api.Assertions.assertEquals((int)MathTools.sum((int[])negVals), (int)-25);
    }

    @Test
    public void dotPlusTest() {
        double[] randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)25, (double)10.0);
        int[] randomInts = RandomNumbers.nextIntArray((Random)this.random, (int)25, (int)10);
        double sumOfRandomValues = MathTools.sum((double[])randomValues);
        long sumOfInts = MathTools.sum((int[])randomInts);
        randomValues = MathTools.dotPlus((double[])randomValues, (double)7.3);
        org.junit.jupiter.api.Assertions.assertEquals((double)(sumOfRandomValues + 182.5), (double)MathTools.sum((double[])randomValues), (double)1.0E-12);
        randomInts = MathTools.dotPlus((int[])randomInts, (int)7);
        org.junit.jupiter.api.Assertions.assertEquals((long)(sumOfInts + 175L), (long)MathTools.sum((int[])randomInts));
    }

    @Test
    public void testIsInsideBounds() {
        double[] randomValues;
        for (double randomValue : randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)25, (double)12.5)) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)randomValue, (double)-12.5, (double)12.5, (boolean)false, (boolean)false));
            randomValue = randomValue < 0.0 ? (randomValue -= 12.6) : (randomValue += 12.6);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)randomValue, (double)-12.5, (double)12.5, (boolean)false, (boolean)false));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)Double.NaN, (double)-10.0, (double)10.0, (boolean)false, (boolean)false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)10.0, (double)-10.0, (double)10.0, (boolean)false, (boolean)false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)-10.0, (double)-10.0, (double)10.0, (boolean)false, (boolean)false));
    }

    @Test
    public void testIsInsideBoundsWrongBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            double min = 1.0;
            double max = 0.9;
            MathTools.intervalContains((double)5.0, (double)min, (double)max, (boolean)false, (boolean)false);
        });
    }

    @Test
    public void testIsInsideBoundsInclusive() {
        double[] randomValues;
        for (double randomValue : randomValues = RandomNumbers.nextDoubleArray((Random)this.random, (int)25, (double)12.5)) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)randomValue, (double)-12.5, (double)12.5));
            randomValue = randomValue < 0.0 ? (randomValue -= 12.6) : (randomValue += 12.6);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)randomValue, (double)-12.5, (double)12.5));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)Double.NaN, (double)-10.0, (double)10.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)10.0, (double)-10.0, (double)10.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)-10.0, (double)-10.0, (double)10.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)5.0, (double)5.0, (double)5.0));
    }

    @Test
    public void testIsInsideBoundsWrongBoundsInclusive() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            double min = 1.0;
            double max = 0.9;
            MathTools.intervalContains((double)5.0, (double)min, (double)max);
        });
    }

    @Test
    public void testIsBoundedByMethods() {
        Assertions.assertExceptionThrown(RuntimeException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                MathTools.intervalContains((double)0.0, (double)1.0, (double)-1.0, (boolean)false, (boolean)false);
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)0.0, (double)-1.0, (double)1.0, (boolean)false, (boolean)false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)-1.0, (double)-1.0, (double)1.0, (boolean)false, (boolean)false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)1.0, (double)-1.0, (double)1.0, (boolean)false, (boolean)false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)-1.0, (double)-1.0, (double)1.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)1.0, (double)-1.0, (double)1.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.intervalContains((double)1.0, (double)-1.0, (double)1.0, (double)1.0E-12));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.intervalContains((double)1.0, (double)-1.0, (double)1.0, (double)1.0E-12, (boolean)false, (boolean)false));
    }

    @Test
    public void testMin() {
        double[] numbers = new double[]{-1.0, -4.0, 4.0, 3.0, 0.0, 1.0, -2.0, -5.0, -3.0, 2.0, 2.0, 3.0, 5.0, 5.0};
        org.junit.jupiter.api.Assertions.assertEquals((double)MathTools.min((double[])numbers), (double)-5.0, (double)1.0E-34);
        numbers[4] = Double.POSITIVE_INFINITY;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Double.isInfinite(MathTools.min((double[])numbers)));
        numbers[4] = Double.NEGATIVE_INFINITY;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isInfinite(MathTools.min((double[])numbers)));
        numbers[4] = Double.NaN;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(MathTools.min((double[])numbers)));
    }

    @Test
    public void testMax() {
        double[] numbers = new double[]{-1.0, -4.0, 4.0, 3.0, 0.0, 1.0, -2.0, -5.0, -3.0, 2.0, 2.0, 3.0, 5.0, 5.0};
        org.junit.jupiter.api.Assertions.assertEquals((double)MathTools.max((double[])numbers), (double)5.0, (double)1.0E-34);
        numbers[4] = Double.POSITIVE_INFINITY;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isInfinite(MathTools.max((double[])numbers)));
        numbers[4] = Double.NEGATIVE_INFINITY;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Double.isInfinite(MathTools.max((double[])numbers)));
        numbers[4] = Double.NaN;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(MathTools.max((double[])numbers)));
    }

    @Test
    public void testMeanArray() {
        double[] numbers = new double[]{-1.0, -4.0, 4.0, 3.0, 0.0, 1.0, -2.0, -5.0, -3.0, 2.0, 2.0, 3.0, 5.0, 5.0};
        org.junit.jupiter.api.Assertions.assertEquals((double)0.7143, (double)MathTools.average((double[])numbers), (double)1.0E-4);
        org.junit.jupiter.api.Assertions.assertEquals((double)5.0, (double)MathTools.average((double[])new double[]{5.0}), (double)1.0E-34);
        numbers[4] = Double.POSITIVE_INFINITY;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isInfinite(MathTools.average((double[])numbers)));
        numbers[4] = Double.NEGATIVE_INFINITY;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isInfinite(MathTools.average((double[])numbers)));
        numbers[4] = Double.NaN;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(MathTools.average((double[])numbers)));
    }

    @Test
    public void testMeanArrayList() {
        Double[] numbersArray = new Double[]{-1.0, -4.0, 4.0, 3.0, 0.0, 1.0, -2.0, -5.0, -3.0, 2.0, 2.0, 3.0, 5.0, 5.0};
        ArrayList<Double> numbers = new ArrayList<Double>(Arrays.asList(numbersArray));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.7143, (double)MathTools.average(numbers), (double)1.0E-4);
        org.junit.jupiter.api.Assertions.assertEquals((double)5.0, (double)MathTools.average((double[])new double[]{5.0}), (double)1.0E-34);
        numbers.set(4, Double.POSITIVE_INFINITY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isInfinite(MathTools.average(numbers)));
        numbers.set(4, Double.NEGATIVE_INFINITY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isInfinite(MathTools.average(numbers)));
        numbers.set(4, Double.NaN);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(MathTools.average(numbers)));
    }

    @Test
    public void testCheckIfInRangeFalse() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> MathTools.checkIntervalContains((double)5.0, (double)-3.0, (double)2.0));
    }

    @Test
    public void testCheckIfInRangeTrue() {
        MathTools.checkIntervalContains((double)1.0, (double)-3.0, (double)2.0);
        MathTools.checkIntervalContains((double)5.0, (double)5.0, (double)5.0);
    }

    @Test
    public void testDiff() {
        double[] array = new double[]{45.0, -11.0, 7.0};
        double[] expectedReturn = new double[]{-56.0, 18.0};
        double[] actualReturn = MathTools.diff((double[])array);
        org.junit.jupiter.api.Assertions.assertEquals((double)expectedReturn[0], (double)actualReturn[0], (double)1.0E-12);
        org.junit.jupiter.api.Assertions.assertEquals((double)expectedReturn[1], (double)actualReturn[1], (double)1.0E-12);
        double[] array2 = new double[]{-20.0, 1.0, -2.9};
        double[] expectedReturn2 = new double[]{21.0, -3.9};
        double[] actualReturn2 = MathTools.diff((double[])array2);
        org.junit.jupiter.api.Assertions.assertEquals((double)expectedReturn2[0], (double)actualReturn2[0], (double)1.0E-12);
        org.junit.jupiter.api.Assertions.assertEquals((double)expectedReturn2[1], (double)actualReturn2[1], (double)1.0E-12);
    }

    @Test
    public void testEpsilonEquals() {
        double v1 = 2.0;
        double v2 = 1.0;
        double epsilon = 3.0;
        boolean expectedReturn = true;
        boolean actualReturn = MathTools.epsilonEquals((double)v1, (double)v2, (double)epsilon);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn);
        v1 = Double.NaN;
        v2 = Double.NaN;
        epsilon = 3.0;
        expectedReturn = false;
        actualReturn = MathTools.epsilonEquals((double)v1, (double)v2, (double)epsilon);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"Not equals");
        double v3 = 1.0;
        double v4 = 0.0;
        double epsi = 0.0;
        boolean expectedReturn2 = false;
        boolean actualReturn2 = MathTools.epsilonEquals((double)v3, (double)v4, (double)epsi);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn2, (Object)actualReturn2);
    }

    @Test
    public void testEpsilonCompare() {
        double v1 = 2.0;
        double v2 = 1.0;
        double epsilon = 3.0;
        boolean expectedReturn = true;
        boolean actualReturn = MathTools.epsilonCompare((double)v1, (double)v2, (double)epsilon);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn);
        v1 = Double.NaN;
        v2 = Double.NaN;
        epsilon = 3.0;
        expectedReturn = true;
        actualReturn = MathTools.epsilonCompare((double)v1, (double)v2, (double)epsilon);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"Not equals");
        double v3 = 1.0;
        double v4 = 0.0;
        double epsi = 0.0;
        boolean expectedReturn2 = false;
        boolean actualReturn2 = MathTools.epsilonCompare((double)v3, (double)v4, (double)epsi);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn2, (Object)actualReturn2);
    }

    @Test
    public void testPercentEquals() {
        double v1 = 1.0;
        double v2 = 1.099;
        double percent = 0.1;
        boolean expectedReturn = true;
        boolean actualReturn = MathTools.percentEquals((double)v1, (double)v2, (double)percent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn);
        v1 = 1.0;
        v2 = -1.0;
        percent = 0.01;
        expectedReturn = false;
        actualReturn = MathTools.percentEquals((double)v1, (double)v2, (double)percent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn);
        v1 = 1.0;
        v2 = 1.009999;
        percent = 0.01;
        expectedReturn = true;
        actualReturn = MathTools.percentEquals((double)v1, (double)v2, (double)percent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn);
        v1 = 1.0;
        v2 = 1.099;
        percent = 0.01;
        expectedReturn = false;
        actualReturn = MathTools.percentEquals((double)v1, (double)v2, (double)percent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn);
    }

    @Test
    public void testCheckIsEqual() {
        MathTools.checkEquals((int)1, (int)1);
        MathTools.checkEquals((int)-2, (int)-2);
        MathTools.checkEpsilonEquals((double)2.0, (double)2.001, (double)0.1);
        MathTools.checkEpsilonEquals((double)-2.0, (double)-2.001, (double)0.1);
    }

    @Test
    public void testCheckIsEqualNaN() {
        Assertions.assertExceptionThrown(RuntimeException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                MathTools.checkEpsilonEquals((double)Double.NaN, (double)Double.NaN, (double)1.0E-12);
            }
        });
    }

    @Test
    public void testCheckIsEqualInt() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> MathTools.checkEquals((int)2, (int)4));
    }

    @Test
    public void testIsGreaterThan() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanWithSignificantFigures((double)2.00011, (double)2.0001, (int)8));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isGreaterThanWithSignificantFigures((double)2.00011, (double)2.0001, (int)4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanWithPrecision((double)2.00011, (double)2.0001, (double)1.0E-8));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isGreaterThanWithPrecision((double)2.00011, (double)2.0001, (double)0.001));
    }

    @Test
    public void testIsGreaterThanOrEqualTo() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithSignificantFigures((double)2.00011, (double)2.0001, (int)8));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithSignificantFigures((double)2.00011, (double)2.0001, (int)4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithSignificantFigures((double)2.00019, (double)2.0002, (int)4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithSignificantFigures((double)2.00019, (double)2.0002, (int)5));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithPrecision((double)2.00011, (double)2.0001, (double)1.0E-8));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithPrecision((double)2.00011, (double)2.0001, (double)0.001));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithPrecision((double)2.00019, (double)2.0002, (double)0.001));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithPrecision((double)2.00019, (double)2.0002, (double)1.0E-4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isGreaterThanOrEqualToWithPrecision((double)2.0002, (double)2.00019, (double)1.0E-5));
    }

    @Test
    public void testIsLessThan() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanWithPrecision((double)2.00011, (double)2.0001, (double)1.0E-8));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanWithPrecision((double)2.00011, (double)2.0001, (double)1.0E-4));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanWithPrecision((double)2.00019, (double)2.0002, (double)1.0E-4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanWithPrecision((double)2.00019, (double)2.0002, (double)1.0E-5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanWithSignificantFigures((double)2.00011, (double)2.0001, (int)1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanWithSignificantFigures((double)2.00011, (double)2.0001, (int)5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanWithSignificantFigures((double)2.00019, (double)2.0002, (int)5));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanWithSignificantFigures((double)2.00019, (double)2.0002, (int)6));
    }

    @Test
    public void testRoundToPrecision() {
        org.junit.jupiter.api.Assertions.assertEquals((double)100.0, (double)MathTools.roundToPrecision((double)123.45, (double)100.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)120.0, (double)MathTools.roundToPrecision((double)123.45, (double)10.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.0, (double)MathTools.roundToPrecision((double)123.45, (double)1.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.5, (double)MathTools.roundToPrecision((double)123.45, (double)0.1), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.roundToPrecision((double)123.45, (double)0.01), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.roundToPrecision((double)123.46, (double)0.05), (String)"not equal");
    }

    @Test
    public void testFloorToPrecision() {
        org.junit.jupiter.api.Assertions.assertEquals((double)100.0, (double)MathTools.floorToPrecision((double)123.45, (double)100.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)100.0, (double)MathTools.floorToPrecision((double)193.45, (double)100.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)120.0, (double)MathTools.floorToPrecision((double)123.45, (double)10.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)120.0, (double)MathTools.floorToPrecision((double)129.45, (double)10.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.0, (double)MathTools.floorToPrecision((double)123.45, (double)1.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.0, (double)MathTools.floorToPrecision((double)123.95, (double)1.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.4, (double)MathTools.floorToPrecision((double)123.45, (double)0.1), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.floorToPrecision((double)123.45, (double)0.01), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.floorToPrecision((double)123.45, (double)0.05), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.floorToPrecision((double)123.49, (double)0.05), (String)"not equal");
    }

    @Test
    public void testCeilToPrecision() {
        org.junit.jupiter.api.Assertions.assertEquals((double)200.0, (double)MathTools.ceilToPrecision((double)123.45, (double)100.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)200.0, (double)MathTools.ceilToPrecision((double)193.45, (double)100.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)130.0, (double)MathTools.ceilToPrecision((double)123.45, (double)10.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)124.0, (double)MathTools.ceilToPrecision((double)123.45, (double)1.0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.5, (double)MathTools.ceilToPrecision((double)123.45, (double)0.1), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.ceilToPrecision((double)123.45, (double)0.01), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.5, (double)MathTools.ceilToPrecision((double)123.46, (double)0.05), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)8.0E20, (double)MathTools.ceilToPrecision((double)7.12413651E20, (double)1.0E20), (String)"not equal");
    }

    @Test
    public void testRoundToSignificantFigures() {
        org.junit.jupiter.api.Assertions.assertEquals((double)100.0, (double)MathTools.roundToSignificantFigures((double)123.45, (int)1), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)120.0, (double)MathTools.roundToSignificantFigures((double)123.45, (int)2), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.0, (double)MathTools.roundToSignificantFigures((double)123.45, (int)3), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.5, (double)MathTools.roundToSignificantFigures((double)123.45, (int)4), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.roundToSignificantFigures((double)123.45, (int)5), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)123.45, (double)MathTools.roundToSignificantFigures((double)123.45, (int)6), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0E-4, (double)MathTools.roundToSignificantFigures((double)1.1E-4, (int)1), (String)"not equal");
        System.out.println("Double.MIN_VALUE: 4.9E-324");
        System.out.println("Double.MAX_VALUE: 1.7976931348623157E308");
        System.out.println("Integer.MAX_VALUE: 2147483647");
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0E-307, (double)MathTools.roundToSignificantFigures((double)1.0E-307, (int)0), (String)"not equal");
        org.junit.jupiter.api.Assertions.assertEquals((double)1.79E-308, (double)MathTools.roundToSignificantFigures((double)1.79E-308, (int)0), (String)"not equal");
    }

    @Test
    public void testIsLessThanOrEqualTo() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanOrEqualToWithSignificantFigures((double)2.00011, (double)2.0001, (int)8));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanOrEqualToWithSignificantFigures((double)2.00011, (double)2.0001, (int)4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanOrEqualToWithSignificantFigures((double)2.00019, (double)2.0002, (int)4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanOrEqualToWithSignificantFigures((double)2.00019, (double)2.0002, (int)5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)MathTools.isLessThanOrEqualToWithPrecision((double)2.00011, (double)2.0001, (double)1.0E-8));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanOrEqualToWithPrecision((double)2.00011, (double)2.0001, (double)1.0E-4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanOrEqualToWithPrecision((double)2.00019, (double)2.0002, (double)1.0E-4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)MathTools.isLessThanOrEqualToWithPrecision((double)2.00019, (double)2.0002, (double)1.0E-6));
    }

    @Test
    public void testCheckIsEqualDouble() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> MathTools.checkEpsilonEquals((double)2.0, (double)2.001, (double)1.0E-4));
    }

    @Test
    public void testGcd() {
        Random random = new Random(12890471L);
        for (int i = 0; i < 1000; ++i) {
            long b;
            long c;
            long a = random.nextInt(Integer.MAX_VALUE);
            org.junit.jupiter.api.Assertions.assertTrue((a % (c = MathTools.gcd((long)a, (long)(b = (long)random.nextInt(Integer.MAX_VALUE)))) == 0L && b % c == 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLcm() {
        Random random = new Random(1240898L);
        for (int i = 0; i < 1000; ++i) {
            long a = random.nextInt(Integer.MAX_VALUE);
            long b = random.nextInt(Integer.MAX_VALUE);
            long c = MathTools.lcm((long[])new long[]{a, b});
            org.junit.jupiter.api.Assertions.assertTrue((c % a == 0L && c % b == 0L ? 1 : 0) != 0);
        }
        long c = MathTools.lcm((long[])new long[]{12L, 18L, 6L, 3L, 4L});
        org.junit.jupiter.api.Assertions.assertEquals((long)36L, (long)c);
    }

    @Test
    public void testLcm_2() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            Random rand = new Random();
            MathTools.lcm((long[])new long[]{rand.nextLong()});
        });
    }

    @Test
    public void testOrderOfMagnitude() {
        org.junit.jupiter.api.Assertions.assertEquals((int)-2, (int)MathTools.orderOfMagnitude((double)-0.01));
        org.junit.jupiter.api.Assertions.assertEquals((int)-2, (int)MathTools.orderOfMagnitude((double)0.01));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)MathTools.orderOfMagnitude((double)0.1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)MathTools.orderOfMagnitude((double)0.9));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)MathTools.orderOfMagnitude((double)1.0));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)MathTools.orderOfMagnitude((double)10.0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)MathTools.orderOfMagnitude((double)100.0));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)MathTools.orderOfMagnitude((double)1000.01));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)MathTools.orderOfMagnitude((double)1000.0));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)MathTools.orderOfMagnitude((double)10000.0));
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(MathTools.class, MathToolsTest.class);
    }
}

