/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.time;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.time.TimeInterval;
import us.ihmc.commons.time.TimeIntervalReadOnly;

public class TimeIntervalTest {
    @Test
    public void testAccessors() {
        double epsilon = 1.0E-6;
        TimeInterval timeInterval = new TimeInterval(0.0, 1.0);
        Assertions.assertEquals((double)timeInterval.getStartTime(), (double)0.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getEndTime(), (double)1.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getDuration(), (double)1.0, (double)epsilon);
        timeInterval.setInterval(2.0, 3.0);
        Assertions.assertEquals((double)timeInterval.getStartTime(), (double)2.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getEndTime(), (double)3.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getDuration(), (double)1.0, (double)epsilon);
        timeInterval.setStartTime(4.0);
        timeInterval.setEndTime(5.0);
        Assertions.assertEquals((double)timeInterval.getStartTime(), (double)4.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getEndTime(), (double)5.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getDuration(), (double)1.0, (double)epsilon);
        TimeInterval other = new TimeInterval(6.0, 7.0);
        timeInterval.set((TimeIntervalReadOnly)other);
        Assertions.assertTrue((boolean)timeInterval.epsilonEquals((TimeIntervalReadOnly)other, epsilon));
    }

    @Test
    public void testShiftInterval() {
        double epsilon = 1.0E-6;
        TimeInterval timeInterval = new TimeInterval(0.0, 1.0);
        timeInterval.shiftInterval(10.0);
        Assertions.assertEquals((double)timeInterval.getStartTime(), (double)10.0, (double)epsilon);
        Assertions.assertEquals((double)timeInterval.getEndTime(), (double)11.0, (double)epsilon);
    }
}

