/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.lists.PreallocatedEnumList;

public class PreallocatedEnumListTest {
    @Test
    public void testConstructor() {
        PreallocatedEnumList list = new PreallocatedEnumList(TestEnum.class, (Enum[])TestEnum.values(), 10);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndGet() {
        int i;
        int i2;
        PreallocatedEnumList list = new PreallocatedEnumList(TestEnum.class, (Enum[])TestEnum.values(), 20);
        ArrayList<TestEnum> expectedList = new ArrayList<TestEnum>();
        int finalSize = 10;
        for (i2 = 0; i2 < finalSize; ++i2) {
            TestEnum value = TestEnum.values()[i2];
            list.add((Enum)value);
            expectedList.add(value);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i2 = 0; i2 < finalSize; ++i2) {
            Assertions.assertTrue((list.get(i2) == expectedList.get(i2) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        try {
            list.get(finalSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException i3) {
            // empty catch block
        }
        list.clear();
        expectedList.clear();
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 8;
        for (i = 0; i < finalSize; ++i) {
            list.add((Enum)TestEnum.values()[i]);
            expectedList.add(TestEnum.values()[i]);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        list.clear();
        expectedList.clear();
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 20;
        for (i = 0; i < finalSize; ++i) {
            list.add((Enum)TestEnum.values()[i]);
            expectedList.add(TestEnum.values()[i]);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        int i;
        int currentSize = 10;
        PreallocatedEnumList list = new PreallocatedEnumList(TestEnum.class, (Enum[])TestEnum.values(), currentSize);
        ArrayList<TestEnum> expectedList = new ArrayList<TestEnum>();
        for (int i2 = 0; i2 < currentSize; ++i2) {
            list.add((Enum)TestEnum.values()[i2]);
            expectedList.add(TestEnum.values()[i2]);
        }
        int indexOfRemovedObject = 3;
        list.remove(indexOfRemovedObject);
        expectedList.remove(indexOfRemovedObject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        indexOfRemovedObject = currentSize - 1;
        list.remove(indexOfRemovedObject);
        expectedList.remove(indexOfRemovedObject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        try {
            list.remove(currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSwap() {
        Random rand = new Random(141456L);
        int currentSize = 10;
        PreallocatedEnumList list = new PreallocatedEnumList(TestEnum.class, (Enum[])TestEnum.values(), currentSize);
        ArrayList<TestEnum> expectedList = new ArrayList<TestEnum>();
        for (int i = 0; i < currentSize; ++i) {
            list.add((Enum)TestEnum.values()[i]);
            expectedList.add(TestEnum.values()[i]);
        }
        for (int k = 0; k < 20; ++k) {
            int indexA = rand.nextInt(currentSize);
            int indexB = rand.nextInt(currentSize);
            list.swap(indexA, indexB);
            Collections.swap(expectedList, indexA, indexB);
            Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
            for (int i = 0; i < currentSize; ++i) {
                Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
            }
        }
        try {
            list.swap(0, currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.swap(currentSize, 0);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSort() {
        PreallocatedEnumList list = new PreallocatedEnumList(TestEnum.class, (Enum[])TestEnum.values(), 4);
        list.add((Enum)TestEnum.FOXTROT);
        list.add((Enum)TestEnum.UNIFORM);
        list.add((Enum)TestEnum.CHARLIE);
        list.add((Enum)TestEnum.KILO);
        list.sort(Comparator.comparing(Enum::name));
        Assertions.assertTrue((boolean)((TestEnum)list.get(0)).equals((Object)TestEnum.CHARLIE));
        Assertions.assertTrue((boolean)((TestEnum)list.get(1)).equals((Object)TestEnum.FOXTROT));
        Assertions.assertTrue((boolean)((TestEnum)list.get(2)).equals((Object)TestEnum.KILO));
        Assertions.assertTrue((boolean)((TestEnum)list.get(3)).equals((Object)TestEnum.UNIFORM));
    }

    private static enum TestEnum {
        ALFA,
        BRAVO,
        CHARLIE,
        DELTA,
        ECHO,
        FOXTROT,
        GOLF,
        HOTEL,
        INDIA,
        JULIETT,
        KILO,
        LIMA,
        MIKE,
        NOVEMBER,
        OSCAR,
        PAPA,
        QUEBEC,
        ROMEO,
        SIERRA,
        TANGO,
        UNIFORM,
        VICTOR,
        WHISKEY,
        XRAY,
        YANKEE,
        ZULU;

    }
}

