/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.allocations;

import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.commons.lists.PreallocatedEnumList;
import us.ihmc.commons.lists.PreallocatedList;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.RecyclingLinkedList;
import us.ihmc.log.LogTools;

public class ListAllocationTest {
    private AllocationProfiler allocationProfiler;

    @BeforeEach
    public void setUp() {
        this.allocationProfiler = new AllocationProfiler();
        this.allocationProfiler.includeAllocationsInsideClass(MutableInt.class.getName());
        this.allocationProfiler.includeAllocationsInsideClass(RecyclingArrayList.class.getName());
        this.allocationProfiler.includeAllocationsInsideClass(RecyclingArrayDeque.class.getName());
        this.allocationProfiler.includeAllocationsInsideClass(PreallocatedList.class.getName());
        this.allocationProfiler.includeAllocationsInsideClass(PreallocatedEnumList.class.getName());
        this.allocationProfiler.includeAllocationsInsideClass(RecyclingLinkedList.class.getName());
    }

    @Tag(value="allocation")
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testRecyclingArrayList() {
        int capacity = 5;
        RecyclingArrayList list = new RecyclingArrayList(capacity, MutableInt::new);
        this.testInternal(() -> {
            int i;
            for (i = 0; i < capacity; ++i) {
                ((MutableInt)list.add()).setValue(i);
            }
            for (i = 0; i < capacity; ++i) {
                ((MutableInt)list.get(i)).setValue(2 * i);
            }
            for (i = capacity - 1; i >= 0; --i) {
                list.remove(i);
            }
            list.clear();
        });
    }

    @Tag(value="allocation")
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testRecyclingArrayDeque() {
        int capacity = 8;
        RecyclingArrayDeque deque = new RecyclingArrayDeque(capacity, MutableInt::new, MutableInt::setValue);
        MutableInt spareInt = new MutableInt();
        this.testInternal(() -> {
            for (int i = 0; i < 2; ++i) {
                deque.addFirst();
                deque.addLast();
                deque.add((Object)spareInt);
                deque.addFirst((Object)spareInt);
                deque.addLast((Object)spareInt);
                deque.push((Object)spareInt);
                deque.offerFirst((Object)spareInt);
                deque.offerLast((Object)spareInt);
                deque.removeFirst();
                deque.removeLast();
                deque.pollFirst();
                deque.pollLast();
                deque.remove();
                deque.poll();
                deque.pop();
                deque.clear();
            }
        });
    }

    @Tag(value="allocation")
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testPreallocatedList() {
        int capacity = 8;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, capacity);
        this.testInternal(() -> {
            int i;
            for (i = 0; i < capacity; ++i) {
                list.add();
            }
            for (i = 0; i < capacity; ++i) {
                ((MutableInt)list.get(i)).setValue(i);
            }
            for (i = 0; i < capacity - 3; ++i) {
                list.remove();
            }
            list.clear();
        });
    }

    @Tag(value="allocation")
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testPreallocatedEnumList() {
        int capacity = 8;
        Enum[] values = TestEnum.values();
        PreallocatedEnumList list = new PreallocatedEnumList(TestEnum.class, values, capacity);
        this.testInternal(() -> ListAllocationTest.lambda$testPreallocatedEnumList$3(capacity, list, (TestEnum[])values));
    }

    @Tag(value="allocation")
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testRecyclingLinkedList() {
        MutableInt element = new MutableInt();
        RecyclingLinkedList linkedListA = new RecyclingLinkedList(MutableInt::new, MutableInt::setValue);
        this.testInternal(() -> {
            for (int i = 0; i < 16; ++i) {
                linkedListA.addLast((Object)element);
            }
            linkedListA.removeLast((Object)element);
            linkedListA.addLast((Object)element);
            linkedListA.removeFirst((Object)element);
            linkedListA.addFirst((Object)element);
        });
        try {
            this.testInternal(() -> linkedListA.addLast((Object)element));
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        RecyclingLinkedList linkedListB = new RecyclingLinkedList(MutableInt.class, MutableInt::setValue);
        this.testInternal(() -> {
            for (int i = 0; i < 16; ++i) {
                linkedListB.addLast((Object)element);
            }
            linkedListB.removeLast((Object)element);
            linkedListB.addLast((Object)element);
            linkedListB.removeFirst((Object)element);
            linkedListB.addFirst((Object)element);
        });
        try {
            this.testInternal(() -> linkedListB.addFirst((Object)element));
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private void testInternal(Runnable whatToTestFor) {
        List allocations = this.allocationProfiler.recordAllocations(whatToTestFor);
        if (!allocations.isEmpty()) {
            allocations.forEach(it -> LogTools.info((String)it.toString()));
            Assertions.fail((String)"Found allocations.");
        }
    }

    private static /* synthetic */ void lambda$testPreallocatedEnumList$3(int capacity, PreallocatedEnumList list, TestEnum[] values) {
        int i;
        for (i = 0; i < capacity; ++i) {
            list.add((Enum)values[i % values.length]);
        }
        for (i = 0; i < capacity; ++i) {
            list.get(i);
        }
        for (i = 0; i < capacity; ++i) {
            list.setEnum(i, (Enum)values[(i + 2) % values.length]);
        }
        for (i = 0; i < capacity; ++i) {
            list.remove();
        }
        for (i = 0; i < capacity; ++i) {
            list.add((Enum)values[i % values.length]);
        }
        list.remove(capacity / 2);
        list.clear();
    }

    private static enum TestEnum {
        A,
        B,
        C,
        D;

    }
}

