/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MutationTestFacilitator;

public class ConversionsTest {
    @Test
    public void kibibytesToBytes() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int kibibytes = rand.nextInt();
            Assertions.assertEquals((double)Conversions.kibibytesToBytes((int)kibibytes), (double)(kibibytes * 1024), (double)1.0E-12);
        }
    }

    @Test
    public void kilobytesToBytes() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int kilobytes = rand.nextInt();
            Assertions.assertEquals((double)Conversions.kilobytesToBytes((int)kilobytes), (double)(kilobytes * 1000), (double)1.0E-12);
        }
    }

    @Test
    public void megabytesToBytes() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int megabytes = rand.nextInt();
            Assertions.assertEquals((double)Conversions.megabytesToBytes((int)megabytes), (double)(megabytes * 1000000), (double)1.0E-12);
        }
    }

    @Test
    public void mebibytesToBytes() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int mebibytes = rand.nextInt();
            Assertions.assertEquals((double)Conversions.mebibytesToBytes((int)mebibytes), (double)(mebibytes * 0x100000), (double)1.0E-12);
        }
    }

    @Test
    public void testToSeconds() {
        long timestamp = 1500000000L;
        Assertions.assertEquals((double)1.5, (double)Conversions.nanosecondsToSeconds((long)timestamp), (double)1.0E-22);
        Assertions.assertEquals((double)-1.5, (double)Conversions.nanosecondsToSeconds((long)(-timestamp)), (double)1.0E-22);
    }

    @Test
    public void testToNanoSeconds() {
        double time = 1.5;
        Assertions.assertEquals((long)1500000000L, (long)Conversions.secondsToNanoseconds((double)time));
        Assertions.assertEquals((long)-1500000000L, (long)Conversions.secondsToNanoseconds((double)(-time)));
    }

    @Test
    public void testMicroSecondsToNanoseconds() {
        long mSecs = 2L;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            mSecs = (long)random.nextFloat() * 1000L;
            Assertions.assertEquals((double)((double)mSecs * 1000.0), (double)Conversions.microsecondsToNanoseconds((long)mSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-mSecs) * 1000.0), (double)Conversions.microsecondsToNanoseconds((long)(-mSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testSecondsToMilliseconds() {
        long secs = 2L;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            secs = (long)random.nextFloat() * 1000L;
            Assertions.assertEquals((double)((double)secs * 1000.0), (double)Conversions.secondsToMilliseconds((double)secs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-secs) * 1000.0), (double)Conversions.secondsToMilliseconds((double)(-secs)), (double)1.0E-6);
        }
    }

    @Test
    public void testMillisecondsToSeconds() {
        long mSecs = 2L;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            mSecs = (long)random.nextFloat() * 1000L;
            Assertions.assertEquals((double)((double)mSecs * 0.001), (double)Conversions.millisecondsToSeconds((double)mSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-mSecs) * 0.001), (double)Conversions.millisecondsToSeconds((double)(-mSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testMillisecondsToMinutes() {
        long mSecs = 2L;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            mSecs = (long)random.nextFloat() * 1000L;
            Assertions.assertEquals((double)((double)mSecs * 0.001 / 60.0), (double)Conversions.millisecondsToMinutes((double)mSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-mSecs) * 0.001 / 60.0), (double)Conversions.millisecondsToMinutes((double)(-mSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testMillisecondsToNanoSeconds() {
        int mSecs = 2;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            mSecs = (int)random.nextFloat() * 1000;
            Assertions.assertEquals((double)((double)mSecs * 1000000.0), (double)Conversions.millisecondsToNanoseconds((long)mSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-mSecs) * 1000000.0), (double)Conversions.millisecondsToNanoseconds((long)(-mSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testMicroSecondsToSeconds() {
        int mSecs = 2;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            mSecs = (int)random.nextFloat() * 1000;
            Assertions.assertEquals((double)((double)mSecs * 1.0E-6), (double)Conversions.microsecondsToSeconds((double)mSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-mSecs) * 1.0E-6), (double)Conversions.microsecondsToSeconds((double)(-mSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testMinutesToSeconds() {
        int mins = 2;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            mins = (int)random.nextFloat() * 1000;
            Assertions.assertEquals((double)(mins * 60), (double)Conversions.minutesToSeconds((double)mins), (double)1.0E-6);
            Assertions.assertEquals((double)(-mins * 60), (double)Conversions.minutesToSeconds((double)(-mins)), (double)1.0E-6);
        }
    }

    @Test
    public void testSecondsToMinutes() {
        int secs = 2;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            secs = (int)random.nextFloat() * 1000;
            Assertions.assertEquals((double)((double)secs / 60.0), (double)Conversions.secondsToMinutes((double)secs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-secs) / 60.0), (double)Conversions.secondsToMinutes((double)(-secs)), (double)1.0E-6);
        }
    }

    @Test
    public void testNanoSecondsToMilliSeconds() {
        int nSecs = 2;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            nSecs = (int)random.nextFloat() * 1000;
            Assertions.assertEquals((double)((double)nSecs * 1.0E-6), (double)Conversions.nanosecondsToMilliseconds((long)nSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-nSecs) * 1.0E-6), (double)Conversions.nanosecondsToMilliseconds((long)(-nSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testNanoSecondsToMicroSeconds() {
        int nSecs = 2;
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            nSecs = (int)random.nextFloat() * 1000;
            Assertions.assertEquals((double)((double)nSecs * 0.001), (double)Conversions.nanosecondsToMicroseconds((long)nSecs), (double)1.0E-6);
            Assertions.assertEquals((double)((double)(-nSecs) * 0.001), (double)Conversions.nanosecondsToMicroseconds((long)(-nSecs)), (double)1.0E-6);
        }
    }

    @Test
    public void testMagnitudeToDecibels() {
        double epsilon = 1.0E-10;
        Assertions.assertEquals((double)20.0, (double)Conversions.amplitudeToDecibels((double)10.0), (double)epsilon);
        Assertions.assertEquals((double)40.0, (double)Conversions.amplitudeToDecibels((double)100.0), (double)epsilon);
        Assertions.assertEquals((double)28.691378080683975, (double)Conversions.amplitudeToDecibels((double)27.2), (double)epsilon);
        double[] magnitudes = new double[]{10.0, 100.0, 27.2};
        double[] decibels = new double[magnitudes.length];
        for (int i = 0; i < magnitudes.length; ++i) {
            decibels[i] = Conversions.amplitudeToDecibels((double)magnitudes[i]);
        }
        Assertions.assertEquals((double)20.0, (double)decibels[0], (double)epsilon);
        Assertions.assertEquals((double)40.0, (double)decibels[1], (double)epsilon);
        Assertions.assertEquals((double)28.691378080683975, (double)decibels[2], (double)epsilon);
    }

    @Test
    public void testNaN() {
        double magnitude = -1.0;
        double decibels = Conversions.amplitudeToDecibels((double)magnitude);
        Assertions.assertTrue((boolean)Double.isNaN(decibels));
    }

    @Test
    public void testNegativeInfinity() {
        double magnitude = 0.0;
        double decibels = Conversions.amplitudeToDecibels((double)magnitude);
        Assertions.assertTrue((boolean)Double.isInfinite(decibels));
    }

    @Test
    public void testMinutesSecondsConversions() {
        Assertions.assertEquals((double)60.0, (double)Conversions.minutesToSeconds((double)1.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)12000.0, (double)Conversions.minutesToSeconds((double)200.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0, (double)Conversions.secondsToMinutes((double)60.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)2.0, (double)Conversions.secondsToMinutes((double)120.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1000.0, (double)Conversions.secondsToMilliseconds((double)1.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0, (double)Conversions.millisecondsToSeconds((double)1000.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0, (double)Conversions.millisecondsToMinutes((double)60000.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1000000.0, (double)Conversions.millisecondsToNanoseconds((double)1.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0E9, (double)Conversions.millisecondsToNanoseconds((long)1000L), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0, (double)Conversions.microsecondsToSeconds((double)1000000.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1000.0, (double)Conversions.microsecondsToNanoseconds((long)1L), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1000.0, (double)Conversions.microsecondsToNanoseconds((double)1.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0E-6, (double)Conversions.nanosecondsToMilliseconds((double)1.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0, (double)Conversions.nanosecondsToMilliseconds((long)1000000L), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1000.0, (double)Conversions.nanosecondsToMicroseconds((long)1000000L), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)0.001, (double)Conversions.nanosecondsToMicroseconds((double)1.0), (double)1.0E-7, (String)"Not equal");
        Assertions.assertEquals((double)1.0, (double)Conversions.nanosecondsToMicroseconds((long)1000L), (double)1.0E-7, (String)"Not equal");
    }

    @Test
    public void testRadiansPerSecondToHz() {
        double[] freqInRadPerSecond = new double[]{0.0, 0.7853981633974483, Math.PI, Math.PI * 2, Math.PI * 4};
        double[] freqInHz = new double[freqInRadPerSecond.length];
        for (int i = 0; i < freqInRadPerSecond.length; ++i) {
            freqInHz[i] = Conversions.radiansPerSecondToHertz((double)freqInRadPerSecond[i]);
        }
        double epsilon = 1.0E-10;
        Assertions.assertEquals((double)0.0, (double)freqInHz[0], (double)epsilon);
        Assertions.assertEquals((double)0.125, (double)freqInHz[1], (double)epsilon);
        Assertions.assertEquals((double)0.5, (double)freqInHz[2], (double)epsilon);
        Assertions.assertEquals((double)1.0, (double)freqInHz[3], (double)epsilon);
        Assertions.assertEquals((double)2.0, (double)freqInHz[4], (double)epsilon);
        freqInRadPerSecond = new double[]{-0.0, -0.7853981633974483, -Math.PI, Math.PI * -2, Math.PI * -4};
        freqInHz = new double[freqInRadPerSecond.length];
        for (int i = 0; i < freqInRadPerSecond.length; ++i) {
            freqInHz[i] = Conversions.radiansPerSecondToHertz((double)freqInRadPerSecond[i]);
        }
        Assertions.assertEquals((double)-0.0, (double)freqInHz[0], (double)epsilon);
        Assertions.assertEquals((double)-0.125, (double)freqInHz[1], (double)epsilon);
        Assertions.assertEquals((double)-0.5, (double)freqInHz[2], (double)epsilon);
        Assertions.assertEquals((double)-1.0, (double)freqInHz[3], (double)epsilon);
        Assertions.assertEquals((double)-2.0, (double)freqInHz[4], (double)epsilon);
    }

    @Test
    public void testSecondsAndHertz() {
        Assertions.assertEquals((double)0.004, (double)Conversions.hertzToSeconds((double)250.0));
        Assertions.assertEquals((double)0.02, (double)Conversions.secondsToHertz((double)50.0));
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(Conversions.class, ConversionsTest.class);
    }
}

