/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.lists.SupplierBuilder;

public class SupplierBuilderTest {
    @Test
    public void testZeroIndexedSupplierBuilder() {
        IntFunction<MutableInt> indexFunction = index -> new MutableInt(2 * index - 1);
        Supplier intSupplier = SupplierBuilder.indexedSupplier(indexFunction);
        for (int i = 0; i < 10; ++i) {
            MutableInt mutableInt = (MutableInt)intSupplier.get();
            Assertions.assertEquals((long)mutableInt.getValue().intValue(), (long)indexFunction.apply(i).getValue().intValue());
        }
    }

    @Test
    public void testNonZeroIndexedSupplierBuilder() {
        int initialIndex = 10;
        IntFunction<MutableInt> indexFunction = index -> new MutableInt(-3 * index + 1);
        Supplier intSupplier = SupplierBuilder.indexedSupplier(indexFunction, (int)initialIndex);
        for (int i = 0; i < 10; ++i) {
            MutableInt mutableInt = (MutableInt)intSupplier.get();
            Assertions.assertEquals((long)mutableInt.getValue().intValue(), (long)indexFunction.apply(i + initialIndex).getValue().intValue());
        }
    }

    @Test
    public void testMutableIntSupplierFromConstructor() {
        Supplier supplier = SupplierBuilder.createFromEmptyConstructor(MutableInt.class);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)((MutableInt)supplier.get()).getValue().intValue(), (long)0L);
        }
    }
}

