/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;

public class RandomNumbersTest {
    @Test
    public void testGenerateRandomFloatArray() {
        float[] randomFloatArray;
        Random random = new Random();
        for (float randomFloat : randomFloatArray = RandomNumbers.nextFloatArray((Random)random, (int)1000, (float)0.0f, (float)10.0f)) {
            Assertions.assertTrue((randomFloat >= 0.0f && randomFloat <= 10.0f ? 1 : 0) != 0);
        }
        for (float randomFloat : randomFloatArray = RandomNumbers.nextFloatArray((Random)random, (int)1000, (float)5.0f)) {
            Assertions.assertTrue((randomFloat >= -5.0f && randomFloat <= 5.0f ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGenerateRandomIntArray() {
        int[] randomIntArray;
        Random random = new Random();
        for (int randomInt : randomIntArray = RandomNumbers.nextIntArray((Random)random, (int)1000, (int)0, (int)10)) {
            Assertions.assertTrue((randomInt >= 0 && randomInt <= 10 ? 1 : 0) != 0);
        }
        int[] nArray = randomIntArray = RandomNumbers.nextIntArray((Random)random, (int)1000, (int)5);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float randomFloat = nArray[i];
            Assertions.assertTrue((randomFloat >= -5.0f && randomFloat <= 5.0f ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGenerateRandomDoubleInRange() {
        Random random = new Random(1876L);
        double range1 = 100.0;
        double range2 = 30.0;
        for (int i = 0; i < 25; ++i) {
            double actualReturn = RandomNumbers.nextDouble((Random)random, (double)range1, (double)range2);
            Assertions.assertTrue((range1 < actualReturn && actualReturn < range2 || range2 < actualReturn && actualReturn < range1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGenerateRandomFloatInRange() {
        Random random = new Random(1876L);
        float range1 = 100.0f;
        float range2 = 30.0f;
        for (int i = 0; i < 25; ++i) {
            double actualReturn = RandomNumbers.nextFloat((Random)random, (float)range1, (float)range2);
            Assertions.assertTrue(((double)range1 < actualReturn && actualReturn < (double)range2 || (double)range2 < actualReturn && actualReturn < (double)range1 ? 1 : 0) != 0);
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(RandomNumbers.class, RandomNumbersTest.class);
    }
}

