/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MutationTestFacilitator;

public class InterpolationToolsTest {
    private static final double epsilon = 1.0E-7;
    private static final int iters = 1000;
    private Random random;

    @BeforeEach
    public void setUp() throws Exception {
        this.random = new Random(100L);
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testPiecewiseInterpolation() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)0.2);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)0.8);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)0.5);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)1.1);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)30.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)-0.1);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)-30.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            double alpha = this.random.nextDouble();
            if (alpha < 0.5) {
                value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)alpha);
                Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
                continue;
            }
            value = InterpolationTools.piecewiseInterpolate((double)boundA, (double)boundB, (double)alpha);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
        }
    }

    @Test
    public void testPiecewiseInterpolationRoundDown() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)0.2);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)0.8);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)0.5);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)1.1);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)30.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)-0.1);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)-30.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            double alpha = this.random.nextDouble();
            if (alpha > 0.5) {
                value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)alpha);
                Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
                continue;
            }
            value = InterpolationTools.piecewiseInterpolateRoundDown((double)boundA, (double)boundB, (double)alpha);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
        }
    }

    @Test
    public void testLinearInterpolateBounds() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double value = InterpolationTools.linearInterpolate((double)boundA, (double)boundB, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.linearInterpolate((double)boundA, (double)boundB, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
        }
    }

    @Test
    public void testLinearInterpolate() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double average = 0.5 * (boundA + boundB);
            double value = InterpolationTools.linearInterpolate((double)boundA, (double)boundB, (double)0.5);
            Assertions.assertEquals((double)value, (double)average, (double)1.0E-7);
        }
    }

    @Test
    public void testHermite01InterpolateBounds() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double value = InterpolationTools.hermite01Interpolate((double)boundA, (double)boundB, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.hermite01Interpolate((double)boundA, (double)boundB, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
        }
    }

    @Test
    public void testHermite01Interpolate() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double average = 0.5 * (boundA + boundB);
            double value = InterpolationTools.hermite01Interpolate((double)boundA, (double)boundB, (double)0.5);
            Assertions.assertEquals((double)value, (double)average, (double)1.0E-7);
        }
    }

    @Test
    public void testHermiteInterpolateBounds() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double boundATangent = 100.0 * this.random.nextDouble();
            double boundBTangent = 100.0 * this.random.nextDouble();
            double value = InterpolationTools.hermiteInterpolate((double)boundA, (double)boundB, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.hermiteInterpolate((double)boundA, (double)boundATangent, (double)boundB, (double)boundBTangent, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.hermiteInterpolate((double)boundA, (double)boundB, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.hermiteInterpolate((double)boundA, (double)boundATangent, (double)boundB, (double)boundBTangent, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
        }
    }

    @Test
    public void testHermiteInterpolate() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double average = 0.5 * (boundA + boundB);
            double value = InterpolationTools.hermiteInterpolate((double)boundA, (double)boundB, (double)0.5);
            Assertions.assertEquals((double)value, (double)average, (double)1.0E-7);
        }
    }

    @Test
    public void testLogisticInterpolateBounds() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)0.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)0.1);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)1.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)0.1);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)-0.1);
            Assertions.assertEquals((double)value, (double)boundA, (double)0.1);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)-1.0);
            Assertions.assertEquals((double)value, (double)boundA, (double)0.1);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)1.1);
            Assertions.assertEquals((double)value, (double)boundB, (double)0.1);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)2.0);
            Assertions.assertEquals((double)value, (double)boundB, (double)0.1);
        }
    }

    @Test
    public void testLogisticInterpolate() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double average = 0.5 * (boundA + boundB);
            double value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)0.5);
            Assertions.assertEquals((double)value, (double)average, (double)1.0E-7);
        }
    }

    @Test
    public void testLogisticInterpolateSlopedBounds() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double slope = 10.0;
            double value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)0.0, (double)slope);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)1.0, (double)slope);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)-0.1, (double)slope);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)-1.0, (double)slope);
            Assertions.assertEquals((double)value, (double)boundA, (double)1.0E-7);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)1.1, (double)slope);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
            value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)2.0, (double)slope);
            Assertions.assertEquals((double)value, (double)boundB, (double)1.0E-7);
        }
    }

    @Test
    public void testLogisticInterpolateSloped() {
        for (int i = 0; i < 1000; ++i) {
            double boundA = 10.0 * this.random.nextDouble();
            double boundB = 10.0 * this.random.nextDouble();
            double slope = 10.0;
            double average = 0.5 * (boundA + boundB);
            double value = InterpolationTools.logisticInterpolate((double)boundA, (double)boundB, (double)0.5, (double)slope);
            Assertions.assertEquals((double)value, (double)average, (double)1.0E-7);
        }
    }

    @Test
    public void testHermiteCoefficients() {
        double h00 = InterpolationTools.hermite00Coefficient((double)0.0);
        Assertions.assertEquals((double)h00, (double)1.0, (double)1.0E-7);
        double h10 = InterpolationTools.hermite10Coefficient((double)0.0);
        Assertions.assertEquals((double)h10, (double)0.0, (double)1.0E-7);
        double h01 = InterpolationTools.hermite01Coefficient((double)0.0);
        Assertions.assertEquals((double)h01, (double)0.0, (double)1.0E-7);
        double h11 = InterpolationTools.hermite11Coefficient((double)0.0);
        Assertions.assertEquals((double)h11, (double)0.0, (double)1.0E-7);
        h00 = InterpolationTools.hermite00Coefficient((double)1.0);
        Assertions.assertEquals((double)h00, (double)0.0, (double)1.0E-7);
        h10 = InterpolationTools.hermite10Coefficient((double)1.0);
        Assertions.assertEquals((double)h10, (double)0.0, (double)1.0E-7);
        h01 = InterpolationTools.hermite01Coefficient((double)1.0);
        Assertions.assertEquals((double)h01, (double)1.0, (double)1.0E-7);
        h11 = InterpolationTools.hermite11Coefficient((double)1.0);
        Assertions.assertEquals((double)h11, (double)0.0, (double)1.0E-7);
        h00 = InterpolationTools.hermite00Coefficient((double)0.5);
        Assertions.assertEquals((double)h00, (double)0.5, (double)1.0E-7);
        h10 = InterpolationTools.hermite10Coefficient((double)0.5);
        Assertions.assertEquals((double)h10, (double)0.125, (double)1.0E-7);
        h01 = InterpolationTools.hermite01Coefficient((double)0.5);
        Assertions.assertEquals((double)h01, (double)0.5, (double)1.0E-7);
        h11 = InterpolationTools.hermite11Coefficient((double)0.5);
        Assertions.assertEquals((double)h11, (double)-0.125, (double)1.0E-7);
        for (int i = 0; i < 1000; ++i) {
            double alpha = this.random.nextDouble();
            h00 = InterpolationTools.hermite00Coefficient((double)alpha);
            double h00ShouldBe = 2.0 * Math.pow(alpha, 3.0) - 3.0 * Math.pow(alpha, 2.0) + 1.0;
            Assertions.assertEquals((double)h00, (double)h00ShouldBe, (double)1.0E-7);
            h10 = InterpolationTools.hermite10Coefficient((double)alpha);
            double h10ShouldBe = Math.pow(alpha, 3.0) - 2.0 * Math.pow(alpha, 2.0) + alpha;
            Assertions.assertEquals((double)h10, (double)h10ShouldBe, (double)1.0E-7);
            h01 = InterpolationTools.hermite01Coefficient((double)alpha);
            double h01ShouldBe = -2.0 * Math.pow(alpha, 3.0) + 3.0 * Math.pow(alpha, 2.0);
            Assertions.assertEquals((double)h01, (double)h01ShouldBe, (double)1.0E-7);
            h11 = InterpolationTools.hermite11Coefficient((double)alpha);
            double h11ShouldBe = Math.pow(alpha, 3.0) - Math.pow(alpha, 2.0);
            Assertions.assertEquals((double)h11, (double)h11ShouldBe, (double)1.0E-7);
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(InterpolationTools.class, InterpolationToolsTest.class);
    }
}

