/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.time;

import java.util.Random;
import java.util.function.DoubleSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;

public class StopwatchTest {
    @Test
    public void testConstructor() {
        Stopwatch stopwatch = new Stopwatch();
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.averageLap(), (String)"didnt NaN");
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.lapElapsed(), (String)"didnt NaN");
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.totalElapsed(), (String)"didnt NaN");
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.lap(), (String)"didnt NaN");
        stopwatch = new Stopwatch((DoubleSupplier)new FakeTimeProvider());
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.averageLap(), (String)"didnt NaN");
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.lapElapsed(), (String)"didnt NaN");
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.totalElapsed(), (String)"didnt NaN");
        Assertions.assertEquals((double)Double.NaN, (double)stopwatch.lap(), (String)"didnt NaN");
    }

    @Test
    public void testStopwatchWithRealTime() throws InterruptedException {
        Stopwatch stopwatch = new Stopwatch();
        double averageLap = stopwatch.averageLap();
        LogTools.debug((String)("Lap: " + stopwatch.lap()));
        Assertions.assertEquals((double)Double.NaN, (double)averageLap, (double)0.01, (String)"averageLap incorrect");
        Assertions.assertEquals((Object)stopwatch, (Object)stopwatch.start(), (String)"return ref not equal");
        double lapElapsed = stopwatch.lapElapsed();
        double totalElapsed = stopwatch.totalElapsed();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)0.01, (String)"lapElapsed incorrect");
        Assertions.assertEquals((double)0.0, (double)totalElapsed, (double)0.01, (String)"totalElapsed incorrect");
        Assertions.assertEquals((double)Double.NaN, (double)averageLap, (double)0.01, (String)"averageLap incorrect");
        double sleepTime1 = 0.5;
        Thread.sleep((long)Conversions.secondsToMilliseconds((double)sleepTime1));
        double lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)sleepTime1, (double)lap, (double)0.01, (String)"lap incorrect");
        Assertions.assertEquals((double)sleepTime1, (double)averageLap, (double)0.01, (String)"averageLap incorrect");
        double sleepTime2 = 1.0;
        Thread.sleep((long)Conversions.secondsToMilliseconds((double)sleepTime2));
        lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)sleepTime2, (double)lap, (double)0.01, (String)"lap incorrect");
        Assertions.assertEquals((double)((sleepTime1 + sleepTime2) / 2.0), (double)averageLap, (double)0.01, (String)"averageLap incorrect");
        stopwatch.resetLap();
        lapElapsed = stopwatch.lapElapsed();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)0.01, (String)"lapElapsed incorrect");
        lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)0.0, (double)lap, (double)0.01, (String)"lap incorrect");
        Assertions.assertEquals((double)((sleepTime1 + sleepTime2) / 3.0), (double)averageLap, (double)0.01, (String)"averageLap incorrect");
        double sleepTime3 = 0.3;
        Thread.sleep((long)Conversions.secondsToMilliseconds((double)sleepTime3));
        lapElapsed = stopwatch.lapElapsed();
        totalElapsed = stopwatch.totalElapsed();
        Assertions.assertEquals((double)sleepTime3, (double)lapElapsed, (double)0.01, (String)"lapElapsed incorrect");
        Assertions.assertEquals((double)(sleepTime1 + sleepTime2 + sleepTime3), (double)totalElapsed, (double)0.01, (String)"totalElapsed incorrect");
        stopwatch.reset();
        lapElapsed = stopwatch.lapElapsed();
        totalElapsed = stopwatch.totalElapsed();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)0.01, (String)"lapElapsed incorrect");
        Assertions.assertEquals((double)0.0, (double)totalElapsed, (double)0.01, (String)"totalElapsed incorrect");
        Assertions.assertEquals((double)Double.NaN, (double)averageLap, (double)0.01, (String)"averageLap incorrect");
        double sleepTime4 = 0.3;
        Thread.sleep((long)Conversions.secondsToMilliseconds((double)sleepTime4));
        stopwatch.resetLap();
        lapElapsed = stopwatch.lapElapsed();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)0.01, (String)"lapElapsed incorrect");
    }

    @Test
    public void testStopwatch() {
        FakeTimeProvider fakeTimeProvider = new FakeTimeProvider();
        Stopwatch stopwatch = new Stopwatch((DoubleSupplier)fakeTimeProvider);
        double averageLap = stopwatch.averageLap();
        LogTools.debug((String)("Lap: " + stopwatch.lap()));
        Assertions.assertEquals((double)Double.NaN, (double)averageLap, (double)1.0E-10, (String)"averageLap incorrect");
        Assertions.assertEquals((Object)stopwatch, (Object)stopwatch.start(), (String)"return ref not equal");
        double lapElapsed = stopwatch.lapElapsed();
        double totalElapsed = stopwatch.totalElapsed();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)1.0E-10, (String)"lapElapsed incorrect");
        Assertions.assertEquals((double)0.0, (double)totalElapsed, (double)1.0E-10, (String)"totalElapsed incorrect");
        Assertions.assertEquals((double)Double.NaN, (double)averageLap, (double)1.0E-10, (String)"averageLap incorrect");
        double sleepTime1 = 0.5;
        fakeTimeProvider.incrementClock(sleepTime1);
        double lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)sleepTime1, (double)lap, (double)1.0E-10, (String)"lap incorrect");
        Assertions.assertEquals((double)sleepTime1, (double)averageLap, (double)1.0E-10, (String)"averageLap incorrect");
        double sleepTime2 = 1.0;
        fakeTimeProvider.incrementClock(sleepTime2);
        lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)sleepTime2, (double)lap, (double)1.0E-10, (String)"lap incorrect");
        Assertions.assertEquals((double)((sleepTime1 + sleepTime2) / 2.0), (double)averageLap, (double)1.0E-10, (String)"averageLap incorrect");
        stopwatch.resetLap();
        lapElapsed = stopwatch.lapElapsed();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)1.0E-10, (String)"lapElapsed incorrect");
        lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)0.0, (double)lap, (double)1.0E-10, (String)"lap incorrect");
        Assertions.assertEquals((double)((sleepTime1 + sleepTime2) / 3.0), (double)averageLap, (double)1.0E-10, (String)"averageLap incorrect");
        double sleepTime3 = 0.3;
        fakeTimeProvider.incrementClock(sleepTime3);
        lapElapsed = stopwatch.lapElapsed();
        totalElapsed = stopwatch.totalElapsed();
        Assertions.assertEquals((double)sleepTime3, (double)lapElapsed, (double)1.0E-10, (String)"lapElapsed incorrect");
        Assertions.assertEquals((double)(sleepTime1 + sleepTime2 + sleepTime3), (double)totalElapsed, (double)1.0E-10, (String)"totalElapsed incorrect");
        stopwatch.reset();
        lapElapsed = stopwatch.lapElapsed();
        totalElapsed = stopwatch.totalElapsed();
        averageLap = stopwatch.averageLap();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)1.0E-10, (String)"lapElapsed incorrect");
        Assertions.assertEquals((double)0.0, (double)totalElapsed, (double)1.0E-10, (String)"totalElapsed incorrect");
        Assertions.assertEquals((double)Double.NaN, (double)averageLap, (double)1.0E-10, (String)"averageLap incorrect");
        double sleepTime4 = 0.3;
        fakeTimeProvider.incrementClock(sleepTime4);
        stopwatch.resetLap();
        lapElapsed = stopwatch.lapElapsed();
        Assertions.assertEquals((double)0.0, (double)lapElapsed, (double)1.0E-10, (String)"lapElapsed incorrect");
    }

    @Test
    public void testSuspendAndResume() {
        double randomDuration5;
        double randomDuration4;
        double randomDuration3;
        double randomDuration2;
        double randomDuration1;
        int i;
        Random random = new Random(12389L);
        FakeTimeProvider fakeTimeProvider = new FakeTimeProvider();
        Stopwatch stopwatch = new Stopwatch((DoubleSupplier)fakeTimeProvider);
        for (i = 0; i < 10; ++i) {
            stopwatch.start();
            randomDuration1 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration2 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resume();
            randomDuration3 = this.sleep(fakeTimeProvider, this.randomTime(random));
            this.assertTimeEquals(randomDuration1 + randomDuration3, stopwatch.lapElapsed());
            this.assertTimeEquals(randomDuration1 + randomDuration3, stopwatch.totalElapsed());
            this.assertTimeEquals(randomDuration1 + randomDuration3, stopwatch.lap());
        }
        for (i = 0; i < 10; ++i) {
            stopwatch.start();
            randomDuration1 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resume();
            randomDuration2 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration3 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resume();
            randomDuration4 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration5 = this.sleep(fakeTimeProvider, this.randomTime(random));
            double expectedElapsed = randomDuration1 + randomDuration2 + randomDuration4;
            this.assertTimeEquals(expectedElapsed, stopwatch.lapElapsed());
            this.assertTimeEquals(expectedElapsed, stopwatch.totalElapsed());
            this.assertTimeEquals(expectedElapsed, stopwatch.lap());
        }
        for (i = 0; i < 10; ++i) {
            stopwatch.reset();
            randomDuration1 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration2 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resume();
            randomDuration3 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.lap();
            randomDuration4 = this.sleep(fakeTimeProvider, this.randomTime(random));
            this.assertTimeEquals(randomDuration4, stopwatch.lapElapsed());
            this.assertTimeEquals(randomDuration1 + randomDuration3 + randomDuration4, stopwatch.totalElapsed());
            this.assertTimeEquals(randomDuration4, stopwatch.lap());
        }
        for (i = 0; i < 10; ++i) {
            stopwatch.reset();
            randomDuration1 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration2 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resume();
            randomDuration3 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.lap();
            randomDuration4 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration5 = this.sleep(fakeTimeProvider, this.randomTime(random));
            this.assertTimeEquals(randomDuration4, stopwatch.lapElapsed());
            this.assertTimeEquals(randomDuration1 + randomDuration3 + randomDuration4, stopwatch.totalElapsed());
            this.assertTimeEquals(randomDuration4, stopwatch.lap());
        }
        for (i = 0; i < 10; ++i) {
            stopwatch.reset();
            randomDuration1 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration2 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resume();
            randomDuration3 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.lap();
            randomDuration4 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.suspend();
            randomDuration5 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.reset();
            double randomDuration6 = this.sleep(fakeTimeProvider, this.randomTime(random));
            this.assertTimeEquals(randomDuration6, stopwatch.lapElapsed());
            this.assertTimeEquals(randomDuration6, stopwatch.totalElapsed());
            this.assertTimeEquals(randomDuration6, stopwatch.lap());
            stopwatch.suspend();
            double randomDuration7 = this.sleep(fakeTimeProvider, this.randomTime(random));
            stopwatch.resetLap();
            double randomDuration8 = this.sleep(fakeTimeProvider, this.randomTime(random));
            this.assertTimeEquals(randomDuration8, stopwatch.lapElapsed());
            this.assertTimeEquals(randomDuration8 + randomDuration6, stopwatch.totalElapsed());
            this.assertTimeEquals(randomDuration8, stopwatch.lap());
        }
        stopwatch.reset();
        double randomDuration12 = this.randomTime(random);
        double randomDuration22 = this.randomTime(random);
        double randomDuration32 = this.randomTime(random);
        for (int i2 = 0; i2 < 10; ++i2) {
            this.sleep(fakeTimeProvider, randomDuration12);
            stopwatch.suspend();
            this.sleep(fakeTimeProvider, randomDuration22);
            stopwatch.resume();
            this.sleep(fakeTimeProvider, randomDuration32);
            stopwatch.resetLap();
            this.sleep(fakeTimeProvider, randomDuration12);
            stopwatch.suspend();
            this.sleep(fakeTimeProvider, randomDuration12);
            stopwatch.suspend();
            this.sleep(fakeTimeProvider, randomDuration22);
            stopwatch.resume();
            stopwatch.resume();
            this.sleep(fakeTimeProvider, randomDuration32);
            this.assertTimeEquals(randomDuration12 + randomDuration32, stopwatch.lapElapsed());
            stopwatch.lap();
            this.assertTimeEquals((randomDuration12 + randomDuration32) * (double)(i2 + 1), stopwatch.totalElapsed());
        }
    }

    private void assertTimeEquals(double expected, double actual) {
        LogTools.info((String)("Expected: " + expected + " (s)  Actual: " + actual + " (s)"));
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-10, (String)"Expected time incorrect");
        LogTools.info((String)"Assertions passed!");
    }

    private double randomTime(Random random) {
        return Conversions.millisecondsToSeconds((double)(Math.abs(random.nextInt()) % 100));
    }

    private double sleep(FakeTimeProvider fakeTimeProvider, double duration) {
        fakeTimeProvider.incrementClock(duration);
        return duration;
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(Stopwatch.class, StopwatchTest.class);
    }

    public class FakeTimeProvider
    implements DoubleSupplier {
        public double clock = 0.0;

        public void incrementClock(double amount) {
            this.clock += amount;
        }

        @Override
        public double getAsDouble() {
            return this.clock;
        }
    }
}

