/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;

public class ThreadToolsTest {
    @Test
    public void testTimeLimitScheduler() {
        int ITERATIONS = 10;
        double EPSILON = 40.0;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 3L;
        long timeLimit = 300L;
        Runnable runnable = () -> Math.sqrt(Math.PI);
        for (int i = 0; i < 10; ++i) {
            long startTime = System.currentTimeMillis();
            ScheduledFuture future = ThreadTools.scheduleWithFixeDelayAndTimeLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (long)timeLimit, (boolean)true);
            while (!future.isDone()) {
            }
            long endTime = System.currentTimeMillis();
            Assertions.assertEquals((double)timeLimit, (double)(endTime - startTime), (double)40.0);
        }
    }

    @Test
    public void testTimeLimitSchedulerInterrupt() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 3L;
        long timeLimit = 300L;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> {
            counter.incrementAndGet();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LogTools.info((String)"Interrupted!");
            }
        };
        Stopwatch stopwatch2 = new Stopwatch().start();
        ScheduledFuture future = ThreadTools.scheduleWithFixeDelayAndTimeLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (long)timeLimit, (boolean)true);
        while (!future.isDone()) {
        }
        double elapsedMilliseconds = Conversions.secondsToMilliseconds((double)stopwatch2.totalElapsed());
        LogTools.info((String)("elapsedMilliseconds = " + elapsedMilliseconds));
        Assertions.assertEquals((double)300.0, (double)elapsedMilliseconds, (double)30.0);
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    public void testTimeLimitSchedulerGraceful() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 3L;
        long timeLimit = 300L;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> {
            counter.incrementAndGet();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LogTools.info((String)"Interrupted!");
            }
        };
        Stopwatch stopwatch2 = new Stopwatch().start();
        ScheduledFuture future = ThreadTools.scheduleWithFixeDelayAndTimeLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (long)timeLimit, (boolean)false);
        while (!future.isDone()) {
        }
        double elapsedMilliseconds = Conversions.secondsToMilliseconds((double)stopwatch2.totalElapsed());
        LogTools.info((String)("elapsedMilliseconds = " + elapsedMilliseconds));
        Assertions.assertEquals((double)400.0, (double)elapsedMilliseconds, (double)30.0);
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    public void testSingleExecution() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long delay = 100L;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> counter.incrementAndGet();
        ScheduledFuture future = ThreadTools.scheduleSingleExecution((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)delay, (TimeUnit)timeUnit);
        Stopwatch stopwatch = new Stopwatch().start();
        while (!future.isDone()) {
        }
        double elapsedMilliseconds = Conversions.secondsToMilliseconds((double)stopwatch.totalElapsed());
        LogTools.info((String)("elapsedMilliseconds = " + elapsedMilliseconds));
        Assertions.assertEquals((double)100.0, (double)elapsedMilliseconds, (double)10.0);
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void testIterationLimitScheduler() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        long initialDelay = 0L;
        long delay = 10L;
        int iterations = 10;
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = () -> counter.incrementAndGet();
        ScheduledFuture future = ThreadTools.scheduleWithFixedDelayAndIterationLimit((String)this.getClass().getSimpleName(), (Runnable)runnable, (long)initialDelay, (long)delay, (TimeUnit)timeUnit, (int)10);
        while (!future.isDone()) {
        }
        Assertions.assertEquals((int)10, (int)counter.get());
    }

    @Test
    public void testExecuteWithTimeout() {
        final StateHolder holder = new StateHolder();
        for (int i = 0; i < 10; ++i) {
            holder.state = State.DIDNT_RUN;
            ThreadTools.executeWithTimeout((String)"timeoutTest1", (Runnable)new Runnable(){

                @Override
                public void run() {
                    holder.state = State.TIMED_OUT;
                    ThreadTools.sleep((long)10L);
                    holder.state = State.RAN_WITHOUT_TIMING_OUT;
                }
            }, (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assertions.assertFalse((boolean)holder.state.equals((Object)State.DIDNT_RUN), (String)"Didn't run. Should timeout.");
            Assertions.assertTrue((boolean)holder.state.equals((Object)State.TIMED_OUT), (String)"Did not timeout.");
            holder.state = State.DIDNT_RUN;
            ThreadTools.executeWithTimeout((String)"timeoutTest2", (Runnable)new Runnable(){

                @Override
                public void run() {
                    holder.state = State.TIMED_OUT;
                    ThreadTools.sleep((long)5L);
                    holder.state = State.RAN_WITHOUT_TIMING_OUT;
                }
            }, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assertions.assertFalse((boolean)holder.state.equals((Object)State.DIDNT_RUN), (String)"Didn't run. Shouldn't timeout.");
            Assertions.assertTrue((boolean)holder.state.equals((Object)State.RAN_WITHOUT_TIMING_OUT), (String)"Timed out early.");
        }
    }

    @Test
    public void testThreadSleepEvenWhenInterrupted() {
        long ONE_MILLION = 1000000L;
        long millisecondsToSleep = 1100L;
        int additionalNanosecondsToSleep = 500000;
        long totalNanosecondsToSleep = millisecondsToSleep * 1000000L + (long)additionalNanosecondsToSleep;
        SleepAndVerifyDespiteWakingUpRunnable runnable = new SleepAndVerifyDespiteWakingUpRunnable(millisecondsToSleep, additionalNanosecondsToSleep);
        int numberOfTimesToTest = 5;
        for (int i = 0; i < numberOfTimesToTest; ++i) {
            Thread thread = new Thread(runnable);
            thread.start();
            while (!runnable.isDoneSleeping()) {
                thread.interrupt();
                try {
                    Thread.sleep(millisecondsToSleep / 10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            long timeSleptInNanoseconds = runnable.getTimeSleptNanonseconds();
            long timeOverSleptInNanoseconds = timeSleptInNanoseconds - totalNanosecondsToSleep;
            Assertions.assertTrue((timeOverSleptInNanoseconds > 0L ? 1 : 0) != 0, (String)("timeSlept = " + timeSleptInNanoseconds + ", totalNanosecondsToSleep = " + totalNanosecondsToSleep + " timeOverSleptInNanoseconds = " + timeOverSleptInNanoseconds));
            Assertions.assertTrue((timeOverSleptInNanoseconds < 100000000L ? 1 : 0) != 0, (String)("timeSlept = " + timeSleptInNanoseconds + ", millisecondsToSleep = " + millisecondsToSleep));
            runnable = new SleepAndVerifyDespiteWakingUpRunnable(millisecondsToSleep, additionalNanosecondsToSleep);
            thread = new Thread(runnable);
            thread.start();
            while (!runnable.isDoneSleeping()) {
                try {
                    Thread.sleep(millisecondsToSleep / 10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class StateHolder {
        public State state = State.DIDNT_RUN;

        private StateHolder() {
        }
    }

    private static enum State {
        DIDNT_RUN,
        TIMED_OUT,
        RAN_WITHOUT_TIMING_OUT;

    }

    private class SleepAndVerifyDespiteWakingUpRunnable
    implements Runnable {
        private long millisecondsToSleep;
        private int additonalNanosecondsToSleep;
        private boolean isDoneSleeping;
        private long timeSleptNanosecondsMeasuredExternally;

        public SleepAndVerifyDespiteWakingUpRunnable(long millisecondsToSleep, int additonalNanosecondsToSleep) {
            this.millisecondsToSleep = millisecondsToSleep;
            this.additonalNanosecondsToSleep = additonalNanosecondsToSleep;
        }

        public boolean isDoneSleeping() {
            return this.isDoneSleeping;
        }

        public long getTimeSleptNanonseconds() {
            return this.timeSleptNanosecondsMeasuredExternally;
        }

        @Override
        public void run() {
            long startTime = System.nanoTime();
            long timeSleptMeasuredFromMethod = ThreadTools.sleep((long)this.millisecondsToSleep, (int)this.additonalNanosecondsToSleep);
            long endTime = System.nanoTime();
            this.timeSleptNanosecondsMeasuredExternally = endTime - startTime;
            if (this.timeSleptNanosecondsMeasuredExternally < timeSleptMeasuredFromMethod) {
                throw new AssertionError((Object)("Huh: timeSleptNanosecondsMeasuredExternally = " + this.timeSleptNanosecondsMeasuredExternally + ", timeSleptMeasuredFromMethod = " + timeSleptMeasuredFromMethod));
            }
            this.isDoneSleeping = true;
        }
    }
}

