/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.Collections;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.lists.RecyclingArrayDeque;

@Execution(value=ExecutionMode.SAME_THREAD)
public class RecyclingArrayDequeTest {
    @Test
    public void testConstructors() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(MutableInt::new, MutableInt::setValue);
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertTrue((queue.pollLast() == null ? 1 : 0) != 0);
        queue = new RecyclingArrayDeque(MutableInt.class, MutableInt::setValue);
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertTrue((queue.pollLast() == null ? 1 : 0) != 0);
        queue = new RecyclingArrayDeque(10, MutableInt.class, MutableInt::setValue);
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertTrue((queue.pollLast() == null ? 1 : 0) != 0);
        queue = new RecyclingArrayDeque(10, MutableInt::new, MutableInt::setValue);
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertTrue((queue.pollLast() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddFirst() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((queue.size() == 1 ? 1 : 0) != 0);
        ((MutableInt)queue.addLast()).setValue(2);
    }

    @Test
    public void testPollFirst() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addLast()).setValue(1);
        ((MutableInt)queue.addLast()).setValue(2);
        ((MutableInt)queue.addLast()).setValue(3);
        ((MutableInt)queue.addLast()).setValue(4);
        Assertions.assertTrue((queue.size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollFirst()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollFirst()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollFirst()).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollFirst()).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPollLast() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addFirst()).setValue(1);
        ((MutableInt)queue.addLast()).setValue(3);
        ((MutableInt)queue.addLast()).setValue(4);
        Assertions.assertTrue((queue.size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollLast()).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollLast()).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollLast()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollLast()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPeek() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addLast()).setValue(3);
        ((MutableInt)queue.addLast()).setValue(4);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((((MutableInt)queue.peek()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.peek()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollFirst()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.peek()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testPeekFirst() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addLast()).setValue(3);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addLast()).setValue(4);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((((MutableInt)queue.peek()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.peek()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollFirst()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.peek()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testPeekLast() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addFirst()).setValue(4);
        ((MutableInt)queue.addFirst()).setValue(3);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((((MutableInt)queue.peekLast()).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.peekLast()).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.pollLast()).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.peekLast()).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((queue.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveFirst() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addFirst()).setValue(4);
        ((MutableInt)queue.addFirst()).setValue(3);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((((MutableInt)queue.removeFirst()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.removeFirst()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.removeFirst()).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.removeFirst()).getValue() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addFirst()).setValue(4);
        ((MutableInt)queue.addFirst()).setValue(3);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((((MutableInt)queue.remove()).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.remove()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.remove()).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.remove()).getValue() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveLast() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        ((MutableInt)queue.addFirst()).setValue(4);
        ((MutableInt)queue.addFirst()).setValue(3);
        ((MutableInt)queue.addFirst()).setValue(2);
        ((MutableInt)queue.addFirst()).setValue(1);
        Assertions.assertTrue((((MutableInt)queue.removeLast()).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.removeLast()).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.removeLast()).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)queue.removeLast()).getValue() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testUnsupportedMethods() {
        RecyclingArrayDeque queue = new RecyclingArrayDeque(4, MutableInt::new, MutableInt::setValue);
        this.failIfSuccessful(() -> ((RecyclingArrayDeque)queue).clone());
        this.failIfSuccessful(() -> queue.remove((Object)new MutableInt()));
        this.failIfSuccessful(() -> queue.contains((Object)new MutableInt()));
        this.failIfSuccessful(() -> ((RecyclingArrayDeque)queue).iterator());
        this.failIfSuccessful(() -> ((RecyclingArrayDeque)queue).toArray());
        this.failIfSuccessful(() -> {
            MutableInt[] cfr_ignored_0 = (MutableInt[])queue.toArray((Object[])new MutableInt[0]);
        });
        this.failIfSuccessful(() -> queue.containsAll(Collections.emptyList()));
        this.failIfSuccessful(() -> queue.addAll(Collections.emptyList()));
        this.failIfSuccessful(() -> queue.removeAll(Collections.emptyList()));
        this.failIfSuccessful(() -> queue.retainAll(Collections.emptyList()));
        this.failIfSuccessful(() -> queue.removeFirstOccurrence((Object)new MutableInt()));
        this.failIfSuccessful(() -> queue.removeLastOccurrence((Object)new MutableInt()));
        this.failIfSuccessful(() -> queue.offer((Object)new MutableInt()));
        this.failIfSuccessful(() -> ((RecyclingArrayDeque)queue).descendingIterator());
    }

    private void failIfSuccessful(Runnable runnable) {
        try {
            runnable.run();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

