/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.maps;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.tools.maps.CircularLongMap;

public class CircularLongMapTest {
    @Test
    public void testFillingMap() {
        long value;
        int i;
        CircularLongMap map = new CircularLongMap(100);
        for (i = 0; i < 100; ++i) {
            map.insert((long)i, (long)(i * 10));
            Assertions.assertEquals((long)(i * 10), (long)map.getLatestValue());
        }
        for (i = 0; i < 100; ++i) {
            value = map.getValue(false, (long)i);
            Assertions.assertEquals((long)(i * 10), (long)value);
        }
        for (i = 100; i < 150; ++i) {
            map.insert((long)i, (long)(i * 10));
            Assertions.assertEquals((long)(i * 10), (long)map.getLatestValue());
        }
        for (i = 50; i < 150; ++i) {
            value = map.getValue(false, (long)i);
            Assertions.assertEquals((long)(i * 10), (long)value);
        }
    }

    @Test
    public void testMatchNearest() {
        long value;
        int i;
        CircularLongMap map = new CircularLongMap(100);
        for (i = 0; i < 100; ++i) {
            map.insert((long)(i * 10), (long)(i * 50));
        }
        for (i = 0; i < 100; ++i) {
            value = map.getValue(true, (long)(i * 10 + 6));
            Assertions.assertEquals((long)(i * 50), (long)value);
        }
        for (i = 100; i < 150; ++i) {
            map.insert((long)(i * 10), (long)(i * 50));
        }
        for (i = 50; i < 150; ++i) {
            value = map.getValue(true, (long)(i * 10 + 2));
            Assertions.assertEquals((long)(i * 50), (long)value);
        }
    }

    @Test
    public void testEdgeCases() {
        int i;
        CircularLongMap map = new CircularLongMap(100);
        for (int i2 = 4; i2 < 54; ++i2) {
            map.insert((long)i2, (long)(i2 * 10));
        }
        try {
            map.getValue(false, 3L);
            Assertions.fail();
        }
        catch (Exception i2) {
            // empty catch block
        }
        Assertions.assertEquals((long)40L, (long)map.getValue(true, 3L));
        for (i = 54; i < 104; ++i) {
            map.insert((long)i, (long)(i * 10));
        }
        Assertions.assertEquals((long)40L, (long)map.getValue(true, 3L));
        Assertions.assertEquals((long)40L, (long)map.getValue(true, 4L));
        for (i = 105; i < 125; i += 2) {
            map.insert((long)i, (long)(i * 10));
        }
        Assertions.assertEquals((long)140L, (long)map.getValue(true, 13L));
        Assertions.assertEquals((long)140L, (long)map.getValue(true, 14L));
        Assertions.assertEquals((long)150L, (long)map.getValue(true, 15L));
        Assertions.assertEquals((long)1030L, (long)map.getValue(true, 103L));
        Assertions.assertEquals((long)1030L, (long)map.getValue(true, 104L));
        Assertions.assertEquals((long)1050L, (long)map.getValue(true, 105L));
    }
}

