/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.time;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.time.TimeInterval;
import us.ihmc.commons.time.TimeIntervalTools;
import us.ihmc.commons.time.TimedValue;

public class TimeIntervalToolsTest {
    @Test
    public void testSortMethods() {
        int i;
        double epsilon = 1.0E-6;
        int size = 10;
        ArrayList<TimedValue> arrayValues = new ArrayList<TimedValue>(size);
        for (i = 0; i < size; ++i) {
            TimedValue tv = new TimedValue(i, new TimeInterval((double)i, (double)(i + 1)));
            arrayValues.add(tv);
        }
        TimeIntervalTools.sortByReverseStartTime(arrayValues);
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)(size - 1 - i), (double)epsilon);
        }
        TimeIntervalTools.sortByStartTime(arrayValues);
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, (double)epsilon);
        }
        TimeIntervalTools.sortByReverseEndTime(arrayValues);
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)(size - 1 - i), (double)epsilon);
        }
        TimeIntervalTools.sortByEndTime(arrayValues);
        for (i = 0; i < arrayValues.size(); ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, (double)epsilon);
        }
    }

    @Test
    public void testRemoveMethods() {
        int i;
        double epsilon = 1.0E-6;
        int size = 10;
        ArrayList<TimedValue> arrayValues = new ArrayList<TimedValue>(size);
        for (i = 0; i < size; ++i) {
            TimedValue tv = new TimedValue(i, new TimeInterval((double)i, (double)(i + 1)));
            arrayValues.add(tv);
        }
        TimeIntervalTools.removeEndTimesGreaterThan((double)8.5, arrayValues);
        size = 8;
        Assertions.assertEquals((int)arrayValues.size(), (int)size);
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, (double)epsilon);
        }
        TimeIntervalTools.removeStartTimesGreaterThan((double)6.5, arrayValues);
        size = 7;
        Assertions.assertEquals((int)arrayValues.size(), (int)size);
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, (double)epsilon);
        }
        TimeIntervalTools.removeStartTimesLessThan((double)1.5, arrayValues);
        size = 5;
        Assertions.assertEquals((int)arrayValues.size(), (int)size);
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)(i + 2), (double)epsilon);
        }
        TimeIntervalTools.removeEndTimesLessThan((double)6.5, arrayValues);
        Assertions.assertEquals((int)arrayValues.size(), (int)1);
        Assertions.assertEquals((double)((TimedValue)arrayValues.get(0)).getValue(), (double)6.0, (double)epsilon);
    }
}

