/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.Notification;
import us.ihmc.commons.thread.ThreadTools;

public class NotificationTest {
    @Test
    public void testNotified() {
        Notification notification = new Notification();
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.read());
        notification.set();
        Assertions.assertTrue((boolean)notification.poll());
        Assertions.assertTrue((boolean)notification.read());
    }

    @Test
    public void testClear() {
        Notification notification = new Notification();
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.read());
        notification.set();
        Assertions.assertTrue((boolean)notification.poll());
        Assertions.assertTrue((boolean)notification.read());
        notification.set();
        notification.clear();
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.read());
    }

    @Test
    public void testNotifiedBeforeBlockingPollCalled() {
        Notification notification = new Notification();
        notification.set();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> notification.blockingPoll());
        Assertions.assertTrue((boolean)notification.read());
    }

    @Test
    public void testNotificationFromThread() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> {
            Notification notification = new Notification();
            Assertions.assertFalse((boolean)notification.poll());
            Assertions.assertFalse((boolean)notification.read());
            long before = System.nanoTime();
            ThreadTools.startAThread(() -> {
                ThreadTools.sleep((long)200L);
                notification.set();
            }, (String)"SetterThread");
            notification.blockingPoll();
            long after = System.nanoTime();
            Assertions.assertTrue((Conversions.nanosecondsToMilliseconds((long)(after - before)) > 200L ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)notification.read());
        });
    }
}

