/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.lists.PreallocatedList;

public class PreallocatedListTest {
    @Test
    public void testConstructor() {
        PreallocatedList list = new PreallocatedList(Object.class, Object::new, 10);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndGet() {
        int i;
        Object lastObject;
        int i2;
        PreallocatedList list = new PreallocatedList(Object.class, Object::new, 20);
        ArrayList<Object> expectedList = new ArrayList<Object>();
        int finalSize = 10;
        for (i2 = 0; i2 < finalSize; ++i2) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i2 = 0; i2 < finalSize; ++i2) {
            Assertions.assertTrue((list.get(i2) == expectedList.get(i2) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        try {
            list.get(finalSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException i3) {
            // empty catch block
        }
        list.clear();
        expectedList.clear();
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 8;
        for (i = 0; i < finalSize; ++i) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        list.clear();
        expectedList.clear();
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 20;
        for (i = 0; i < finalSize; ++i) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        int i;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, 10);
        int currentSize = 10;
        while (list.size() < currentSize) {
            ((MutableInt)list.add()).setValue(10 + list.size());
        }
        ArrayList<Object> expectedList = new ArrayList<Object>();
        for (int i2 = 0; i2 < currentSize; ++i2) {
            expectedList.add(list.get(i2));
        }
        int indexOfRemovedObject = 3;
        list.remove(indexOfRemovedObject);
        expectedList.remove(indexOfRemovedObject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        indexOfRemovedObject = currentSize - 1;
        list.remove(indexOfRemovedObject);
        expectedList.remove(indexOfRemovedObject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        try {
            list.remove(currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSwap() {
        Random rand = new Random(541964L);
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, 10);
        int currentSize = 10;
        while (list.size() < currentSize) {
            ((MutableInt)list.add()).setValue(10 + list.size());
        }
        ArrayList<Object> expectedList = new ArrayList<Object>();
        for (int i = 0; i < currentSize; ++i) {
            expectedList.add(list.get(i));
        }
        for (int k = 0; k < 20; ++k) {
            int indexA = rand.nextInt(currentSize);
            int indexB = rand.nextInt(currentSize);
            list.swap(indexA, indexB);
            Collections.swap(expectedList, indexA, indexB);
            Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
            for (int i = 0; i < currentSize; ++i) {
                Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
            }
        }
        try {
            list.swap(0, currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.swap(currentSize, 0);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSort() {
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, 10);
        ((MutableInt)list.add()).setValue(-3);
        ((MutableInt)list.add()).setValue(20);
        ((MutableInt)list.add()).setValue(-10);
        ((MutableInt)list.add()).setValue(19);
        ((MutableInt)list.add()).setValue(50);
        list.sort(MutableInt::compareTo);
        Assertions.assertTrue((((MutableInt)list.get(0)).getValue() == -10 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(1)).getValue() == -3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(2)).getValue() == 19 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(3)).getValue() == 20 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(4)).getValue() == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveIndex() {
        int size = 10;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        Assertions.assertTrue((((MutableInt)list.remove(8)).getValue() == 8 ? 1 : 0) != 0);
        Assertions.assertTrue((list.size() == size - 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.remove(4)).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((list.size() == size - 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.remove(2)).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((list.size() == size - 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.remove(size - 4)).getValue() == size - 1 ? 1 : 0) != 0);
        Assertions.assertTrue((list.size() == size - 4 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveObject() {
        int size = 5;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        ((MutableInt)list.get(0)).setValue(size - 1);
        Assertions.assertTrue((boolean)list.remove((Object)new MutableInt(4)));
        Assertions.assertTrue((list.size() == size - 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)list.remove((Object)new MutableInt(2)));
        Assertions.assertTrue((list.size() == size - 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(0)).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(1)).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(2)).getValue() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAll() {
        int size = 5;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        HashSet<MutableInt> elementsToRemove = new HashSet<MutableInt>();
        elementsToRemove.add(new MutableInt(1));
        elementsToRemove.add(new MutableInt(3));
        list.removeAll(elementsToRemove);
        Assertions.assertTrue((((MutableInt)list.get(0)).getValue() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(1)).getValue() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(2)).getValue() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((list.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRetainAll() {
        int size = 5;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        HashSet<MutableInt> elementsToRemove = new HashSet<MutableInt>();
        elementsToRemove.add(new MutableInt(1));
        elementsToRemove.add(new MutableInt(3));
        list.retainAll(elementsToRemove);
        Assertions.assertTrue((((MutableInt)list.get(0)).getValue() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((MutableInt)list.get(1)).getValue() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((list.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testIndexOf() {
        int i;
        int size = 10;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i % (size / 2));
        }
        for (i = 0; i < size / 2; ++i) {
            Assertions.assertTrue((list.indexOf((Object)new MutableInt(i)) == i ? 1 : 0) != 0);
        }
        for (i = 0; i < size / 2; ++i) {
            Assertions.assertTrue((list.lastIndexOf((Object)new MutableInt(i)) == i + size / 2 ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.indexOf((Object)new MutableInt(398)) == -1 ? 1 : 0) != 0);
        Assertions.assertTrue((list.lastIndexOf((Object)new MutableInt(398)) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testContains() {
        int i;
        int size = 5;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        for (i = 0; i < list.size(); ++i) {
            Assertions.assertTrue((boolean)list.contains((Object)new MutableInt(i)));
        }
        Assertions.assertFalse((boolean)list.contains((Object)new MutableInt(size)));
        Assertions.assertFalse((boolean)list.contains((Object)new MutableInt(-1)));
        Assertions.assertFalse((boolean)list.contains((Object)new MutableInt(-559038737)));
    }

    @Test
    public void testContainsAll() {
        int size = 5;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        HashSet<MutableInt> elements = new HashSet<MutableInt>();
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
            elements.add(new MutableInt(i));
        }
        Assertions.assertTrue((boolean)list.containsAll(elements));
        elements.add(new MutableInt(size));
        Assertions.assertFalse((boolean)list.containsAll(elements));
        elements.remove(new MutableInt(size));
        elements.remove(new MutableInt(1));
        Assertions.assertTrue((boolean)list.containsAll(elements));
    }

    @Test
    public void testUnsupportedOperations() {
        int size = 5;
        PreallocatedList list = new PreallocatedList(MutableInt.class, MutableInt::new, size);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        try {
            list.set(0, (Object)new MutableInt());
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.add((Object)new MutableInt());
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.add(0, (Object)new MutableInt());
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.addAll(new HashSet());
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.replaceAll(UnaryOperator.identity());
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.iterator();
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.listIterator();
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.listIterator(0);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.subList(0, 1);
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

