/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.lists.ListWrappingIndexTools;

public class ListWrappingIndexToolsTest {
    @Test
    public void testWrap() {
        Random random = new Random(234223L);
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index;
            int listSize = 1 + random.nextInt(20);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < listSize; ++i) {
                list.add(new Object());
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)index, (int)ListWrappingIndexTools.wrap((int)index, list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)index, (int)ListWrappingIndexTools.wrap((int)(index - listSize), list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)index, (int)ListWrappingIndexTools.wrap((int)(index + listSize), list));
            }
        }
    }

    @Test
    public void testNext() {
        Random random = new Random(234223L);
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index;
            int listSize = 1 + random.nextInt(20);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < listSize; ++i) {
                list.add(new Object());
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)ListWrappingIndexTools.wrap((int)(index + 1), list), (int)ListWrappingIndexTools.next((int)index, list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)ListWrappingIndexTools.wrap((int)(index + 1), list), (int)ListWrappingIndexTools.next((int)(index - listSize), list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)ListWrappingIndexTools.wrap((int)(index + 1), list), (int)ListWrappingIndexTools.next((int)(index + listSize), list));
            }
        }
    }

    @Test
    public void testDecrement() {
        Random random = new Random(234223L);
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index;
            int listSize = 1 + random.nextInt(20);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < listSize; ++i) {
                list.add(new Object());
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)ListWrappingIndexTools.wrap((int)(index - 1), list), (int)ListWrappingIndexTools.previous((int)index, list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)ListWrappingIndexTools.wrap((int)(index - 1), list), (int)ListWrappingIndexTools.previous((int)(index - listSize), list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals((int)ListWrappingIndexTools.wrap((int)(index - 1), list), (int)ListWrappingIndexTools.previous((int)(index + listSize), list));
            }
        }
    }

    @Test
    public void testGetWrap() {
        Random random = new Random(234223L);
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index;
            int listSize = 1 + random.nextInt(20);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < listSize; ++i) {
                list.add(new Object());
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(index), (Object)ListWrappingIndexTools.getWrap((int)index, list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(index), (Object)ListWrappingIndexTools.getWrap((int)(index - listSize), list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(index), (Object)ListWrappingIndexTools.getWrap((int)(index + listSize), list));
            }
        }
    }

    @Test
    public void testGetNextWrap() {
        Random random = new Random(234223L);
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index;
            int listSize = 1 + random.nextInt(20);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < listSize; ++i) {
                list.add(new Object());
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(ListWrappingIndexTools.next((int)index, list)), (Object)ListWrappingIndexTools.getNext((int)index, list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(ListWrappingIndexTools.next((int)index, list)), (Object)ListWrappingIndexTools.getNext((int)(index - listSize), list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(ListWrappingIndexTools.next((int)index, list)), (Object)ListWrappingIndexTools.getNext((int)(index + listSize), list));
            }
        }
    }

    @Test
    public void testGetPreviousWrap() {
        Random random = new Random(234223L);
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index;
            int listSize = 1 + random.nextInt(20);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < listSize; ++i) {
                list.add(new Object());
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(ListWrappingIndexTools.previous((int)index, list)), (Object)ListWrappingIndexTools.getPrevious((int)index, list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(ListWrappingIndexTools.previous((int)index, list)), (Object)ListWrappingIndexTools.getPrevious((int)(index - listSize), list));
            }
            for (index = 0; index < listSize; ++index) {
                Assertions.assertEquals(list.get(ListWrappingIndexTools.previous((int)index, list)), (Object)ListWrappingIndexTools.getPrevious((int)(index + listSize), list));
            }
        }
    }

    @Test
    public void testSubLengthInclusive() {
        int endIndex;
        int startIndex;
        int index;
        int listSize = 20;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < listSize; ++i) {
            list.add(new Object());
        }
        for (index = 0; index < listSize; ++index) {
            Assertions.assertEquals((int)1, (int)ListWrappingIndexTools.subLengthInclusive((int)index, (int)index, list));
        }
        for (index = 0; index < listSize; ++index) {
            startIndex = index;
            endIndex = index + listSize - 1;
            Assertions.assertEquals((int)listSize, (int)ListWrappingIndexTools.subLengthInclusive((int)startIndex, (int)endIndex, list));
            Assertions.assertEquals((int)listSize, (int)ListWrappingIndexTools.subLengthInclusive((int)startIndex, (int)ListWrappingIndexTools.wrap((int)endIndex, list), list));
        }
        for (index = 0; index < listSize; ++index) {
            startIndex = index;
            endIndex = index + listSize / 2 - 1;
            Assertions.assertEquals((int)(listSize / 2), (int)ListWrappingIndexTools.subLengthInclusive((int)startIndex, (int)endIndex, list));
            Assertions.assertEquals((int)(listSize / 2), (int)ListWrappingIndexTools.subLengthInclusive((int)startIndex, (int)ListWrappingIndexTools.wrap((int)endIndex, list), list));
        }
    }

    @Test
    public void testSubLengthExclusive() {
        int endIndex;
        int startIndex;
        int index;
        int listSize = 20;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < listSize; ++i) {
            list.add(new Object());
        }
        for (index = 0; index < listSize; ++index) {
            Assertions.assertEquals((int)0, (int)ListWrappingIndexTools.subLengthExclusive((int)index, (int)index, list));
        }
        for (index = 0; index < listSize; ++index) {
            startIndex = index;
            endIndex = index + listSize + 1;
            Assertions.assertEquals((int)listSize, (int)ListWrappingIndexTools.subLengthExclusive((int)startIndex, (int)endIndex, list));
        }
        for (index = 0; index < listSize; ++index) {
            startIndex = index;
            endIndex = index + listSize / 2 + 1;
            Assertions.assertEquals((int)(listSize / 2), (int)ListWrappingIndexTools.subLengthExclusive((int)startIndex, (int)endIndex, list));
            Assertions.assertEquals((int)(listSize / 2), (int)ListWrappingIndexTools.subLengthExclusive((int)startIndex, (int)ListWrappingIndexTools.wrap((int)endIndex, list), list));
        }
    }

    @Test
    public void testSubListInclusive() {
        int i;
        List subListInclusive;
        int endIndex;
        int index;
        int listSize = 20;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i2 = 0; i2 < listSize; ++i2) {
            list.add(new Object());
        }
        for (index = 0; index < listSize; ++index) {
            List subListInclusive2 = ListWrappingIndexTools.subListInclusive((int)index, (int)index, list);
            Assertions.assertEquals((int)1, (int)subListInclusive2.size());
            Assertions.assertEquals(list.get(index), subListInclusive2.get(0));
        }
        for (index = 0; index < listSize; ++index) {
            int startIndex = index;
            endIndex = index + listSize - 1;
            subListInclusive = ListWrappingIndexTools.subListInclusive((int)startIndex, (int)endIndex, list);
            Assertions.assertEquals((int)ListWrappingIndexTools.subLengthInclusive((int)startIndex, (int)endIndex, list), (int)subListInclusive.size());
            for (i = startIndex; i <= endIndex; ++i) {
                Assertions.assertEquals((Object)ListWrappingIndexTools.getWrap((int)i, list), subListInclusive.get(i - startIndex));
            }
        }
        for (index = 0; index < listSize; ++index) {
            int startIndex = index;
            endIndex = index + listSize / 2 - 1;
            subListInclusive = ListWrappingIndexTools.subListInclusive((int)startIndex, (int)endIndex, list);
            Assertions.assertEquals((int)ListWrappingIndexTools.subLengthInclusive((int)startIndex, (int)endIndex, list), (int)subListInclusive.size());
            for (i = startIndex; i <= endIndex; ++i) {
                Assertions.assertEquals((Object)ListWrappingIndexTools.getWrap((int)i, list), subListInclusive.get(i - startIndex));
            }
        }
    }

    @Test
    public void testSubListExclusive() {
        int i;
        List subListExclusive;
        int endIndex;
        int index;
        int listSize = 20;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i2 = 0; i2 < listSize; ++i2) {
            list.add(new Object());
        }
        for (index = 0; index < listSize; ++index) {
            List subListExclusive2 = ListWrappingIndexTools.subListExclusive((int)index, (int)index, list);
            Assertions.assertEquals((int)0, (int)subListExclusive2.size());
        }
        for (index = 0; index < listSize; ++index) {
            int startIndex = index;
            endIndex = index + listSize + 1;
            subListExclusive = ListWrappingIndexTools.subListExclusive((int)startIndex, (int)endIndex, list);
            Assertions.assertEquals((int)ListWrappingIndexTools.subLengthExclusive((int)startIndex, (int)endIndex, list), (int)subListExclusive.size());
            for (i = startIndex + 1; i < endIndex; ++i) {
                Assertions.assertEquals((Object)ListWrappingIndexTools.getWrap((int)i, list), subListExclusive.get(i - startIndex - 1));
            }
        }
        for (index = 0; index < listSize; ++index) {
            int startIndex = index;
            endIndex = index + listSize / 2 - 1;
            subListExclusive = ListWrappingIndexTools.subListExclusive((int)startIndex, (int)endIndex, list);
            Assertions.assertEquals((int)ListWrappingIndexTools.subLengthExclusive((int)startIndex, (int)endIndex, list), (int)subListExclusive.size());
            for (i = startIndex + 1; i < endIndex; ++i) {
                Assertions.assertEquals((Object)ListWrappingIndexTools.getWrap((int)i, list), subListExclusive.get(i - startIndex - 1));
            }
        }
    }

    @Test
    public void testRemoveAllInclusive() {
        int i;
        Random random = new Random(453L);
        List<Object> list = ListWrappingIndexToolsTest.createList(9, random);
        ArrayList<Object> listBackup = new ArrayList<Object>(list);
        int from = 8;
        int to = 1;
        int n = ListWrappingIndexTools.removeAllInclusive((int)from, (int)to, list);
        Assertions.assertEquals((int)3, (int)n);
        Assertions.assertEquals((int)6, (int)list.size());
        int index = 0;
        for (i = to + 1; i < from; ++i) {
            Assertions.assertEquals(listBackup.get(i), (Object)list.get(index++));
        }
        list = ListWrappingIndexToolsTest.createList(12, random);
        listBackup = new ArrayList<Object>(list);
        from = 11;
        to = 3;
        n = ListWrappingIndexTools.removeAllInclusive((int)from, (int)to, list);
        Assertions.assertEquals((int)5, (int)n);
        Assertions.assertEquals((int)7, (int)list.size());
        index = 0;
        for (i = to + 1; i < from; ++i) {
            Assertions.assertEquals(listBackup.get(i), (Object)list.get(index++));
        }
        list = ListWrappingIndexToolsTest.createList(20, random);
        listBackup = new ArrayList<Object>(list);
        from = 11;
        to = 18;
        n = ListWrappingIndexTools.removeAllInclusive((int)from, (int)to, list);
        Assertions.assertEquals((int)8, (int)n);
        Assertions.assertEquals((int)12, (int)list.size());
        index = 0;
        for (i = to + 1; i < from; ++i) {
            Assertions.assertEquals(listBackup.get(i), (Object)list.get(index++));
        }
    }

    @Test
    public void testRemoveAllExclusive() {
        int i;
        Random random = new Random(453L);
        List<Object> list = ListWrappingIndexToolsTest.createList(9, random);
        ArrayList<Object> listBackup = new ArrayList<Object>(list);
        int from = 8;
        int to = 1;
        int n = ListWrappingIndexTools.removeAllExclusive((int)from, (int)to, list);
        Assertions.assertEquals((int)1, (int)n);
        Assertions.assertEquals((int)8, (int)list.size());
        int index = 0;
        for (i = to; i <= from; ++i) {
            Assertions.assertEquals(listBackup.get(i), (Object)list.get(index++));
        }
        list = ListWrappingIndexToolsTest.createList(12, random);
        listBackup = new ArrayList<Object>(list);
        from = 11;
        to = 3;
        n = ListWrappingIndexTools.removeAllExclusive((int)from, (int)to, list);
        Assertions.assertEquals((int)3, (int)n);
        Assertions.assertEquals((int)9, (int)list.size());
        index = 0;
        for (i = to; i <= from; ++i) {
            Assertions.assertEquals(listBackup.get(i), (Object)list.get(index++));
        }
        list = ListWrappingIndexToolsTest.createList(20, random);
        listBackup = new ArrayList<Object>(list);
        from = 11;
        to = 18;
        n = ListWrappingIndexTools.removeAllExclusive((int)from, (int)to, list);
        Assertions.assertEquals((int)6, (int)n);
        Assertions.assertEquals((int)14, (int)list.size());
        index = 0;
        for (i = to; i <= from; ++i) {
            Assertions.assertEquals(listBackup.get(i), (Object)list.get(index++));
        }
    }

    private static List<Object> createList(int size, Random random) {
        ArrayList<Object> ret = new ArrayList<Object>();
        while (ret.size() < size) {
            ret.add(new Object());
        }
        return ret;
    }

    public static void main(String[] args) throws URISyntaxException, IOException {
        MutationTestFacilitator.facilitateMutationTestForClass(ListWrappingIndexTools.class, ListWrappingIndexToolsTest.class);
    }
}

