/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class RotationMatrixConversion {
    public static final double EPS = 1.0E-12;

    private RotationMatrixConversion() {
    }

    public static void computeYawMatrix(double yaw, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.isAngleZero(yaw, 1.0E-12)) {
            matrixToPack.setIdentity();
        } else {
            double sinYaw = EuclidCoreTools.sin(yaw);
            double cosYaw = EuclidCoreTools.cos(yaw);
            if (matrixToPack instanceof RotationMatrixBasics) {
                ((RotationMatrixBasics)matrixToPack).setUnsafe(cosYaw, -sinYaw, 0.0, sinYaw, cosYaw, 0.0, 0.0, 0.0, 1.0);
            } else {
                matrixToPack.set(cosYaw, -sinYaw, 0.0, sinYaw, cosYaw, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public static void computePitchMatrix(double pitch, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.isAngleZero(pitch, 1.0E-12)) {
            matrixToPack.setIdentity();
        } else {
            double sinPitch = EuclidCoreTools.sin(pitch);
            double cosPitch = EuclidCoreTools.cos(pitch);
            if (matrixToPack instanceof RotationMatrixBasics) {
                ((RotationMatrixBasics)matrixToPack).setUnsafe(cosPitch, 0.0, sinPitch, 0.0, 1.0, 0.0, -sinPitch, 0.0, cosPitch);
            } else {
                matrixToPack.set(cosPitch, 0.0, sinPitch, 0.0, 1.0, 0.0, -sinPitch, 0.0, cosPitch);
            }
        }
    }

    public static void computeRollMatrix(double roll, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.isAngleZero(roll, 1.0E-12)) {
            matrixToPack.setIdentity();
        } else {
            double sinRoll = EuclidCoreTools.sin(roll);
            double cosRoll = EuclidCoreTools.cos(roll);
            if (matrixToPack instanceof RotationMatrixBasics) {
                ((RotationMatrixBasics)matrixToPack).setUnsafe(1.0, 0.0, 0.0, 0.0, cosRoll, -sinRoll, 0.0, sinRoll, cosRoll);
            } else {
                matrixToPack.set(1.0, 0.0, 0.0, 0.0, cosRoll, -sinRoll, 0.0, sinRoll, cosRoll);
            }
        }
    }

    public static void convertAxisAngleToMatrix(AxisAngleReadOnly axisAngle, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixConversion.convertAxisAngleToMatrix(axisAngle.getX(), axisAngle.getY(), axisAngle.getZ(), axisAngle.getAngle(), matrixToPack);
    }

    public static void convertAxisAngleToMatrix(double ux, double uy, double uz, double angle, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.containsNaN(ux, uy, uz, angle)) {
            matrixToPack.setToNaN();
            return;
        }
        if (EuclidCoreTools.isAngleZero(angle, 1.0E-12)) {
            matrixToPack.setIdentity();
            return;
        }
        double uNorm = EuclidCoreTools.fastNorm(ux, uy, uz);
        if (uNorm < 1.0E-12) {
            matrixToPack.setIdentity();
        } else {
            uNorm = 1.0 / uNorm;
            double ax = ux * uNorm;
            double ay = uy * uNorm;
            double az = uz * uNorm;
            double sinTheta = EuclidCoreTools.sin(angle);
            double cosTheta = EuclidCoreTools.cos(angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            double m00 = t * ax * ax + cosTheta;
            double m01 = t * xy - sinTheta * az;
            double m02 = t * xz + sinTheta * ay;
            double m10 = t * xy + sinTheta * az;
            double m11 = t * ay * ay + cosTheta;
            double m12 = t * yz - sinTheta * ax;
            double m20 = t * xz - sinTheta * ay;
            double m21 = t * yz + sinTheta * ax;
            double m22 = t * az * az + cosTheta;
            if (matrixToPack instanceof RotationMatrixBasics) {
                ((RotationMatrixBasics)matrixToPack).setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            } else {
                matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
        }
    }

    public static void convertQuaternionToMatrix(QuaternionReadOnly quaternion, CommonMatrix3DBasics matrixToPack) {
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        RotationMatrixConversion.convertQuaternionToMatrix(qx, qy, qz, qs, matrixToPack);
    }

    public static void convertQuaternionToMatrix(double qx, double qy, double qz, double qs, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.containsNaN(qx, qy, qz, qs)) {
            matrixToPack.setToNaN();
            return;
        }
        if (QuaternionTools.isNeutralQuaternion(qx, qy, qz, qs, 1.0E-12)) {
            matrixToPack.setIdentity();
            return;
        }
        double norm = EuclidCoreTools.fastNorm(qx, qy, qz, qs);
        if (norm < 1.0E-12) {
            matrixToPack.setIdentity();
            return;
        }
        norm = 1.0 / norm;
        double yy2 = 2.0 * (qy *= norm) * qy;
        double zz2 = 2.0 * (qz *= norm) * qz;
        double xx2 = 2.0 * (qx *= norm) * qx;
        double xy2 = 2.0 * qx * qy;
        double sz2 = 2.0 * (qs *= norm) * qz;
        double xz2 = 2.0 * qx * qz;
        double sy2 = 2.0 * qs * qy;
        double yz2 = 2.0 * qy * qz;
        double sx2 = 2.0 * qs * qx;
        double m00 = 1.0 - yy2 - zz2;
        double m01 = xy2 - sz2;
        double m02 = xz2 + sy2;
        double m10 = xy2 + sz2;
        double m11 = 1.0 - xx2 - zz2;
        double m12 = yz2 - sx2;
        double m20 = xz2 - sy2;
        double m21 = yz2 + sx2;
        double m22 = 1.0 - xx2 - yy2;
        if (matrixToPack instanceof RotationMatrixBasics) {
            ((RotationMatrixBasics)matrixToPack).setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        } else {
            matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }
    }

    public static void convertYawPitchRollToMatrix(YawPitchRollReadOnly yawPitchRoll, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixConversion.convertYawPitchRollToMatrix(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), matrixToPack);
    }

    public static void convertYawPitchRollToMatrix(double yaw, double pitch, double roll, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            matrixToPack.setToNaN();
            return;
        }
        if (YawPitchRollTools.isZero(yaw, pitch, roll, 1.0E-12)) {
            matrixToPack.setIdentity();
            return;
        }
        double cosc = EuclidCoreTools.cos(yaw);
        double sinc = EuclidCoreTools.sin(yaw);
        double cosb = EuclidCoreTools.cos(pitch);
        double sinb = EuclidCoreTools.sin(pitch);
        double cosa = EuclidCoreTools.cos(roll);
        double sina = EuclidCoreTools.sin(roll);
        double m00 = cosc * cosb;
        double m01 = cosc * sinb * sina - sinc * cosa;
        double m02 = cosc * sinb * cosa + sinc * sina;
        double m10 = sinc * cosb;
        double m11 = sinc * sinb * sina + cosc * cosa;
        double m12 = sinc * sinb * cosa - cosc * sina;
        double m20 = -sinb;
        double m21 = cosb * sina;
        double m22 = cosb * cosa;
        if (matrixToPack instanceof RotationMatrixBasics) {
            ((RotationMatrixBasics)matrixToPack).setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        } else {
            matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }
    }

    public static void convertRotationVectorToMatrix(Vector3DReadOnly rotationVector, CommonMatrix3DBasics matrixToPack) {
        RotationMatrixConversion.convertRotationVectorToMatrix(rotationVector.getX(), rotationVector.getY(), rotationVector.getZ(), matrixToPack);
    }

    public static void convertRotationVectorToMatrix(double rx, double ry, double rz, CommonMatrix3DBasics matrixToPack) {
        if (EuclidCoreTools.containsNaN(rx, ry, rz)) {
            matrixToPack.setToNaN();
            return;
        }
        double norm = EuclidCoreTools.norm(rx, ry, rz);
        if (EuclidCoreTools.isAngleZero(norm, 1.0E-12)) {
            matrixToPack.setIdentity();
        } else {
            double sinTheta = EuclidCoreTools.sin(norm);
            double cosTheta = EuclidCoreTools.cos(norm);
            double t = 1.0 - cosTheta;
            norm = 1.0 / norm;
            double ax = rx * norm;
            double ay = ry * norm;
            double az = rz * norm;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            double m00 = t * ax * ax + cosTheta;
            double m01 = t * xy - sinTheta * az;
            double m02 = t * xz + sinTheta * ay;
            double m10 = t * xy + sinTheta * az;
            double m11 = t * ay * ay + cosTheta;
            double m12 = t * yz - sinTheta * ax;
            double m20 = t * xz - sinTheta * ay;
            double m21 = t * yz + sinTheta * ax;
            double m22 = t * az * az + cosTheta;
            if (matrixToPack instanceof RotationMatrixBasics) {
                ((RotationMatrixBasics)matrixToPack).setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            } else {
                matrixToPack.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }
        }
    }
}

