/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Orientation2DReadOnly
extends EuclidGeometry {
    public double getYaw();

    default public boolean containsNaN() {
        return Double.isNaN(this.getYaw());
    }

    default public double difference(Orientation2DReadOnly other) {
        return EuclidCoreTools.angleDifferenceMinusPiToPi(this.getYaw(), other.getYaw());
    }

    default public double distance(Orientation2DReadOnly other) {
        return Math.abs(this.difference(other));
    }

    default public void transform(Tuple2DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public void transform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple2DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(-this.getYaw(), tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        RotationMatrixTools.applyYawRotation(-this.getYaw(), tupleOriginal, tupleTransformed);
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Orientation2DReadOnly)) {
            return false;
        }
        Orientation2DReadOnly other = (Orientation2DReadOnly)geometry;
        return EuclidCoreTools.epsilonEquals(this.getYaw(), other.getYaw(), epsilon);
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Orientation2DReadOnly)) {
            return false;
        }
        Orientation2DReadOnly other = (Orientation2DReadOnly)geometry;
        return Math.abs(this.difference(other)) <= epsilon;
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Orientation2DReadOnly)) {
            return false;
        }
        Orientation2DReadOnly other = (Orientation2DReadOnly)geometry;
        return EuclidCoreTools.equals(this.getYaw(), other.getYaw());
    }

    @Override
    default public String toString(String format) {
        return EuclidCoreIOTools.getOrientation2DString(format, this);
    }
}

