/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidCoreTestTools {
    public static final String DEFAULT_FORMAT = EuclidCoreIOTools.getStringFormat(15, 12);

    private EuclidCoreTestTools() {
    }

    public static void assertEquals(EuclidGeometry expected, EuclidGeometry actual, double epsilon) {
        EuclidCoreTestTools.assertEquals(null, expected, actual, epsilon);
    }

    public static void assertEquals(String messagePrefix, EuclidGeometry expected, EuclidGeometry actual, double epsilon) {
        EuclidCoreTestTools.assertEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEquals(String messagePrefix, EuclidGeometry expected, EuclidGeometry actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertGeometricallyEquals(EuclidGeometry expected, EuclidGeometry actual, double epsilon) {
        EuclidCoreTestTools.assertGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertGeometricallyEquals(String messagePrefix, EuclidGeometry expected, EuclidGeometry actual, double epsilon) {
        EuclidCoreTestTools.assertGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertGeometricallyEquals(String messagePrefix, EuclidGeometry expected, EuclidGeometry actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertAngleEquals(double expected, double actual, double epsilon) {
        EuclidCoreTestTools.assertAngleEquals(null, expected, actual, epsilon);
    }

    public static void assertAngleEquals(String messagePrefix, double expected, double actual, double epsilon) {
        double differenceAngle = Math.abs(expected - actual);
        if (Math.abs(differenceAngle = (differenceAngle + Math.PI) % (Math.PI * 2) - Math.PI) > epsilon) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, Double.toString(expected), Double.toString(actual));
        }
    }

    public static void assertYawPitchRollGeometricallyEquals(YawPitchRollReadOnly expected, YawPitchRollReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals(expected, actual, epsilon);
    }

    public static void assertRotationVectorGeometricallyEquals(Vector3DReadOnly expected, Vector3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertRotationVectorGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertRotationVectorGeometricallyEquals(String messagePrefix, Vector3DReadOnly expected, Vector3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertRotationVectorGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertRotationVectorGeometricallyEquals(String messagePrefix, Vector3DReadOnly expected, Vector3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        Quaternion expectedQuaternion = new Quaternion(expected);
        Quaternion actualQuaternion = new Quaternion(actual);
        try {
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals(expectedQuaternion, actualQuaternion, epsilon);
        }
        catch (AssertionError e) {
            double difference = expectedQuaternion.distance(actualQuaternion);
            difference = Math.abs(EuclidCoreTools.trimAngleMinusPiToPi(difference));
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(difference), format);
        }
    }

    public static void assertPoint2DGeometricallyEquals(Point2DReadOnly expected, Point2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertPoint2DGeometricallyEquals(String messagePrefix, Point2DReadOnly expected, Point2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPoint2DGeometricallyEquals(String messagePrefix, Point2DReadOnly expected, Point2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(expected.distance(actual)), format);
        }
    }

    public static void assertVector2DGeometricallyEquals(Vector2DReadOnly expected, Vector2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertVector2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertVector2DGeometricallyEquals(String messagePrefix, Vector2DReadOnly expected, Vector2DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertVector2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertVector2DGeometricallyEquals(String messagePrefix, Vector2DReadOnly expected, Vector2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            Vector2D difference = new Vector2D(actual);
            difference.sub(expected);
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(difference.norm()), format);
        }
    }

    public static void assertPoint3DGeometricallyEquals(Point3DReadOnly expected, Point3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertPoint3DGeometricallyEquals(String messagePrefix, Point3DReadOnly expected, Point3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertPoint3DGeometricallyEquals(String messagePrefix, Point3DReadOnly expected, Point3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(expected.distance(actual)), format);
        }
    }

    public static void assertVector3DGeometricallyEquals(Vector3DReadOnly expected, Vector3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertVector3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertVector3DGeometricallyEquals(String messagePrefix, Vector3DReadOnly expected, Vector3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertVector3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertVector3DGeometricallyEquals(String messagePrefix, Vector3DReadOnly expected, Vector3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            Vector3D difference = new Vector3D(actual);
            difference.sub(expected);
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(difference.norm()), format);
        }
    }

    public static void assertVector4DGeometricallyEquals(Vector4DReadOnly expected, Vector4DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertVector4DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertVector4DGeometricallyEquals(String messagePrefix, Vector4DReadOnly expected, Vector4DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertVector4DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertVector4DGeometricallyEquals(String messagePrefix, Vector4DReadOnly expected, Vector4DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            Vector4D difference = new Vector4D(actual);
            difference.sub(expected);
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(difference.norm()), format);
        }
    }

    public static void assertMatrix3DEquals(Matrix3DReadOnly expected, Matrix3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertMatrix3DEquals(null, expected, actual, epsilon);
    }

    public static void assertMatrix3DEquals(String messagePrefix, Matrix3DReadOnly expected, Matrix3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertMatrix3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertMatrix3DEquals(String messagePrefix, Matrix3DReadOnly expected, Matrix3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!Matrix3DFeatures.epsilonEquals(expected, actual, epsilon)) {
            Matrix3D difference = new Matrix3D();
            difference.sub(expected, actual);
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Max difference of: " + Double.toString(difference.maxAbsElement()), format);
        }
    }

    public static void assertSkewSymmetric(Matrix3DReadOnly matrixToAssert, double epsilon) {
        EuclidCoreTestTools.assertSkewSymmetric(null, matrixToAssert, epsilon);
    }

    public static void assertSkewSymmetric(String messagePrefix, Matrix3DReadOnly matrixToAssert, double epsilon) {
        EuclidCoreTestTools.assertSkewSymmetric(messagePrefix, matrixToAssert, epsilon, DEFAULT_FORMAT);
    }

    public static void assertSkewSymmetric(String messagePrefix, Matrix3DReadOnly matrixToAssert, double epsilon, String format) {
        if (matrixToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given matrix is null."));
        }
        if (!matrixToAssert.isMatrixSkewSymmetric(epsilon)) {
            String errorMessage = "The matrix is not skew-symmetric:\n" + EuclidCoreIOTools.getMatrix3DString(DEFAULT_FORMAT, matrixToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertRotationMatrix(Matrix3DReadOnly matrixToAssert, double epsilon) {
        EuclidCoreTestTools.assertRotationMatrix(null, matrixToAssert, epsilon);
    }

    public static void assertRotationMatrix(String messagePrefix, Matrix3DReadOnly matrixToAssert, double epsilon) {
        EuclidCoreTestTools.assertRotationMatrix(messagePrefix, matrixToAssert, epsilon, DEFAULT_FORMAT);
    }

    public static void assertRotationMatrix(String messagePrefix, Matrix3DReadOnly matrixToAssert, double epsilon, String format) {
        if (matrixToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given matrix is null."));
        }
        if (!matrixToAssert.isRotationMatrix(epsilon)) {
            String errorMessage = "This is not a rotation matrix:\n" + EuclidCoreIOTools.getMatrix3DString(format, matrixToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertIdentity(Matrix3DReadOnly matrixToAssert, double epsilon) {
        EuclidCoreTestTools.assertIdentity(null, matrixToAssert, epsilon);
    }

    public static void assertIdentity(String messagePrefix, Matrix3DReadOnly matrixToAssert, double epsilon) {
        EuclidCoreTestTools.assertIdentity(messagePrefix, matrixToAssert, epsilon, DEFAULT_FORMAT);
    }

    public static void assertIdentity(String messagePrefix, Matrix3DReadOnly matrixToAssert, double epsilon, String format) {
        if (matrixToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given matrix is null."));
        }
        if (!matrixToAssert.isIdentity(epsilon)) {
            String errorMessage = "The matrix is not identity:\n" + EuclidCoreIOTools.getMatrix3DString(DEFAULT_FORMAT, matrixToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertMatrix3DContainsOnlyNaN(Matrix3DReadOnly matrixToAssert) {
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN(null, matrixToAssert);
    }

    public static void assertMatrix3DContainsOnlyNaN(String messagePrefix, Matrix3DReadOnly matrixToAssert) {
        if (matrixToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given matrix is null."));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                if (Double.isNaN(matrixToAssert.getElement(row, column))) continue;
                String errorMessage = "The matrix does not contain only NaN:\n" + EuclidCoreIOTools.getMatrix3DString(DEFAULT_FORMAT, matrixToAssert);
                throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
            }
        }
    }

    public static void assertOrientation3DGeometricallyEquals(Orientation3DReadOnly expected, Orientation3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertOrientation3DGeometricallyEquals(String messagePrefix, Orientation3DReadOnly expected, Orientation3DReadOnly actual, double epsilon) {
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertOrientation3DGeometricallyEquals(String messagePrefix, Orientation3DReadOnly expected, Orientation3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, "Difference of: " + Double.toString(expected.distance(actual)), format);
        }
    }

    public static void assertAxisAngleContainsOnlyNaN(AxisAngleReadOnly axisAngleToAssert) {
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN(null, axisAngleToAssert);
    }

    public static void assertAxisAngleContainsOnlyNaN(String messagePrefix, AxisAngleReadOnly axisAngleToAssert) {
        if (axisAngleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given axis-angle is null."));
        }
        for (int index = 0; index < 4; ++index) {
            if (Double.isNaN(axisAngleToAssert.getElement(index))) continue;
            String errorMessage = "The axis-angle does not contain only NaN:\n" + EuclidCoreIOTools.getAxisAngleString(DEFAULT_FORMAT, axisAngleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertAxisAngleIsSetToZero(AxisAngleReadOnly axisAngleToAssert) {
        EuclidCoreTestTools.assertAxisAngleIsSetToZero(null, axisAngleToAssert);
    }

    public static void assertAxisAngleIsSetToZero(String messagePrefix, AxisAngleReadOnly axisAngleToAssert) {
        if (axisAngleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given axis-angle is null."));
        }
        AxisAngle expected = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        if (!expected.equals(axisAngleToAssert)) {
            String errorMessage = "The axis-angle has not been set to zero:\n" + EuclidCoreIOTools.getAxisAngleString(DEFAULT_FORMAT, axisAngleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertQuaternionIsSetToZero(QuaternionReadOnly quaternionToAssert) {
        EuclidCoreTestTools.assertQuaternionIsSetToZero(null, quaternionToAssert);
    }

    public static void assertQuaternionIsSetToZero(String messagePrefix, QuaternionReadOnly quaternionToAssert) {
        EuclidCoreTestTools.assertQuaternionIsSetToZero(messagePrefix, quaternionToAssert, DEFAULT_FORMAT);
    }

    public static void assertQuaternionIsSetToZero(String messagePrefix, QuaternionReadOnly quaternionToAssert, String format) {
        if (quaternionToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given quaternion is null."));
        }
        Quaternion expected = new Quaternion(0.0, 0.0, 0.0, 1.0);
        if (!expected.equals(quaternionToAssert)) {
            String errorMessage = "The axis-angle has not been set to zero:\n" + EuclidCoreIOTools.getTuple4DString(format, quaternionToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertQuaternionIsUnitary(QuaternionReadOnly quaternionToAssert, double epsilon) {
        EuclidCoreTestTools.assertQuaternionIsUnitary(null, quaternionToAssert, epsilon);
    }

    public static void assertQuaternionIsUnitary(String messagePrefix, QuaternionReadOnly quaternionToAssert, double epsilon) {
        EuclidCoreTestTools.assertQuaternionIsUnitary(messagePrefix, quaternionToAssert, epsilon, DEFAULT_FORMAT);
    }

    public static void assertQuaternionIsUnitary(String messagePrefix, QuaternionReadOnly quaternionToAssert, double epsilon, String format) {
        if (quaternionToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given quaternion is null."));
        }
        if (!quaternionToAssert.isUnitary(epsilon)) {
            String errorMessage = "The quaternion is not unitary: " + EuclidCoreIOTools.getTuple4DString(format, quaternionToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertTuple2DContainsOnlyNaN(Tuple2DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN(null, tupleToAssert);
    }

    public static void assertTuple2DContainsOnlyNaN(String messagePrefix, Tuple2DReadOnly tupleToAssert) {
        if (tupleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given tuple is null."));
        }
        for (int index = 0; index < 2; ++index) {
            if (Double.isNaN(tupleToAssert.getElement(index))) continue;
            String errorMessage = "The tuple does not contain only NaN:\n" + EuclidCoreIOTools.getTuple2DString(DEFAULT_FORMAT, tupleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertTuple2DIsSetToZero(Tuple2DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple2DIsSetToZero(null, tupleToAssert);
    }

    public static void assertTuple2DIsSetToZero(String messagePrefix, Tuple2DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple2DIsSetToZero(messagePrefix, tupleToAssert, DEFAULT_FORMAT);
    }

    public static void assertTuple2DIsSetToZero(String messagePrefix, Tuple2DReadOnly tupleToAssert, String format) {
        if (tupleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given tuple is null."));
        }
        for (int index = 0; index < 2; ++index) {
            if (tupleToAssert.getElement(index) == 0.0) continue;
            String errorMessage = "The tuple has not been set to zero:\n " + EuclidCoreIOTools.getTuple2DString(format, tupleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertTuple3DContainsOnlyNaN(Tuple3DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN(null, tupleToAssert);
    }

    public static void assertTuple3DContainsOnlyNaN(String messagePrefix, Tuple3DReadOnly tupleToAssert) {
        if (tupleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given tuple is null."));
        }
        for (int index = 0; index < 3; ++index) {
            if (Double.isNaN(tupleToAssert.getElement(index))) continue;
            String errorMessage = "The tuple does not contain only NaN:\n" + EuclidCoreIOTools.getTuple3DString(DEFAULT_FORMAT, tupleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertTuple3DIsSetToZero(Tuple3DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple3DIsSetToZero(null, tupleToAssert);
    }

    public static void assertTuple3DIsSetToZero(String messagePrefix, Tuple3DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple3DIsSetToZero(messagePrefix, tupleToAssert, DEFAULT_FORMAT);
    }

    public static void assertTuple3DIsSetToZero(String messagePrefix, Tuple3DReadOnly tupleToAssert, String format) {
        if (tupleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given tuple is null."));
        }
        for (int index = 0; index < 3; ++index) {
            if (tupleToAssert.getElement(index) == 0.0) continue;
            String errorMessage = "The tuple has not been set to zero:\n " + EuclidCoreIOTools.getTuple3DString(format, tupleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertTuple4DContainsOnlyNaN(Tuple4DReadOnly tupleToAssert) {
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN(null, tupleToAssert);
    }

    public static void assertTuple4DContainsOnlyNaN(String messagePrefix, Tuple4DReadOnly tupleToAssert) {
        if (tupleToAssert == null) {
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The given tuple is null."));
        }
        for (int index = 0; index < 4; ++index) {
            if (Double.isNaN(tupleToAssert.getElement(index))) continue;
            String errorMessage = "The tuple does not contain only NaN:\n" + EuclidCoreIOTools.getTuple4DString(DEFAULT_FORMAT, tupleToAssert);
            throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
        }
    }

    public static void assertExceptionIsThrown(Runnable runnable, Class<?> ... acceptableExceptionTypes) {
        EuclidCoreTestTools.assertExceptionIsThrown(null, runnable, acceptableExceptionTypes);
    }

    public static void assertExceptionIsThrown(String messagePrefix, Runnable runnable, Class<?> ... acceptableExceptionTypes) {
        EuclidCoreTestTools.assertExceptionIsThrown(messagePrefix, runnable, null, acceptableExceptionTypes);
    }

    public static void assertExceptionIsThrown(Runnable runnable, String expectedMessageContent, Class<?> ... acceptableExceptionTypes) {
        EuclidCoreTestTools.assertExceptionIsThrown(null, runnable, expectedMessageContent, acceptableExceptionTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertExceptionIsThrown(String messagePrefix, Runnable runnable, String expectedMessageContent, Class<?> ... acceptableExceptionTypes) {
        block8: {
            Exception exceptionCaught = null;
            try {
                runnable.run();
            }
            catch (Exception e2) {
                exceptionCaught = e2;
            }
            finally {
                if (exceptionCaught == null) {
                    throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "The operation should have thrown an exception."));
                }
                boolean isExceptionUnexpected = true;
                for (Class<?> expectedExceptionType : acceptableExceptionTypes) {
                    if (!exceptionCaught.getClass().equals(expectedExceptionType)) continue;
                    isExceptionUnexpected = false;
                }
                if (isExceptionUnexpected) {
                    List list = Stream.of(acceptableExceptionTypes).map(e -> e.getSimpleName()).collect(Collectors.toList());
                    throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "Unexpected exception: expected any of " + String.valueOf(list) + ", actual = " + exceptionCaught.getClass().getSimpleName()));
                }
                if (expectedMessageContent == null || expectedMessageContent.equals(exceptionCaught.getMessage())) break block8;
                throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "Unexpected exception message: expected " + expectedMessageContent + ", actual = " + exceptionCaught.getMessage()));
            }
        }
    }

    public static void throwNotEqualAssertionError(String messagePrefix, EuclidGeometry expected, EuclidGeometry actual, String format) {
        EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, null, format);
    }

    public static void throwNotEqualAssertionError(String messagePrefix, EuclidGeometry expected, EuclidGeometry actual, String differenceAsString, String format) {
        String expectedAsString = expected == null ? "null" : expected.toString(format);
        String actualAsString = actual == null ? "null" : actual.toString(format);
        EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, differenceAsString);
    }

    public static void throwNotEqualAssertionError(String messagePrefix, String expectedAsString, String actualAsString) {
        EuclidCoreTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, null);
    }

    public static void throwNotEqualAssertionError(String messagePrefix, String expectedAsString, String actualAsString, String differenceAsString) {
        Object errorMessage = EuclidCoreTestTools.addPrefixToMessage(messagePrefix, "expected:\n" + expectedAsString + "\n but was:\n" + actualAsString);
        if (differenceAsString != null) {
            errorMessage = (String)errorMessage + "\n" + differenceAsString;
        }
        throw new AssertionError(errorMessage);
    }

    public static void throwAssertionError(String messagePrefix, String errorMessage) {
        throw new AssertionError((Object)EuclidCoreTestTools.addPrefixToMessage(messagePrefix, errorMessage));
    }

    public static String addPrefixToMessage(String prefix, String message) {
        if (prefix != null && !prefix.isEmpty()) {
            return prefix + " " + message;
        }
        return message;
    }
}

