/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class AxisAngleConversion {
    public static final double EPS = 1.0E-12;

    private AxisAngleConversion() {
    }

    public static void convertMatrixToAxisAngle(RotationMatrixReadOnly rotationMatrix, AxisAngleBasics axisAngleToPack) {
        double m00 = rotationMatrix.getM00();
        double m01 = rotationMatrix.getM01();
        double m02 = rotationMatrix.getM02();
        double m10 = rotationMatrix.getM10();
        double m11 = rotationMatrix.getM11();
        double m12 = rotationMatrix.getM12();
        double m20 = rotationMatrix.getM20();
        double m21 = rotationMatrix.getM21();
        double m22 = rotationMatrix.getM22();
        AxisAngleConversion.convertMatrixToAxisAngle(m00, m01, m02, m10, m11, m12, m20, m21, m22, axisAngleToPack);
    }

    public static void convertMatrixToAxisAngle(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, AxisAngleBasics axisAngleToPack) {
        double angle;
        if (EuclidCoreTools.containsNaN(m00, m01, m02, m10, m11, m12, m20, m21, m22)) {
            axisAngleToPack.setToNaN();
            return;
        }
        double x = m21 - m12;
        double y = m02 - m20;
        double z = m10 - m01;
        double s = EuclidCoreTools.norm(x, y, z);
        if (s > 1.0E-12) {
            double sin = 0.5 * s;
            double cos = 0.5 * (m00 + m11 + m22 - 1.0);
            angle = EuclidCoreTools.atan2(sin, cos);
            x /= s;
            y /= s;
            z /= s;
        } else {
            if (Matrix3DFeatures.isIdentity(m00, m01, m02, m10, m11, m12, m20, m21, m22)) {
                axisAngleToPack.setToZero();
                return;
            }
            angle = Math.PI;
            double xx = 0.5 * (m00 + 1.0);
            double yy = 0.5 * (m11 + 1.0);
            double zz = 0.5 * (m22 + 1.0);
            double xy = 0.25 * (m01 + m10);
            double xz = 0.25 * (m02 + m20);
            double yz = 0.25 * (m12 + m21);
            if (xx > yy && xx > zz) {
                x = EuclidCoreTools.squareRoot(xx);
                y = xy / x;
                z = xz / x;
            } else if (yy > zz) {
                y = EuclidCoreTools.squareRoot(yy);
                x = xy / y;
                z = yz / y;
            } else {
                z = EuclidCoreTools.squareRoot(zz);
                x = xz / z;
                y = yz / z;
            }
        }
        axisAngleToPack.set(x, y, z, angle);
    }

    public static void convertQuaternionToAxisAngle(QuaternionReadOnly quaternion, AxisAngleBasics axisAngleToPack) {
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        AxisAngleConversion.convertQuaternionToAxisAngle(qx, qy, qz, qs, axisAngleToPack);
    }

    public static void convertQuaternionToAxisAngle(double qx, double qy, double qz, double qs, AxisAngleBasics axisAngleToPack) {
        if (EuclidCoreTools.containsNaN(qx, qy, qz, qs)) {
            axisAngleToPack.setToNaN();
            return;
        }
        double uNorm = EuclidCoreTools.norm(qx, qy, qz);
        if (uNorm > 1.0E-12) {
            axisAngleToPack.setAngle(2.0 * EuclidCoreTools.atan2(uNorm, qs));
            uNorm = 1.0 / uNorm;
            axisAngleToPack.setX(qx * uNorm);
            axisAngleToPack.setY(qy * uNorm);
            axisAngleToPack.setZ(qz * uNorm);
        } else {
            axisAngleToPack.setToZero();
        }
    }

    public static void convertRotationVectorToAxisAngle(Vector3DReadOnly rotationVector, AxisAngleBasics axisAngleToPack) {
        AxisAngleConversion.convertRotationVectorToAxisAngle(rotationVector.getX(), rotationVector.getY(), rotationVector.getZ(), axisAngleToPack);
    }

    public static void convertRotationVectorToAxisAngle(double rx, double ry, double rz, AxisAngleBasics axisAngleToPack) {
        if (EuclidCoreTools.containsNaN(rx, ry, rz)) {
            axisAngleToPack.setToNaN();
            return;
        }
        double norm = EuclidCoreTools.norm(rx, ry, rz);
        if (norm > 1.0E-12) {
            axisAngleToPack.setAngle(norm);
            norm = 1.0 / norm;
            axisAngleToPack.setX(rx * norm);
            axisAngleToPack.setY(ry * norm);
            axisAngleToPack.setZ(rz * norm);
        } else {
            axisAngleToPack.setToZero();
        }
    }

    public static void convertYawPitchRollToAxisAngle(YawPitchRollReadOnly yawPitchRoll, AxisAngleBasics axisAngleToPack) {
        AxisAngleConversion.convertYawPitchRollToAxisAngle(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll(), axisAngleToPack);
    }

    public static void convertYawPitchRollToAxisAngle(double yaw, double pitch, double roll, AxisAngleBasics axisAngleToPack) {
        if (EuclidCoreTools.containsNaN(yaw, pitch, roll)) {
            axisAngleToPack.setToNaN();
            return;
        }
        double halfYaw = yaw / 2.0;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = pitch / 2.0;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = roll / 2.0;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        double uNorm = EuclidCoreTools.norm(qx, qy, qz);
        if (uNorm > 1.0E-12) {
            axisAngleToPack.setAngle(2.0 * EuclidCoreTools.atan2(uNorm, qs));
            uNorm = 1.0 / uNorm;
            axisAngleToPack.setX(qx * uNorm);
            axisAngleToPack.setY(qy * uNorm);
            axisAngleToPack.setZ(qz * uNorm);
        } else {
            axisAngleToPack.setToZero();
        }
    }
}

