/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.yawPitchRoll.interfaces;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public interface YawPitchRollReadOnly
extends Orientation3DReadOnly {
    @Override
    public double getYaw();

    default public float getYaw32() {
        return (float)this.getYaw();
    }

    @Override
    public double getPitch();

    default public float getPitch32() {
        return (float)this.getPitch();
    }

    @Override
    public double getRoll();

    default public float getRoll32() {
        return (float)this.getRoll();
    }

    @Override
    default public boolean containsNaN() {
        return EuclidCoreTools.containsNaN(this.getYaw(), this.getPitch(), this.getRoll());
    }

    default public boolean isZero(double epsilon) {
        return this.isZeroOrientation(epsilon);
    }

    @Override
    default public boolean isZeroOrientation(double epsilon) {
        return YawPitchRollTools.isZero(this.getYaw(), this.getPitch(), this.getRoll(), epsilon);
    }

    @Override
    default public boolean isOrientation2D(double epsilon) {
        return YawPitchRollTools.isOrientation2D(this.getYaw(), this.getPitch(), this.getRoll(), epsilon);
    }

    @Override
    default public double distance(Orientation3DReadOnly other, boolean limitToPi) {
        return YawPitchRollTools.distance(this, other, limitToPi);
    }

    @Override
    default public double angle(boolean limitToPi) {
        return YawPitchRollTools.angle(this, limitToPi);
    }

    @Override
    default public void get(CommonMatrix3DBasics rotationMatrixToPack) {
        RotationMatrixConversion.convertYawPitchRollToMatrix(this, rotationMatrixToPack);
    }

    @Override
    default public void get(AxisAngleBasics axisAngleToPack) {
        axisAngleToPack.setYawPitchRoll(this.getYaw(), this.getPitch(), this.getRoll());
    }

    @Override
    default public void get(QuaternionBasics quaternionToPack) {
        quaternionToPack.setYawPitchRoll(this.getYaw(), this.getPitch(), this.getRoll());
    }

    @Override
    default public void get(YawPitchRollBasics yawPitchRollToPack) {
        yawPitchRollToPack.set(this.getYaw(), this.getPitch(), this.getRoll());
    }

    @Override
    default public void getRotationVector(Vector3DBasics rotationVectorToPack) {
        RotationVectorConversion.convertYawPitchRollToRotationVector(this.getYaw(), this.getPitch(), this.getRoll(), rotationVectorToPack);
    }

    @Override
    default public void getEuler(Tuple3DBasics eulerAnglesToPack) {
        eulerAnglesToPack.set(this.getRoll(), this.getPitch(), this.getYaw());
    }

    default public void get(double[] yawPitchRollArrayToPack) {
        this.get(0, yawPitchRollArrayToPack);
    }

    default public void get(int startIndex, double[] yawPitchRollArrayToPack) {
        yawPitchRollArrayToPack[startIndex++] = this.getYaw();
        yawPitchRollArrayToPack[startIndex++] = this.getPitch();
        yawPitchRollArrayToPack[startIndex] = this.getRoll();
    }

    default public void get(float[] yawPitchRollArrayToPack) {
        this.get(0, yawPitchRollArrayToPack);
    }

    default public void get(int startIndex, float[] yawPitchRollArrayToPack) {
        yawPitchRollArrayToPack[startIndex++] = this.getYaw32();
        yawPitchRollArrayToPack[startIndex++] = this.getPitch32();
        yawPitchRollArrayToPack[startIndex] = this.getRoll32();
    }

    default public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.getYaw();
            }
            case 1: {
                return this.getPitch();
            }
            case 2: {
                return this.getRoll();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public float getElement32(int index) {
        switch (index) {
            case 0: {
                return this.getYaw32();
            }
            case 1: {
                return this.getPitch32();
            }
            case 2: {
                return this.getRoll32();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.transform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        YawPitchRollTools.transform(this, tupleOriginal, tupleTransformed, checkIfOrientation2D);
    }

    @Override
    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        YawPitchRollTools.transform(this, matrixOriginal, matrixTransformed);
    }

    @Override
    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        YawPitchRollTools.transform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        YawPitchRollTools.inverseTransform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        YawPitchRollTools.inverseTransform(this, tupleOriginal, tupleTransformed, checkIfOrientation2D);
    }

    @Override
    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        YawPitchRollTools.inverseTransform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        YawPitchRollTools.inverseTransform(this, matrixOriginal, matrixTransformed);
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof YawPitchRollReadOnly)) {
            return false;
        }
        YawPitchRollReadOnly other = (YawPitchRollReadOnly)geometry;
        if (!EuclidCoreTools.equals(this.getYaw(), other.getYaw())) {
            return false;
        }
        if (!EuclidCoreTools.equals(this.getPitch(), other.getPitch())) {
            return false;
        }
        return EuclidCoreTools.equals(this.getRoll(), other.getRoll());
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof YawPitchRollReadOnly)) {
            return false;
        }
        YawPitchRollReadOnly other = (YawPitchRollReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals(this.getYaw(), other.getYaw(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getPitch(), other.getPitch(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(this.getRoll(), other.getRoll(), epsilon);
    }

    @Override
    default public String toString(String format) {
        return EuclidCoreIOTools.getYawPitchRollString(format, this);
    }
}

