/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;

public interface Orientation2DBasics
extends Orientation2DReadOnly,
Clearable,
Transformable {
    public void setYaw(double var1);

    @Override
    default public void setToZero() {
        this.setYaw(0.0);
    }

    @Override
    default public void setToNaN() {
        this.setYaw(Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return Orientation2DReadOnly.super.containsNaN();
    }

    default public void set(Orientation2DReadOnly other) {
        this.setYaw(other.getYaw());
    }

    default public void set(Orientation3DReadOnly orientation3DReadOnly) {
        this.setYaw(orientation3DReadOnly.getYaw());
    }

    default public void add(double yaw) {
        this.add(this.getYaw(), yaw);
    }

    default public void add(double yaw1, double yaw2) {
        this.setYaw(EuclidCoreTools.trimAngleMinusPiToPi(yaw1 + yaw2));
    }

    default public void add(Orientation2DReadOnly other) {
        this.add(other.getYaw());
    }

    default public void add(Orientation2DReadOnly orientation1, Orientation2DReadOnly orientation2) {
        this.add(orientation1.getYaw(), orientation2.getYaw());
    }

    default public void sub(double yaw) {
        this.sub(this.getYaw(), yaw);
    }

    default public void sub(Orientation2DReadOnly other) {
        this.sub(other.getYaw());
    }

    default public void sub(double yaw1, double yaw2) {
        this.setYaw(EuclidCoreTools.angleDifferenceMinusPiToPi(yaw1, yaw2));
    }

    default public void sub(Orientation2DReadOnly orientation1, Orientation2DReadOnly orientation2) {
        this.sub(orientation1.getYaw(), orientation2.getYaw());
    }

    default public void interpolate(Orientation2DReadOnly other, double alpha) {
        this.interpolate(this, other, alpha);
    }

    default public void interpolate(Orientation2DReadOnly orientation1, Orientation2DReadOnly orientation2, double alpha) {
        double deltaYaw = EuclidCoreTools.angleDifferenceMinusPiToPi(orientation2.getYaw(), orientation1.getYaw());
        this.add(orientation1.getYaw(), alpha * deltaYaw);
    }

    @Override
    public void applyTransform(Transform var1);

    @Override
    public void applyInverseTransform(Transform var1);
}

