/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.interfaces.Transform;

public interface RotationMatrixBasics
extends CommonMatrix3DBasics,
RotationMatrixReadOnly,
Orientation3DBasics,
Transformable {
    @Override
    default public boolean containsNaN() {
        return RotationMatrixReadOnly.super.containsNaN();
    }

    @Override
    default public void setToZero() {
        this.setIdentity();
    }

    @Override
    default public void invert() {
        this.transpose();
    }

    @Override
    default public void normalize() {
        CommonMatrix3DBasics.super.normalize();
    }

    public void setUnsafe(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);

    @Override
    default public void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        if (!this.isIdentity()) {
            this.checkIfRotationMatrix();
        }
    }

    default public void setAndNormalize(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.normalize();
    }

    @Override
    default public void setAndNormalize(Matrix3DReadOnly matrix) {
        this.setAndNormalize(matrix.getM00(), matrix.getM01(), matrix.getM02(), matrix.getM10(), matrix.getM11(), matrix.getM12(), matrix.getM20(), matrix.getM21(), matrix.getM22());
    }

    default public void setAndNormalize(RotationMatrixReadOnly other) {
        this.set(other);
        this.normalize();
    }

    @Override
    default public void set(Matrix3DReadOnly other) {
        if (other instanceof RotationMatrixReadOnly) {
            this.set((RotationMatrixReadOnly)other);
        } else {
            CommonMatrix3DBasics.super.set(other);
        }
    }

    @Override
    default public void set(Orientation3DReadOnly orientation3DReadOnly) {
        CommonMatrix3DBasics.super.set(orientation3DReadOnly);
    }

    @Override
    public void set(RotationMatrixReadOnly var1);

    @Override
    default public void setAndInvert(Matrix3DReadOnly matrix) {
        this.setAndTranspose(matrix);
    }

    default public void setAndInvert(RotationMatrixReadOnly other) {
        this.setAndTranspose(other);
    }

    @Override
    default public void setAxisAngle(double x, double y, double z, double angle) {
        RotationMatrixConversion.convertAxisAngleToMatrix(x, y, z, angle, this);
    }

    @Override
    default public void setRotationVector(double x, double y, double z) {
        RotationMatrixConversion.convertRotationVectorToMatrix(x, y, z, this);
    }

    @Override
    default public void setQuaternion(double x, double y, double z, double s) {
        RotationMatrixConversion.convertQuaternionToMatrix(x, y, z, s, this);
    }

    @Override
    default public void setYawPitchRoll(double yaw, double pitch, double roll) {
        RotationMatrixConversion.convertYawPitchRollToMatrix(yaw, pitch, roll, this);
    }

    @Override
    default public void setRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Override
    default public void setToYawOrientation(double yaw) {
        RotationMatrixConversion.computeYawMatrix(yaw, this);
    }

    @Override
    default public void setToPitchOrientation(double pitch) {
        RotationMatrixConversion.computePitchMatrix(pitch, this);
    }

    @Override
    default public void setToRollOrientation(double roll) {
        RotationMatrixConversion.computeRollMatrix(roll, this);
    }

    default public void multiply(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiply(this, other, this);
    }

    @Override
    default public void append(Orientation3DReadOnly orientation) {
        RotationMatrixTools.multiply(this, false, orientation, false, (CommonMatrix3DBasics)this);
    }

    default public void multiplyTransposeThis(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiplyTransposeLeft(this, other, this);
    }

    default public void multiplyTransposeOther(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiplyTransposeRight(this, other, this);
    }

    @Override
    default public void appendInvertOther(Orientation3DReadOnly orientation) {
        RotationMatrixTools.multiply(this, false, orientation, true, (CommonMatrix3DBasics)this);
    }

    default public void multiplyTransposeBoth(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiplyTransposeBoth(this, other, this);
    }

    @Override
    default public void appendYawRotation(double yaw) {
        RotationMatrixTools.appendYawRotation(this, yaw, this);
    }

    @Override
    default public void appendPitchRotation(double pitch) {
        RotationMatrixTools.appendPitchRotation(this, pitch, this);
    }

    @Override
    default public void appendRollRotation(double roll) {
        RotationMatrixTools.appendRollRotation(this, roll, this);
    }

    default public void preMultiply(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiply(other, this, this);
    }

    @Override
    default public void prepend(Orientation3DReadOnly orientation) {
        RotationMatrixTools.multiply(orientation, false, this, false, (CommonMatrix3DBasics)this);
    }

    default public void preMultiplyTransposeThis(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiplyTransposeRight(other, this, this);
    }

    default public void preMultiplyTransposeOther(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiplyTransposeLeft(other, this, this);
    }

    @Override
    default public void prependInvertOther(Orientation3DReadOnly orientation) {
        RotationMatrixTools.multiply(orientation, true, this, false, (CommonMatrix3DBasics)this);
    }

    default public void preMultiplyTransposeBoth(RotationMatrixReadOnly other) {
        RotationMatrixTools.multiplyTransposeBoth(other, this, this);
    }

    @Override
    default public void prependYawRotation(double yaw) {
        RotationMatrixTools.prependYawRotation(yaw, this, this);
    }

    @Override
    default public void prependPitchRotation(double pitch) {
        RotationMatrixTools.prependPitchRotation(pitch, this, this);
    }

    @Override
    default public void prependRollRotation(double roll) {
        RotationMatrixTools.prependRollRotation(roll, this, this);
    }

    default public void interpolate(RotationMatrixReadOnly rf, double alpha) {
        this.interpolate(this, rf, alpha);
    }

    default public void interpolate(RotationMatrixReadOnly r0, RotationMatrixReadOnly rf, double alpha) {
        RotationMatrixTools.interpolate(r0, rf, alpha, this);
    }

    @Override
    default public void applyTransform(Transform transform) {
        transform.transform(this);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this);
    }
}

