/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.NotAPositiveDefiniteMatrixException;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public interface Matrix3DReadOnly
extends EuclidGeometry {
    public double getM00();

    public double getM01();

    public double getM02();

    public double getM10();

    public double getM11();

    public double getM12();

    public double getM20();

    public double getM21();

    public double getM22();

    default public double getElement(int row, int column) {
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return this.getM00();
                    }
                    case 1: {
                        return this.getM01();
                    }
                    case 2: {
                        return this.getM02();
                    }
                }
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
            case 1: {
                switch (column) {
                    case 0: {
                        return this.getM10();
                    }
                    case 1: {
                        return this.getM11();
                    }
                    case 2: {
                        return this.getM12();
                    }
                }
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
            case 2: {
                switch (column) {
                    case 0: {
                        return this.getM20();
                    }
                    case 1: {
                        return this.getM21();
                    }
                    case 2: {
                        return this.getM22();
                    }
                }
                throw Matrix3DTools.columnOutOfBoundsException(2, column);
            }
        }
        throw Matrix3DTools.rowOutOfBoundsException(2, row);
    }

    default public void get(double[] matrixArrayToPack) {
        matrixArrayToPack[0] = this.getM00();
        matrixArrayToPack[1] = this.getM01();
        matrixArrayToPack[2] = this.getM02();
        matrixArrayToPack[3] = this.getM10();
        matrixArrayToPack[4] = this.getM11();
        matrixArrayToPack[5] = this.getM12();
        matrixArrayToPack[6] = this.getM20();
        matrixArrayToPack[7] = this.getM21();
        matrixArrayToPack[8] = this.getM22();
    }

    default public void get(int startIndex, double[] matrixArrayToPack) {
        matrixArrayToPack[startIndex++] = this.getM00();
        matrixArrayToPack[startIndex++] = this.getM01();
        matrixArrayToPack[startIndex++] = this.getM02();
        matrixArrayToPack[startIndex++] = this.getM10();
        matrixArrayToPack[startIndex++] = this.getM11();
        matrixArrayToPack[startIndex++] = this.getM12();
        matrixArrayToPack[startIndex++] = this.getM20();
        matrixArrayToPack[startIndex++] = this.getM21();
        matrixArrayToPack[startIndex] = this.getM22();
    }

    default public void get(DMatrix matrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(3, 3, (Matrix)matrixToPack);
        matrixToPack.unsafe_set(0, 0, this.getM00());
        matrixToPack.unsafe_set(0, 1, this.getM01());
        matrixToPack.unsafe_set(0, 2, this.getM02());
        matrixToPack.unsafe_set(1, 0, this.getM10());
        matrixToPack.unsafe_set(1, 1, this.getM11());
        matrixToPack.unsafe_set(1, 2, this.getM12());
        matrixToPack.unsafe_set(2, 0, this.getM20());
        matrixToPack.unsafe_set(2, 1, this.getM21());
        matrixToPack.unsafe_set(2, 2, this.getM22());
    }

    default public void get(int startRow, int startColumn, DMatrix matrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 3, startColumn + 3, (Matrix)matrixToPack);
        int row = startRow;
        int column = startColumn;
        matrixToPack.unsafe_set(row, column++, this.getM00());
        matrixToPack.unsafe_set(row, column++, this.getM01());
        matrixToPack.unsafe_set(row++, column, this.getM02());
        column = startColumn;
        matrixToPack.unsafe_set(row, column++, this.getM10());
        matrixToPack.unsafe_set(row, column++, this.getM11());
        matrixToPack.unsafe_set(row++, column, this.getM12());
        column = startColumn;
        matrixToPack.unsafe_set(row, column++, this.getM20());
        matrixToPack.unsafe_set(row, column++, this.getM21());
        matrixToPack.unsafe_set(row, column, this.getM22());
    }

    default public void getColumn(int column, double[] columnArrayToPack) {
        switch (column) {
            case 0: {
                columnArrayToPack[0] = this.getM00();
                columnArrayToPack[1] = this.getM10();
                columnArrayToPack[2] = this.getM20();
                return;
            }
            case 1: {
                columnArrayToPack[0] = this.getM01();
                columnArrayToPack[1] = this.getM11();
                columnArrayToPack[2] = this.getM21();
                return;
            }
            case 2: {
                columnArrayToPack[0] = this.getM02();
                columnArrayToPack[1] = this.getM12();
                columnArrayToPack[2] = this.getM22();
                return;
            }
        }
        throw Matrix3DTools.columnOutOfBoundsException(2, column);
    }

    default public void getColumn(int column, Tuple3DBasics columnToPack) {
        switch (column) {
            case 0: {
                columnToPack.setX(this.getM00());
                columnToPack.setY(this.getM10());
                columnToPack.setZ(this.getM20());
                return;
            }
            case 1: {
                columnToPack.setX(this.getM01());
                columnToPack.setY(this.getM11());
                columnToPack.setZ(this.getM21());
                return;
            }
            case 2: {
                columnToPack.setX(this.getM02());
                columnToPack.setY(this.getM12());
                columnToPack.setZ(this.getM22());
                return;
            }
        }
        throw Matrix3DTools.columnOutOfBoundsException(2, column);
    }

    default public void getRow(int row, double[] rowArrayToPack) {
        switch (row) {
            case 0: {
                rowArrayToPack[0] = this.getM00();
                rowArrayToPack[1] = this.getM01();
                rowArrayToPack[2] = this.getM02();
                return;
            }
            case 1: {
                rowArrayToPack[0] = this.getM10();
                rowArrayToPack[1] = this.getM11();
                rowArrayToPack[2] = this.getM12();
                return;
            }
            case 2: {
                rowArrayToPack[0] = this.getM20();
                rowArrayToPack[1] = this.getM21();
                rowArrayToPack[2] = this.getM22();
                return;
            }
        }
        throw Matrix3DTools.rowOutOfBoundsException(2, row);
    }

    default public void getRow(int row, Tuple3DBasics rowToPack) {
        switch (row) {
            case 0: {
                rowToPack.setX(this.getM00());
                rowToPack.setY(this.getM01());
                rowToPack.setZ(this.getM02());
                return;
            }
            case 1: {
                rowToPack.setX(this.getM10());
                rowToPack.setY(this.getM11());
                rowToPack.setZ(this.getM12());
                return;
            }
            case 2: {
                rowToPack.setX(this.getM20());
                rowToPack.setY(this.getM21());
                rowToPack.setZ(this.getM22());
                return;
            }
        }
        throw Matrix3DTools.rowOutOfBoundsException(2, row);
    }

    default public boolean containsNaN() {
        return EuclidCoreTools.containsNaN(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public double determinant() {
        return Matrix3DFeatures.determinant(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public void checkIfPositiveDefiniteMatrix() {
        if (!this.isPositiveDefiniteMatrix()) {
            throw new NotAPositiveDefiniteMatrixException(this);
        }
    }

    default public void checkIfRotationMatrix() {
        if (!this.isRotationMatrix()) {
            throw new NotARotationMatrixException(this);
        }
    }

    default public void checkIfMatrix2D() {
        if (!this.isMatrix2D()) {
            throw new NotAMatrix2DException(this);
        }
    }

    default public boolean isIdentity() {
        return this.isIdentity(1.0E-12);
    }

    default public boolean isIdentity(double epsilon) {
        return Matrix3DFeatures.isIdentity(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22(), epsilon);
    }

    default public boolean isZero() {
        return this.isZero(1.0E-12);
    }

    default public boolean isZero(double epsilon) {
        return Matrix3DFeatures.isZero(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22(), epsilon);
    }

    default public boolean isPositiveDefiniteMatrix() {
        return Matrix3DFeatures.isPositiveDefiniteMatrix(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public boolean isRotationMatrix() {
        return this.isRotationMatrix(1.0E-7);
    }

    default public boolean isRotationMatrix(double epsilon) {
        return Matrix3DFeatures.isRotationMatrix(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22(), epsilon);
    }

    default public boolean isMatrix2D() {
        return this.isMatrix2D(1.0E-8);
    }

    default public boolean isMatrix2D(double epsilon) {
        return Matrix3DFeatures.isMatrix2D(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22(), epsilon);
    }

    default public boolean isMatrixSkewSymmetric() {
        return this.isMatrixSkewSymmetric(1.0E-8);
    }

    default public boolean isMatrixSkewSymmetric(double epsilon) {
        return Matrix3DFeatures.isMatrixSkewSymmetric(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22(), epsilon);
    }

    default public boolean isMatrixSymmetric() {
        return this.isMatrixSymmetric(1.0E-8);
    }

    default public boolean isMatrixSymmetric(double epsilon) {
        return Matrix3DFeatures.isMatrixSymmetric(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22(), epsilon);
    }

    default public double maxElement() {
        return Matrix3DFeatures.maxElement(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public double maxAbsElement() {
        return Matrix3DFeatures.maxAbsElement(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public double minElement() {
        return Matrix3DFeatures.minElement(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public double minAbsElement() {
        return Matrix3DFeatures.minAbsElement(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
    }

    default public void transform(Tuple3DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform);
    }

    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        Matrix3DTools.transform(this, tupleOriginal, tupleTransformed);
    }

    default public void addTransform(Tuple3DBasics tupleToTransform) {
        this.addTransform(tupleToTransform, tupleToTransform);
    }

    default public void addTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        Matrix3DTools.addTransform(this, tupleOriginal, tupleTransformed);
    }

    default public void subTransform(Tuple3DBasics tupleToTransform) {
        this.subTransform(tupleToTransform, tupleToTransform);
    }

    default public void subTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        Matrix3DTools.subTransform(this, tupleOriginal, tupleTransformed);
    }

    default public void transform(Tuple2DBasics tupleToTransform) {
        this.transform(tupleToTransform, tupleToTransform, true);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.transform(tupleOriginal, tupleTransformed, true);
    }

    default public void transform(Tuple2DBasics tupleToTransform, boolean checkIfTransformInXYPlane) {
        this.transform(tupleToTransform, tupleToTransform, checkIfTransformInXYPlane);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfRotationInXYPlane) {
        Matrix3DTools.transform(this, tupleOriginal, tupleTransformed, checkIfRotationInXYPlane);
    }

    default public void transform(Matrix3DBasics matrixToTransform) {
        this.transform(matrixToTransform, matrixToTransform);
    }

    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        Matrix3DTools.transform(this, matrixOriginal, matrixTransformed);
    }

    default public void transform(Vector4DBasics vectorToTransform) {
        this.transform(vectorToTransform, vectorToTransform);
    }

    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        Matrix3DTools.transform(this, vectorOriginal, vectorTransformed);
    }

    default public void inverseTransform(Tuple3DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform);
    }

    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        Matrix3DTools.inverseTransform(this, tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple2DBasics tupleToTransform) {
        this.inverseTransform(tupleToTransform, tupleToTransform, true);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.inverseTransform(tupleOriginal, tupleTransformed, true);
    }

    default public void inverseTransform(Tuple2DBasics tupleToTransform, boolean checkIfTransformInXYPlane) {
        this.inverseTransform(tupleToTransform, tupleToTransform, checkIfTransformInXYPlane);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        Matrix3DTools.inverseTransform(this, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    default public void inverseTransform(Matrix3DBasics matrixToTransform) {
        this.inverseTransform(matrixToTransform, matrixToTransform);
    }

    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        Matrix3DTools.inverseTransform(this, matrixOriginal, matrixTransformed);
    }

    default public void inverseTransform(Vector4DBasics vectorToTransform) {
        this.inverseTransform(vectorToTransform, vectorToTransform);
    }

    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        Matrix3DTools.inverseTransform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Matrix3DReadOnly)) {
            return false;
        }
        Matrix3DReadOnly other = (Matrix3DReadOnly)geometry;
        return Matrix3DFeatures.equals(this, other);
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Matrix3DReadOnly)) {
            return false;
        }
        Matrix3DReadOnly other = (Matrix3DReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals(this.getM00(), other.getM00(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM01(), other.getM01(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM02(), other.getM02(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM10(), other.getM10(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM11(), other.getM11(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM12(), other.getM12(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM20(), other.getM20(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(this.getM21(), other.getM21(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(this.getM22(), other.getM22(), epsilon);
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        return this.epsilonEquals(geometry, epsilon);
    }

    @Override
    default public String toString(String format) {
        return EuclidCoreIOTools.getMatrix3DString(format, this);
    }
}

